# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    @summary: 关于存储产品HSSD硬盘误报即将失效问题的预警公告
    @param cli: CLI连接
    @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
    '''

    #返回值定义
    flag = False
    cliRet = ""
    errMsg = ""

    #配置涉及该预警的产品型号和版本
    bugProductModelList = ['S2600T', 'S5500T', 'S5600T', 'S5800T', 'S6800T']
    diskModelList1 = ['HSSD-D322XAM0200', 'HSSD-D3220AM0200', 'HSSD-D322XAM0400', 'HSSD-D3220AM0400']
    diskModelList2 = ['HSSD-D322XAS0100', 'HSSD-D3220AS0100', 'HSSD-D322XAS0200', 'HSSD-D3220AS0200']
    diskModelList3 = ['HSSD-D322XAM0600']
    riskFrimwareVersion1 = "0701"
    riskFrimwareVersion2 = "1502"
    riskFrimwareVersion3 = "0602"

    #判断当前系统型号和版本是否存在风险
    try:
        #查询产品型号
        result, cliRet, productModel, errMsg = cliUtil.getProductModel(cli, LANG)
        if not result or len(productModel) == 0:
            LOGGER.logSysAbnormal()
            return (flag, cliRet, errMsg)

        #判断当前产品型号是否是风险产品型号
        if productModel not in bugProductModelList:
            flag = cliUtil.RESULT_NOSUPPORT
            LOGGER.logPass()
            return (flag, cliRet, errMsg)

        #获取SSD类型的ID值
        flag, exeCmdcliRet, errMsg, ssdIDList = getSSDIdList(cli, LANG)
        cliRet += exeCmdcliRet

        if flag != True:
            return (flag, cliRet, errMsg)

        #查询Modul和Firmware Version字段值。
        cmd = "show disk general disk_id="
        flag = True
        for ssdID in ssdIDList:
            modelInfoCmd = cmd + ssdID
            modelInfoEcho = cliUtil.excuteCmdInCliMode(cli, modelInfoCmd, True, LANG)
            cliRet += modelInfoEcho[1]

            if modelInfoEcho[0] != True:
                errMsg = modelInfoEcho[2]
                return (modelInfoEcho[0], cliRet, errMsg)

            modelInfoEchoDict = cliUtil.getVerticalCliRet(modelInfoEcho[1])
            for line in modelInfoEchoDict:
                model = line.get("Model")
                firmwareVersion = line.get("Firmware Version")
                if model in diskModelList1 and firmwareVersion < riskFrimwareVersion1:
                    flag = False
                    errMsg += common.getMsg(LANG, "ssddisk.model.firmwareversion", (ssdID, model, firmwareVersion))

                if model in diskModelList2 and firmwareVersion < riskFrimwareVersion2:
                    flag = False
                    errMsg += common.getMsg(LANG, "ssddisk.model.firmwareversion", (ssdID, model, firmwareVersion))

                if model in diskModelList3 and firmwareVersion < riskFrimwareVersion3:
                    flag = False
                    errMsg += common.getMsg(LANG, "ssddisk.model.firmwareversion", (ssdID, model, firmwareVersion))

        return(flag, cliRet, errMsg)


    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))


def getSSDIdList(cli, lang):
    '''
    @summary:获取SSD的ID列表
    @param
        cli:CLI
        lang:语言环境
    @return:
        SSDIdList：SSD的ID列表
        cliRet: cli回文
    '''
    cmd = "show disk general |filterRow column=Type predict=equal_to value=SSD"
    ssdIDList = []
    cliRet = ""

    #获取所有SSD的ID
    cmdRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    cliRet = cmdRet[1]
    if cmdRet[0] != True:
        errmsg = cmdRet[2]
        return (cmdRet[0], cliRet, errmsg, [])

    ssdDictList = cliUtil.getHorizontalCliRet(cliRet)
    for ssdInfo in ssdDictList:
        #运行状态的不为ONLINE的不检查，下发命令会出错
        if ssdInfo.get("Running Status") != "Online":
            continue

        ssdIDList.append(ssdInfo.get("ID"))
    return(True, cliRet, "", ssdIDList)