# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    @summary: 存储产品设备在虚拟机业务下控制器复位
    @param cli: CLI连接
    @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
    '''

    #返回值定义
    flag = False
    cliRet = ""
    errMsg = ""

    #配置涉及该预警的产品型号和版本
    bugProductModelList = ['S2600T', 'S5500T', 'S5600T', 'S5800T', 'S6800T']
    bugVersionList = ['V200R002C00','V200R002C00SPC100','V200R002C00SPC200','V200R002C00SPC300','V200R002C00SPC400','V200R002C10','V200R002C20','V200R002C20SPC100']

    #判断当前系统型号和版本是否存在风险
    try:
        #查询产品型号
        result, cliRet, productModel, errMsg = cliUtil.getProductModel(cli, LANG)
        if not result or len(productModel) == 0:
            LOGGER.logSysAbnormal()
            return (flag, cliRet, errMsg)

        #判断当前产品型号是否是风险产品型号
        if productModel not in bugProductModelList:
            flag = cliUtil.RESULT_NOSUPPORT
            LOGGER.logPass()
            return (flag, cliRet, errMsg)

        #查询当前产品软件版本号
        checkRet, currentVersionDictList, hotPatchVersionList = common.parse_upgradePackage(cli, LANG)
        cliRet += '\n' + checkRet[1]
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (checkRet[0], cliRet , checkRet[2])

        #检查当前软件版本是否在属于风险版本
        result = common.checkRiskVersion(currentVersionDictList, bugVersionList, LANG)
        if result == True:
            flag = cliUtil.RESULT_WARNING
            #获取当前环境soft version
            SoftVersionDict = currentVersionDictList[0]
            softCurrentVersion = SoftVersionDict.get("Current Version")
            sotfStandardVersion = common.switchValidVersion(softCurrentVersion)
            errMsg = common.getMsg(LANG, "current.version.maybe.risk", sotfStandardVersion)

            patchVersion = "V200R002C00SPH402"
            softVersion = "V200R002C00SPC400"
            if sotfStandardVersion == softVersion:
            #预设每个控制器的补丁都是ok的
                flag = True

            #循环获取每个控制器的补丁信息
        
                for hotPatchVersion in hotPatchVersionList:
                    hotPatchCurrentVersion = hotPatchVersion.get("Current Version")
                    contrllerID = hotPatchVersion.get("Name")
    
                    if hotPatchCurrentVersion == "--" or hotPatchCurrentVersion == "":
                            errMsg += common.getMsg(LANG, "contrller.not.install.pacth", contrllerID)
                            flag = cliUtil.RESULT_WARNING
                    elif hotPatchCurrentVersion >= patchVersion:
                            continue
                    else:
                        errMsg += common.getMsg(LANG, "contrller.pacth.too.low", (contrllerID, hotPatchCurrentVersion, patchVersion))
                        flag = cliUtil.RESULT_WARNING
        
            return (flag, cliRet, errMsg)

        flag = True
        LOGGER.logPass()

        return (flag, cliRet, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))


