# -*- coding: UTF-8 -*-
import cliUtil
import common
import re
import xlrd
import os

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

'''由于Python库xlrd的局限性，目前只支持解析Excel_2003的文件'''
HITACHI_DISK_FILE_NAME = r'HitachiRiskDisk_Huawei.xls'

def execute(cli):
    '''
    @summary: 关于部分HUC109030CSS600和HUC109060CSS600型号2.5寸日立SAS硬盘长期下电存放导致硬盘故障率偏高的预警公告
    @param cli: CLI连接
    @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
    '''

    #返回值定义
    flag = True
    cliRet = ""
    errMsg = ""
    #从excel中读取风险盘的SN
    hitachiRiskDiskSNList = getDiskSNList()

    try:
        #查询产品型号
        result, cliRet, productModel, errMsg = cliUtil.getProductModel(cli, LANG)
        if not result or len(productModel) == 0:
            LOGGER.logSysAbnormal()
            return (False, cliRet, errMsg)

        #输入命令show disk general，查看硬盘信息
        diskCmd = 'show disk general'
        diskInfoFlag, diskInfoCliRet, diskInfoErrMsg = cliUtil.excuteCmdInCliMode(cli, diskCmd, True, LANG)
        cliRet += diskInfoCliRet

        if diskInfoFlag != True:
            errMsg = diskInfoErrMsg
            return (diskInfoFlag, cliRet, errMsg)

        #查看硬盘状态
        diskStatusCmd = 'show disk general ' \
                        '|filterRow column=Health\sStatus predict=not predict2=equal_to value=Normal' \
                        ' logicOp=or column=Running\sStatus predict=not predict2=equal_to value=Online' \
                        ' logicOp=or column=Model predict=equal_to value=HUC109030CSS600' \
                        ' logicOp=or column=Model predict=equal_to value=HUC109060CSS600'

        diskStatusInfoFlag, diskStatusInfoCliRet, diskStatusInfoErrMsg = cliUtil.excuteCmdInCliMode(cli, diskStatusCmd, True, LANG)
        cliRet += diskStatusInfoCliRet

        if diskStatusInfoFlag != True:
            errMsg += diskStatusInfoErrMsg
            return (diskStatusInfoFlag, cliRet, errMsg)

        #判断命令回显是否为Command executed successfully
        isCmdExecutedSuccessfully = cliUtil.queryResultWithNoRecord(diskStatusInfoCliRet)
        if isCmdExecutedSuccessfully == True:
            return (True, cliRet, "")

        diskInfoDictList = cliUtil.getHorizontalCliRet(diskStatusInfoCliRet)
        hitachiRiskDiskIDList = []
        showDiskIdCliRetCount = 0
        
        for diskInfoDict in diskInfoDictList:
            diskId = diskInfoDict.get('ID')
            healthStatus = diskInfoDict.get('Health Status')
            runningStatus = diskInfoDict.get('Running Status')

            #检查硬盘状态
            if healthStatus != "Normal" or runningStatus != "Online":
                flag = False
                errMsg += common.getMsg(LANG, "disk.status.abnormal", (diskId, healthStatus, runningStatus))
                continue
           
            showDiskIdCmd = 'show disk general disk_id=' + diskId
            showDiskIdFlag, showDiskIdCliRet, showDiskIdErrMsg = cliUtil.excuteCmdInCliMode(cli, showDiskIdCmd, True, LANG)
            #控制'show disk general disk_id=' + diskId命令显示的回显数量
            if showDiskIdCliRetCount <= 10:
                cliRet += showDiskIdCliRet
                showDiskIdCliRetCount += 1

            if showDiskIdFlag != True:
                errMsg += showDiskIdErrMsg
                return (showDiskIdFlag, cliRet, errMsg)

            #收集日立风险盘
            diskInfoDictList = cliUtil.getVerticalCliRet(showDiskIdCliRet)
            for diskInfoDict in diskInfoDictList:
                diskSerialNumber = diskInfoDict.get("Serial Number")
                if diskSerialNumber in hitachiRiskDiskSNList:
                    hitachiRiskDiskIDList.append(diskId)

        if hitachiRiskDiskIDList:
            flag = False
            errMsg += common.getMsg(LANG, "current.version.hitachidisk.risk", ", ".join(hitachiRiskDiskIDList))
       
        return (flag, cliRet, errMsg)

    except Exception, exception:
            LOGGER.logException(exception)
            return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))

def getDiskSNList():
    '''
    Function name      : getDiskList()
    Function describe  : get compass Disk List.
    Return             : compass Disk series Number List
    '''

    excel = Excel()
    excel.open()
    seriesNoList = excel.creatHitachiRiskDiskSNList(['600G', '300G'], 0)

    return seriesNoList

class Excel(object):
    '''
    Class name          : Excel
    Class describe      : interface to read Excel file
    '''

    def __init__(self, filename=HITACHI_DISK_FILE_NAME):
        '''
        Function name      : __init__(filename)
        Function describe  : initialize Class
        '''

        '''将当前路径插入到文件名前'''
        filepath = py_java_env.get('path')
        filename = filepath + os.sep + filename
        self.filename = filename

    def open(self):
        '''
        Function name      : open()
        Function describe  : Open excel file and active sheet
        '''

        self.dada = xlrd.open_workbook(self.filename)

    def creatHitachiRiskDiskSNList(self, sheet_name_list, start_row):
        '''
        Function name      : creatCompassDiskList(sheet_name_list, start_row)
        Function describe  : get compass disk list from excel file
        Input              : sheet_name_list--sheet name List
                             start_row --the row number that start to read
        Return             : compass disk list
        '''
        seriesNoList = []
        for sheet_name in sheet_name_list:
            self.table = self.dada.sheet_by_name(sheet_name)
            nrows = self.table.nrows

            for rownum in range(start_row, nrows, 1):
                cell = unicode(self.table.cell(rownum, 0))

                if re.search('empty', cell, re.IGNORECASE):
                    continue
                elif re.search('HDDSN', cell, re.IGNORECASE):
                    continue
                else:
                    driveSeriesNo = cell.replace('text:u', '').replace('\'', '')
                    seriesNoList.append(driveSeriesNo)

        return seriesNoList
