# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    1、 若Product Model为5300 V3/5500 V3/5600 V3/5800 V3/6800 V3/6900 V3其中之一：
     1.1 如果Product Version属于V300R001，并且控制器软件版本的Current Version低于V300R001C10SPC200，该预警未实施，检查不通过；否则检查通过。
     1.2 如果Product Version属于V300R002，并且控制器软件版本的Current Version低于V300R002C10，该预警未实施，检查不通过；否则检查通过。

    2、 若Product Model为18500/18800/18800F，并且Product Version属于V100R001，如果控制器软件版本不低于V100R001C20SPC200，检查通过，否则检查如下情况：
     2.1 如果当前版本为V100R001C00SPC300，并且未安装V100R001C00SPH302或以上版本热补丁，该预警未实施，检查不通过；否则检查通过。
     2.2 如果当前版本不是V100R001C00SPC300，该预警未实施，检查不通过。
    
    3、 若Product Model为S2600T/S5500T/S5600T/S5800T/S6800T，并且Product Version属于V200R002，如果控制器软件版本不低于V200R002C20SPC200，检查通过，否则检查如下情况：
     3.1 如果当前版本为V200R002C00SPC400，并且未安装V200R002C00SPH402或以上版本热补丁，该预警未实施，检查不通过；否则检查通过。
     3.2 如果当前版本不是V200R002C00SPC400，该预警未实施，检查不通过。
   '''
    
    cliRet = ""
    errMsg = ""
    
    #产品型号配置数据
    modelListV3 = ['5300 V3','5500 V3' ,'5600 V3' ,'5800 V3' ,'6800 V3', '6900 V3']
    modelList18000V1 = ['18500', '18800', '18800F', 'HVS85T', 'HVS88T']
    modelListTV2 = ['S2600T', 'S5500T', 'S5600T', 'S5800T', 'S6800T']
        
    try:
        (flag, cliRet, productInfo, errMsg) = cliUtil.getProductModelVersion(cli, LANG)
        if flag != True or len(productInfo) == 0: 
            LOGGER.logSysAbnormal()
            return (flag, cliRet, errMsg)
        
        #获取设备型号和版本类型
        productModel, productVersion = productInfo[0],productInfo[1] 
        #根据设备型号，选择执行哪条判断标准
        if productModel in modelListV3:
            checkRet = preWarnningCheckV3(cli, productVersion)
        elif productModel in modelList18000V1:
            checkRet = preWarnningCheckOther(cli, productVersion)
        elif productModel in modelListTV2:
            checkRet = preWarnningCheckOther(cli, productVersion)
        else:
            return (cliUtil.RESULT_NOSUPPORT, cliRet, errMsg)
        
        cliRet += checkRet[1]
        return (checkRet[0], cliRet, checkRet[2])

    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))


def preWarnningCheckV3(cli, productVersion):
    '''
    @summary: 判断modelList1中的V3产品型号是否实施预警
    @return: (flag, cliRet, errMsg)
        flag: 
            True：检查通过
            False：检查不通过
        cliRet：
            Flag为True时，返回设备上的信息
            Flag为False时，返回cli回显结果
        errMsg：错误消息
    '''
    
    flag = True
    cliRet = ""
    errMsg = ""
    #V3版本配置数据
    solutionVersionList = [
                       {'RVersion': 'V300R001', 'upgradeSolutionVersion': 'V300R001C10SPC200'},
                       {'RVersion': 'V300R002', 'upgradeSolutionVersion': 'V300R002C10'}
                       ]
    
    try:
        #根据所属R版本，获得问题解决的升级版本
        upgradeSolutionVersion = ""
        for vlist in solutionVersionList:
            if vlist.get("RVersion") in productVersion:
                upgradeSolutionVersion = vlist.get("upgradeSolutionVersion") 
                break      
        
        if len(upgradeSolutionVersion) == 0:
            return (cliUtil.RESULT_NOSUPPORT, cliRet, errMsg)
        
        # 获得产品版本、补丁版本
        (checkRet,softwareVersionList,hotPatchVersionList) = common.parse_upgradePackage(cli, LANG)
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return checkRet
        cliRet = checkRet[1]
        
        for softwareVersion in softwareVersionList:
            contorllerID = softwareVersion.get("Name")
            originalContorllerVersion = softwareVersion.get("Current Version")
            standardContorllerVersion = common.switchValidVersion(originalContorllerVersion)
            
            if standardContorllerVersion < upgradeSolutionVersion:
                errMsg += common.getMsg(LANG, "contrller.software.version.too.low", (contorllerID,originalContorllerVersion,upgradeSolutionVersion))
                LOGGER.logNoPass("Controller [%s]: Current version %s is earlier than problem-solved version (%s). " 
                                 % (contorllerID,originalContorllerVersion,upgradeSolutionVersion))
                flag = False
             
        return (flag, cliRet, errMsg)
                
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
    
    
def preWarnningCheckOther(cli, productVersion):
    '''
    @summary: 判断modelList2中的18000V1产品型号是否实施预警
    @return: (flag, cliRet, errMsg)
        flag: 
            True：检查通过
            False：检查不通过
        cliRet：
            Flag为True时，返回设备上的信息
            Flag为False时，返回cli回显结果
        errMsg：错误消息
    '''
    
    flag = True
    cliRet = ""
    errMsg = ""
    #18000V1R1和TV2R2配置数据
    solutionVersionList = [
                              {'RVersion': 'V100R001', 'upgradeSolutionVersion': 'V100R001C20SPC200',
                               'specialSoftVersion': 'V100R001C00SPC300','patchSolutionVersion': 'V100R001C00SPH302'},
                              {'RVersion': 'V200R002', 'upgradeSolutionVersion': 'V200R002C20SPC200',
                               'specialSoftVersion': 'V200R002C00SPC400', 'patchSolutionVersion': 'V200R002C00SPH402'}
                              ]
    
    try:
        #根据所属R版本，获得问题解决的升级版本
        upgradeSolutionVersion, specialSoftVersion, patchSolutionVersion  = "","",""
        for vlist in solutionVersionList:
            if vlist.get("RVersion") in productVersion:
                upgradeSolutionVersion = vlist.get("upgradeSolutionVersion") 
                specialSoftVersion = vlist.get("specialSoftVersion")
                patchSolutionVersion = vlist.get("patchSolutionVersion") 
                break             
        
        if len(upgradeSolutionVersion) == 0 or len(specialSoftVersion) == 0 or len(patchSolutionVersion) == 0:
            return (cliUtil.RESULT_NOSUPPORT, cliRet, errMsg)         
        
        #获得产品版本、补丁版本
        (checkRet,softwareVersionList,hotPatchVersionList) = common.parse_upgradePackage(cli, LANG)
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return checkRet
        cliRet = checkRet[1]
                
        for softwareVersion in softwareVersionList:
            contorllerID = softwareVersion.get("Name")
            originalContorllerVersion = softwareVersion.get("Current Version")
            standardContorllerVersion = common.switchValidVersion(originalContorllerVersion)
            
            if standardContorllerVersion >= upgradeSolutionVersion:
                continue
                
            elif standardContorllerVersion == specialSoftVersion:
                compareRet = common.hotPatchVersionCompare(contorllerID, hotPatchVersionList, patchSolutionVersion, LANG)                
                if compareRet[0] != True:
                    errMsg += common.getMsg(LANG, "contrller.version.patch.too.low", (contorllerID , originalContorllerVersion , upgradeSolutionVersion , patchSolutionVersion))
                    LOGGER.logNoPass("Controller [%s]: Current version %s is earlier than problem-solved version (%s) and no patch has been installed or the installed patch version is earlier than %s." % 
                                     (contorllerID , originalContorllerVersion , upgradeSolutionVersion , patchSolutionVersion))
                    flag = False
                                    
            else:
                errMsg += common.getMsg(LANG, "contrller.software.version.too.low", (contorllerID,originalContorllerVersion,upgradeSolutionVersion))
                LOGGER.logNoPass("Controller[%s]: Current version %s is earlier than problem-solved version (%s)." %
                                (contorllerID,originalContorllerVersion,upgradeSolutionVersion))
                flag = False
        
        return (flag, cliRet, errMsg)
                
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
    
    
