# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    @summary: 存储产品SSLv3 POODLE安全漏洞问题
    @param cli: CLI连接
    @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
    '''
    
    #返回值定义
    flag = False
    cliRet = ""
    errMsg = ""
    
    #配置涉及该预警的产品型号和版本
    bugProductModelList = ['S2600T', 'S5500T', 'S5600T', 'S5800T', 'S6800T']
    bugVersionList = ['V200R002C10', 'V200R002C20']
    bugVersionStartsWith = ['V200R001', 'V200R002C00']
    
    #判断当前系统型号和版本是否存在风险
    try:
        #查询产品型号
        result, cliRet, productModel, errMsg = cliUtil.getProductModel(cli, LANG)
        if not result or len(productModel) == 0:
            LOGGER.logSysAbnormal()
            return (flag, cliRet, errMsg)
        
        #判断当前产品型号是否是风险产品型号
        if productModel not in bugProductModelList:
            flag = cliUtil.RESULT_NOSUPPORT
            LOGGER.logPass()
            return (flag, cliRet, errMsg)
            
        #查询当前产品软件版本号
        checkRet, currentVersionDictList, hotPatchVersionList = common.parse_upgradePackage(cli, LANG)
        cliRet += '\n' + checkRet[1]
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (checkRet[0], cliRet , checkRet[2])
        
        #获取当前环境soft version
        SoftVersionDict = currentVersionDictList[0]
        softCurrentVersion = SoftVersionDict.get("Current Version")
        sotfStandardVersion = common.switchValidVersion(softCurrentVersion)
        errMsg = common.getMsg(LANG, "current.version", sotfStandardVersion)
        
        #检查当前软件版本是否在为风险版本列表中的版本
        result = common.checkRiskVersion(currentVersionDictList, bugVersionList, LANG)
        if result == True:
            return (flag, cliRet, errMsg)
        
        #检查当前版本是否为V200R002C00SPC400，且是否已安装V200R002C00SPH402及之后的补丁
        softVersion = "V200R002C00SPC400"
        patchVersion = "V200R002C00SPH402"
        
        if sotfStandardVersion == softVersion:
            #预设每个控制器的补丁都是ok的
            flag = True
            
            #循环获取每个控制器的补丁信息
            for hotPatchVersion in hotPatchVersionList:
                hotPatchCurrentVersion = hotPatchVersion.get("Current Version")
                contrllerID = hotPatchVersion.get("Name")
                if hotPatchCurrentVersion == "--" or hotPatchCurrentVersion == "":
                    errMsg += common.getMsg(LANG, "contrller.not.install.pacth", contrllerID)
                    flag = False
                elif hotPatchCurrentVersion >= patchVersion:
                    continue
                else:
                    errMsg += common.getMsg(LANG, "contrller.pacth.too.low", (contrllerID, hotPatchCurrentVersion, patchVersion))
                    flag = False  
            
            #检查结果为通过时不需要显示提示信息
            if flag == True:
                errMsg = ""
                
            return(flag, cliRet, errMsg)
        
        #检查当前版本是否属于指定的风险版本
        for versionHead in bugVersionStartsWith:
            if sotfStandardVersion.startswith(versionHead):
                return (False, cliRet, common.getMsg(LANG, "current.version", sotfStandardVersion))
        
        #当前版本不存在问题
        flag = True
        LOGGER.logPass()
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
    
    
    