# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

#配置数据
#Product Model信息
EIT_P_S_MODEL_DATA = {
                 'V300R002':['5300 V3','5500 V3' ,'5600 V3' ,'5800 V3' ,'6800 V3'],
                 }

#控制器参考版本
REF_VERSION = {
               'V300R002':'V300R002C10SPC100',
               }

def execute(cli):
    '''
    若Product Model为5300 V3/5500 V3/5600 V3/5800 V3/6800 V3其中之一，并且Product Version属于V300R002，
    如果控制器软件版本的Current Version低于V300R002C10SPC100，该预警未实施，检查不通过；否则检查通过。
    '''
    
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        ( flag, cliRet, productInfo, errMsg ) = cliUtil.getProductModelVersion(cli, LANG)
        if flag != True or len(productInfo) == 0: 
            LOGGER.logSysAbnormal()
            return (flag, cliRet, errMsg)
        #获取设备型号和版本类型
        product_model, product_version = productInfo[0],productInfo[1]
        
        RVersion = product_version[:8]
        targetModel = EIT_P_S_MODEL_DATA.get(RVersion, None)
        
        if targetModel is None or product_model not in targetModel:
            flag = cliUtil.RESULT_NOSUPPORT
            LOGGER.logNoPass('product_model is [%s] product_version is [%s]' % (product_model,product_version))
            return (flag, cliRet, errMsg)
        
        versionType = REF_VERSION[RVersion]
        (checkRet,softwareVersionList,hotPatchVersionList) = common.parse_upgradePackage(cli, LANG)
        cliRet += checkRet[1]
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (checkRet[0] , cliRet , checkRet[2]) 
                         
        #判断当前阵列版本是否低于指定版本
        flag, errMsg = common.CurrentVersionCmp(softwareVersionList, versionType,LANG)
            
        if flag:
            LOGGER.logPass()        
                  
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))

