# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    若Product Model为5300 V3/5500 V3/5600 V3/5800 V3/6800 V3其中之一，如果Product Version不为V300R002C10SPC100，则不涉及；如果是V300R002C10SPC100版本，检查是否安装V300R002C10SPH102或以上版本热补丁，如果未安装，则该预警未实施，检查不通过；否则检查通过。
   '''
    
    flag = True
    cliRet = ""
    errMsg = ""
    
    #配置数据
    modelList = ['5300 V3','5500 V3' ,'5600 V3' ,'5800 V3' ,'6800 V3']
    solutionVersion = {'specialSoftVersion': 'V300R002C10SPC100', 'patchSolutionVersion':' V300R002C10SPH102' }

    try:
        (flag, cliRet,product_model, errMsg) = cliUtil.getProductModel(cli, LANG)
        if flag != True or len(product_model) == 0: 
            LOGGER.logSysAbnormal()
            return (flag, cliRet, errMsg)
        
        productModel = product_model  
        if productModel not in modelList:
            flag = cliUtil.RESULT_NOSUPPORT
            return (flag, cliRet, errMsg)
        
        (checkRet,softwareVersionList,hotPatchVersionList) = common.parse_upgradePackage(cli, LANG)
        cliRet += checkRet[1]
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (checkRet[0] , cliRet , checkRet[2])        
                       
        for softwareVersion in softwareVersionList:
            contorllerID = softwareVersion.get("Name")
            originalContorllerVersion = softwareVersion.get("Current Version")
            standardContorllerVersion = common.switchValidVersion(originalContorllerVersion)
                           
            if standardContorllerVersion != solutionVersion.get("specialSoftVersion"):
                flag = cliUtil.RESULT_NOSUPPORT
                continue
            
            compareRet = common.hotPatchVersionCompare(contorllerID, hotPatchVersionList, solutionVersion.get("patchSolutionVersion"), LANG)
            if compareRet[0] != True:
                flag = False
                errMsg += compareRet[1]
      
        return (flag, cliRet, errMsg)
                
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
