# -*- coding: UTF-8 -*-
import cliUtil
import common


MEMORY_THRESHOLD = 40 * 1024  #40M

def execute(cli):
    '''
    @summary: OceanStor V3系列产品客户端查询CIFS共享导致控制器复位
    @param cli: CLI连接
    @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
    '''
    
    #返回值定义
    flag = False
    cliRet = ""
    errMsg = ""
    
    LANG = common.getLang(py_java_env)
    LOGGER = common.getLogger(PY_LOGGER, __file__)

    #配置涉及该预警的产品型号和版本
    bugProductModelList = ['5300 V3', '5500 V3', '5600 V3', '5800 V3', '6800 V3']
    bugVersionList = ['V300R002C00', 'V300R002C00SPC100', 'V300R002C10', 'V300R002C10SPC100']
    repairHotPatchDict = {"V300R002C10SPC100":"V300R002C10SPH103"}
    
    try:
        #查询产品型号
        result, cliRet, productModel, errMsg = cliUtil.getProductModel(cli, LANG)
        if not result or len(productModel) == 0:
            LOGGER.logSysAbnormal()
            return (flag, cliRet, errMsg)
        
        #判断当前产品型号是否是风险产品型号
        if productModel not in bugProductModelList:
            flag = cliUtil.RESULT_NOSUPPORT
            LOGGER.logPass()
            return (flag, cliRet, errMsg)
            
        #查询当前产品软件版本号
        checkRet, currentVersionDictList, hotPatchVersionList = common.parse_upgradePackage(cli, LANG)
        cliRet += '\n' + checkRet[1]
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (checkRet[0], cliRet , checkRet[2])
        
        #获取当前版本和热补丁版本
        flag, currentVersion, errInfo = common.getStandardVersion(currentVersionDictList, LANG)
        if not flag:
            return(False, cliRet, errInfo)
        
        flag, hotPatchVersion, errInfo = common.getStandardVersion(hotPatchVersionList, LANG)
        if not flag:
            return(False, cliRet, errInfo)
        
        #检查当前软件版本是否在属于风险版本
        continueCheck, errInfo = common.isRiskVersion(LANG, currentVersion, bugVersionList, hotPatchVersion, repairHotPatchDict)
        errMsg += errInfo
        if not continueCheck:
            return (True, cliRet, errInfo)
           
        #当前版本是风险版本，需要进一步查看cifs服务状态,cifs关闭检查通过
        cmd = "show service cifs"
        result, cifsInfo, errInfo = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRet += '\n' + cifsInfo
        errMsg += errInfo
        if result != True:
            return(flag, cliRet, errInfo)
        
        result = isCifsServerOpen(cifsInfo) 
        #cifs服务未开启
        if result == False:
            flag = True
            return (flag, cliRet, errMsg)
        
        #cifs服务开启，检查结果至少是建议优化
        flag = cliUtil.RESULT_WARNING
        errMsg += common.getMsg(LANG, "open.cifs.service")
        
        #cmr_msrpc进程占用的内存大小超过40M，检查不通过
        cmd = "ps -aux"
        checkRet = cliUtil.excuteCmdInMinisystemMode(cli, cmd, True, LANG, LOGGER)

        processinfo = checkRet[1].splitlines()
        for line in processinfo:
            if len(line.split()) != 11:
                continue
            
            if line.split()[-1].strip() == "cmr_msrpc":
                memUsed = line.split()[5].strip()
                if int(memUsed) >= MEMORY_THRESHOLD:
                    flag = False
                
                errMsg += common.getMsg(LANG, "cmr_msrpc.used.memory", memUsed) 
                cliRet += "\nStorage: minisystem>ps -aux\n...\n%s\n..." % line 
                break
   
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal")) 
    

def isCifsServerOpen(cliRet):
    '''
    @summary: 查询CIFS共享服务是否开启
    @param cli: cli链接
    @return: 通过标识 as flag
    '''
    checkKey = "Running Status"
    cifsStart = "Start"
    flag = False
    
    cliRetLineList = cliRet.splitlines()
    for line in cliRetLineList:
        cifsStatus = line.split(':')
        if len(cifsStatus) < 2:
            continue
        if cifsStatus[0].strip() == checkKey and cifsStatus[1].strip() == cifsStart:
            flag = True
            break
        elif cifsStatus[0].strip() == checkKey:
            flag = False
            break
        
    return flag
        
    
    
    
    