# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    @summary: 关于存储产品HSSD硬盘误报低温告警问题的预警公告
    @param cli: CLI链接
    @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
    '''

    errMsg = ""
    cliRet = ""
    allCliRet = ""

    #配置设计问题的型号

    BUG_STOR_DICT = {
"S2600T":("V200R002",),
"S5500T":("V200R002",),
"S5600T":("V200R002",),
"S5800T":("V200R002",),
"S6800T":("V200R002",),
"2800 V3":("V300R001","V300R003"),
"5300 V3":("V300R001","V300R002","V300R003"),
"5500 V3":("V300R001","V300R002","V300R003"),
"5600 V3":("V300R001","V300R002","V300R003"),
"5800 V3":("V300R001","V300R002","V300R003"),
"6800 V3":("V300R001","V300R002","V300R003"),
"6900 V3":("V300R001",),
"18500":("V100R001",),
"18800":("V100R001",),
"18800F":("V100R001",),
}

    try:
        #查询当前系统的设备型号
        result, cliRet, productModelList, errMsg = cliUtil.getProductModelVersion(cli, LANG)
        if not result or len(productModelList) <= 1:
            LOGGER.logSysAbnormal()
            return (False, cliRet, errMsg)
        allCliRet += cliRet
        productModelVersion = productModelList[1]
        productModel = productModelList[0]
        #判断当前产品型号是否是风险产品型号
        for bugProductModel in BUG_STOR_DICT.keys():
            if productModel == bugProductModel and productModelVersion[:8] not in BUG_STOR_DICT.get(bugProductModel): 
                LOGGER.logPass()
                return (cliUtil.RESULT_NOSUPPORT, allCliRet, errMsg)

        errMsg += common.getMsg(LANG, "current.version", productModelVersion)
        isCmdExeSucc, statusCliRet, statusErrMsg, faultDiskList = common.getFaultDiskInfo(cli, LANG)
        allCliRet += statusCliRet
        errMsg += statusErrMsg

        if isCmdExeSucc != True:
            return (isCmdExeSucc, allCliRet, errMsg)
            
        #判断是否存在涉及问题的HSSD硬盘
        isCmdExeSucc, diskCliRet, diskErrMsg, riskHSSDList = getRiskHSSD(cli, LANG)
        allCliRet += diskCliRet
        errMsg += diskErrMsg
        
        if isCmdExeSucc != True:
            return (isCmdExeSucc, allCliRet, errMsg)

        #若存在故障盘或存在涉及问题的HSSD硬盘，flag置为False
        if riskHSSDList or faultDiskList:
            return (False, allCliRet, errMsg)
        else:
            return (True, allCliRet, "")

    except Exception, exception:
        LOGGER.logException(exception)
        return (False, allCliRet, common.getMsg(LANG, "query.result.abnormal"))

def getRiskHSSD(cli, lang):
    '''
    @summary: 判断是否存在涉及问题的硬盘
    @param cli: CLI链接
    @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
    '''

    errMsg = ""
    cliRet = ""
    riskDiskIdList = []

    cmd = "show disk general " \
          "|filterRow column=Model predict=equal_to value=HSSD-D3J2LAM5400 " \
          "logicOp=or column=Model predict=equal_to value=HSSD-D3J2LAM5600 " \
          "logicOp=or column=Model predict=equal_to value=HSSD-D3J2JAM5400 " \
          "logicOp=or column=Model predict=equal_to value=HSSD-D3J2JAM5600 " \
          "logicOp=and column=Firmware\sVersion predict=less_equal value=8803"

    #判断命令是否执行成功
    cmd4Flag, cmd4CliRet, cmd4ErrMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    cliRet = cmd4CliRet
    if cmd4Flag != True:
        errMsg = cmd4ErrMsg
        return (cmd4Flag, cliRet, errMsg, [])

    #判断命令回显是否为Command executed successfully
    isCmdExeSucc = cliUtil.queryResultWithNoRecord(cmd4CliRet)
    if isCmdExeSucc:
        return (True, cliRet, "", [])

    #硬盘中存在风险盘，对其进行分析
    diskInfoDictList = cliUtil.getHorizontalCliRet(cmd4CliRet)
    for diskInfoDict in diskInfoDictList:
        riskDiskIdList.append(diskInfoDict.get('ID'))
        
    if riskDiskIdList: 
        errMsg = common.getMsg(LANG, "current.version.exists.risk.hssd", ", ".join(riskDiskIdList))
        
    return (True, cliRet, errMsg, riskDiskIdList)