# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    @summary: 关于存储产品部分版本不支持4K盘导致主机业务中断问题的预警公告
    @param cli: CLI链接
    @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
    '''

    #配置涉及该预警的产品型号和版本
    cliRet = ""
    errMsg = ""

    #配置风险产品类型和风险版本
    bugProductModelList_TV2 = ['S2600T', 'S5500T', 'S5600T', 'S5800T', 'S6800T']
    bugVersionList_TV2 = ['V200R002C00', 'V200R002C00SPC100', 'V200R002C00SPC200', 'V200R002C00SPC300', 'V200R002C00SPC400', 'V200R002C10']
    bugProductModelList_18000 = ['HVS85T', 'HVS88T', '18500', '18800', '18800F']
    bugVersionList_18000 = ['V100R001C00', 'V100R001C00SPC100', 'V100R001C00SPC200', 'V100R001C00SPC300', 'V100R001C10']
    bugVersionList = []
    
    #判断当前系统型号和版本是否存在风险
    try:
        #查询产品型号
        result, cliRet, productModel, errMsg = cliUtil.getProductModel(cli, LANG)
        if not result or len(productModel) == 0:
            LOGGER.logSysAbnormal()
            return (False, cliRet, errMsg)

        #判断当前产品型号是否是风险产品型号
        if productModel not in bugProductModelList_TV2 and productModel not in bugProductModelList_18000:
            flag = cliUtil.RESULT_NOSUPPORT
            LOGGER.logPass()
            return (flag, cliRet, errMsg)

        #查询当前产品软件版本号
        checkRet, currentVersionDictList, hotPatchVersionList = common.parse_upgradePackage(cli, LANG)
        cliRet += checkRet[1]
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (checkRet[0], cliRet , checkRet[2])

        #获取当前环境soft version
        SoftVersionDict = currentVersionDictList[0]
        softCurrentVersion = SoftVersionDict.get("Current Version")
        sotfStandardVersion = common.switchValidVersion(softCurrentVersion)
        errMsg += common.getMsg(LANG, "current.version", sotfStandardVersion)
        
        #根据产品型号指定风险列表
        if productModel in bugProductModelList_TV2:
            bugVersionList = bugVersionList_TV2
        else:
            bugVersionList = bugVersionList_18000
            
        #判断当前阵列版本是否在指定的风险版本中
        isRiskVer = True
        result = common.checkRiskVersion(currentVersionDictList, bugVersionList, LANG)
        if not result:
            isRiskVer = False

        isCmdExeSucc, faultCliRet, faultErrMsg, faultDiskLis  = common.getFaultDiskInfo(cli, LANG)
        cliRet += faultCliRet
        errMsg += faultErrMsg
        
        #命令执行失败
        if isCmdExeSucc != True: 
            return (isCmdExeSucc, cliRet, errMsg)
        
        #不属于风险版本但有故障盘
        if not isRiskVer:
            if faultDiskLis:
                return (False, cliRet, errMsg)
            else:
                return (True, cliRet, '')

        #判断硬盘是否存在于4K盘
        isCmdExeSucc, fkcliRet, fkerrMsg, fkDiskList = common.get4kDiskInfo(cli, LANG)
        cliRet += fkcliRet
        errMsg += fkerrMsg
        
        #命令执行失败
        if isCmdExeSucc != True: 
            return (isCmdExeSucc, cliRet, errMsg)

        #存在于4K盘或故障盘
        if fkDiskList or faultDiskLis:
            return (False, cliRet, errMsg)
        
        return (True, cliRet, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))


