# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    @summary:4KB硬盘上处理随机小IO读写低概率导致业务异常
    '''
    
    cliRet = ""
    errMsg = ""
    
    #定义风险型号和版本号
    bugProduct_TV2 = ("S2600T", "S5500T", "S5600T", "S5800T", "S6800T")
    bugVersion_TV2 = ("V200R002C10","V200R002C20", "V200R002C20SPC200", "V200R002C30")
    repairHotPatchDict_TV2 = {"V200R002C30":"V200R002C30SPH001"}
    bugProduct_V3 = ("5300 V3", "5500 V3", "5600 V3", "5800 V3", "6800 V3", "6900 V3")
    bugVersion_V3 = ("V300R001C00","V300R001C10", "V300R001C10SPC100", "V300R001C10SPC200", "V300R001C20","V300R002C00", "V300R002C00SPC100")
    repairHotPatchDict_V3 = {"V300R001C20":"V300R001C20SPH001"}
    bugProduct_18000 = ("HVS85T", "HVS88T", "18500", "18800", "18800F")
    bugVersion_18000 = ("V100R001C10","V100R001C20", "V100R001C20SPC100", "V100R001C20SPC200", "V100R001C20LNLT01", "V100R001C20SPC300", "V100R001C30")
    repairHotPatchDict_18000 = {"V100R001C30":"V100R001C30SPH001"}
        
     #查询产品型号
    result, cliRet, productModel, errMsg = cliUtil.getProductModel(cli, LANG)

    if not result:
        return (False, cliRet, errMsg)
    if (productModel not in bugProduct_TV2) and\
        (productModel not in bugProduct_V3) and\
        (productModel not in bugProduct_18000):
        return (cliUtil.RESULT_NOSUPPORT, cliRet, "")
    
    #获取版本号和补丁版本号，并判断是否为风险版本
    resultList, currentVersionDictList, hotPatchVersionDictList = common.parse_upgradePackage(cli, LANG)
    cliRet += resultList[1]
    if resultList[0] != True:
        return (resultList[0], cliRet, resultList[2])
    
    result, currentVersion, errInfo = common.getStandardVersion(currentVersionDictList, LANG)
    if not result:
        errMsg += errInfo
        return (False, cliRet, errMsg)

    result, hotPatchVersion, errInfo = common.getStandardVersion(hotPatchVersionDictList, LANG)
    if not result:
        errMsg += errInfo
        return (False, cliRet, errMsg)
      
    #根据不同型号检查版本和热补丁是否符合要求
    if productModel in bugProduct_TV2:
        continueCheck, errInfo = common.isRiskVersion(LANG, currentVersion, bugVersion_TV2, hotPatchVersion, repairHotPatchDict_TV2)
    elif productModel in bugProduct_V3:
        continueCheck, errInfo = common.isRiskVersion(LANG, currentVersion, bugVersion_V3, hotPatchVersion, repairHotPatchDict_V3)
    elif productModel in bugProduct_18000:
        continueCheck, errInfo = common.isRiskVersion(LANG, currentVersion, bugVersion_18000, hotPatchVersion, repairHotPatchDict_18000)

    if not continueCheck:
        return (True, cliRet, errMsg)
    
    #查询是否存在4K盘
    result, cmdRet, errInfo, diskSectorSizeDictList = common.getDiskSectorSize(cli, LANG)
    cliRet += cmdRet
    errMsg += errInfo
    if not result:
        return (result, cliRet, errMsg)
    
    result, is4KDiskIdList, errInfo = is4KDiskWithSectorSize(diskSectorSizeDictList,LANG)
    errMsg += errInfo
    if result:
        return (False, cliRet, errMsg)
    
    return (True, cliRet, errMsg)
    
def is4KDiskWithSectorSize(diskSectorSizeDictList, lang):
    '''
    @summary: 根据扇区大小判断是否为4K盘
    '''
    is4KDiskList = []
    for diskSectorSizeDict in diskSectorSizeDictList:
        diskId = diskSectorSizeDict.get("ID")
        sectorSizeStr = diskSectorSizeDict.get("Sector Size")
        
        #4196B=4.0625KB，显示为4.062KB，需要处理
        if sectorSizeStr == "4.062KB":
            sectorSizeStr = "4.0625KB"
        result, sectorSizeNum = common.changUnit2B(sectorSizeStr)
        if not result:
            errMsg = common.getMsg(lang, "Change.unit.failed")
            return (True, [], errMsg)
        
        if sectorSizeNum == 4096.0 or sectorSizeNum == 4160.0:
            is4KDiskList.append(diskId)
        
    if is4KDiskList:
        errMsg = common.getMsg(lang, "exist.4K.disk", ', '.join(is4KDiskList))
        return (True, is4KDiskList, errMsg)
    
    return(False, [], "")
                
                
                
        
        
        
    
