# -*- coding:utf-8 -*-
import cliUtil
import common
import config

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
all_cli_ret = ''
all_err_msg = ''


def execute(cli):
    """
    SC2200007215/存储低端产品控制器整改公告
    1、以admin用户登录存储
    2、输入命令show controller general查看控制器条码
    单独说明：
    1、涉及产品有2600 V3/5300 V5,涉及版本有V3R5、V3R6、V5R7
    2、目前的预警检查中，有企业、运营商IT，运营商业务软件3个场景，请将运营商的业务软件场景更名为运营商配套（运营商配套包括了业务软件、云核心网等多个华为产品）
    :param cli:
    :return:
    """
    global all_cli_ret, all_err_msg
    flag = True
    try:
        # 获取控制器信息
        result, controller_info = get_controller(cli)
        if result != True:
            LOGGER.logSysAbnormal()
            return result, all_cli_ret, all_err_msg
        for controller_info_dct in controller_info:
            controller_id = controller_info_dct.get('Controller', '')
            controller_barcode = controller_info_dct.get('BarCode', '')
            LOGGER.logInfo("BarCode:%s" % controller_barcode)
            # 若控制器BarCode在运营商IT版风险条码中，则不通过
            if controller_barcode in config.RISK_SN_OPERATORS_IT:
                LOGGER.logNoPass('The BarCode %s is risk.' % controller_barcode)
                all_err_msg += common.getMsg(LANG, 'controller.barcode.risk', (controller_id, controller_barcode))
                flag = False
        if flag:
            LOGGER.logPass()
        return flag, all_cli_ret, all_err_msg
    except Exception, e:
        LOGGER.logException(e)
        return cliUtil.RESULT_NOCHECK, all_cli_ret, common.getMsg(LANG, 'query.result.abnormal')


def get_controller(cli):
    """
    输入命令show controller general查看控制器条码
    :param cli:
    :return:
    """
    global all_cli_ret, all_err_msg
    # 执行命令，查询控制器信息
    cmd = 'show controller general'
    LOGGER.logExecCmd(cmd)
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret += cli_ret
    all_err_msg += err_msg
    if flag != True:
        return flag, []
    controller_info = cliUtil.getVerticalCliRetFilterElabel(cli_ret, True)
    if len(controller_info) == 0:
        all_err_msg += common.getMsg(LANG, 'cannot.get.controller.info')
        LOGGER.logInfo('Cannot get information about controller')
        return cliUtil.RESULT_NOCHECK, controller_info
    return True, controller_info
