# -*- coding: UTF-8 -*-

DORADO_DEVS = ['Dorado18000 V3', "Dorado6000 V3", "Dorado5000 V3", "Dorado3000 V3"]

#BBU满配规格，键表示设备类型，值表示单个引擎下BBU的满配规格
BBU_OF_ENGINE_CONFIG_DICT = {
"S2600T":2,
"S5500T":2,
"S5600T":4,
"S5800T":4,
"S6800T":4,
"2800 V3":2,
"5300 V3":2,
"5500 V3":2,
"5600 V3":2,
"5800 V3":3,
"6800 V3":4,
"6900 V3":4,
"HVS85T":4,
"HVS88T":4,
"18500":4,
"18800":4,
"18800F":4,
"18500 V3":4,
"18800 V3":4,
}

#风扇满配规格,键[1]表示框类型，键[2]表示高度(U)，键[4]表示是否为高密框，值表示风扇个数
FAN_CONFIG_DICT = {
("ENG", "2", "--"):2, #2U引擎框
("CTE", "2", "--"):2, #2U引擎框
("ENG", "3", "--"):6, #3U引擎框
("CTE", "3", "--"):6, #3U引擎框
("ENG", "4", "--"):3, #4U引擎框（盘框一体）
("CTE", "4", "--"):3, #4U引擎框（盘框一体）
("DAE", "2", "--"):2, #2U普通硬盘框
("DAE", "4", "high-density"):2, #4U高密硬盘框
("DAE", "4", "--"):4, #4U普通硬盘框
("DSW", "1", "--"):2, #PCIe交换框
}
# 企业版本风险控制器SN
RISK_SN_ENTERPRISE_NETWORK = ['210305793410J6000030', '210305793410J6000035', '210305793410J5000072', '210305793410J5000066', '210305771110J6000101',
 '210305793410J5000064', '210305771110J6000070', '210305793410J5000076', '210305771110J5000044', '210305793410J5000065',
 '210305771110J5000041', '210305793410J5000081', '210305793410J6000029', '210305793410J5000077', '210305793410J6000047',
 '210305793410J6000015', '210305793410J6000017', '210305793410J5000075', '210305771110J6000059', '210305793410J6000018',
 '210305793410J5000071', '210305771110J5000039', '210305793410J5000082', '210305793410J5000085', '210305793410J7000010',
 '210305793410J6000053', '210305793410J6000043', '210305771110J6000073', '210305771110J6000083', '210305771110J6000034',
 '210305771110J6000075', '210305771110J6000058', '210305793410J6000051', '210305793410J6000037', '210305793410J6000045',
 '210305771110J6000072', '210305771110J6000079', '210305771110J6000040', '210305793410J6000055', '210305771110J6000061',
 '210305793410J6000128', '210305793410J6000049', '210305771110J6000068', '210305793410J6000126', '210305771110J6000012',
 '210305771110J6000060', '210305793410J6000019', '210305793410J6000056', '210305793410J6000012', '210305771110J6000030',
 '210305793410J6000025', '210305793410J6000011', '210305793410J6000042', '210305793410J6000003', '210305771110J6000023',
 '210305793410J6000006', '210305793410J6000041', '210305793410J6000009', '210305793410J6000039', '210305793410J7000004',
 '210305793410J6000010', '210305793410J6000026', '210305793410J6000008', '210305771110J6000003', '210305771110J6000021',
 '210305771110J6000022', '210305793410J6000034', '210305771110J6000005', '210305793410J6000040', '210305771110J6000004',
 '210305793410J6000064', '210305793410J6000063', '210305771110J6000016', '210305771110J6000014', '210305793410J6000031',
 '210305793410J6000007', '210305793410J6000013', '210305771110J6000031', '210305771110J6000026', '210305771110J6000043',
 '210305793410J6000077', '210305793410J6000059', '210305771110J6000039', '210305771110J6000051', '210305771110J6000067',
 '210305771110J6000032', '210305793410J6000065', '210305793410J6000074', '210305793410J6000060', '210305771110J6000077',
 '210305771110J6000050', '210305771110J6000052', '210305771110J6000080', '210305793410J6000067', '210305771110J6000062',
 '210305793410J6000066', '210305793410J6000078', '210305793410J6000075', '210305793410J6000072', '210305771110J6000037',
 '210305771110J6000047', '210305793410J6000070', '210305771110J6000029', '210305771110J6000063', '210305771110J6000027',
 '210305771110J6000076', '210305793410J6000180', '210305793410J6000175', '210305793410J7000016', '210305793410J6000080',
 '210305793410J6000098', '210305793410J7000032', '210305793410J6000187', '210305771110J6000127', '210305793410J6000173',
 '210305793410J6000093', '210305793410J6000113', '210305793410J7000021', '210305793410J6000186', '210305793410J7000028',
 '210305771110J6000084', '210305793410J6000185', '210305793410J7000023', '210305793410J7000019', '210305793410J6000088',
 '210305771110J6000134', '210305793410J6000174', '210305793410J7000026', '210305793410J6000177', '210305793410J6000176',
 '210305793410J6000115', '210305793410J6000183', '210305793410J7000012', '210305793410J6000119', '210305771110J6000090',
 '210305793410J6000150', '210305793410J6000154', '210305793410J6000140', '210305793410J6000085', '210305793410J6000153',
 '210305793410J6000095', '210305771110J6000126', '210305793410J6000134', '210305793410J6000083', '210305771110J6000110',
 '210305793410J6000081', '210305793410J6000152', '210305771110J6000105', '210305793410J6000090', '210305771110J6000091',
 '210305793410J6000114', '210305793410J6000091', '210305793410J6000099', '210305793410J6000101', '210305793410J6000112',
 '210305793410J6000139', '210305771110J6000121', '210305793410J6000124', '210305793410J6000138', '210305771110J6000130',
 '210305771110J6000111', '210305771110J6000128', '210305793410J6000129', '210305793410J6000172', '210305771110J6000115',
 '210305793410J7000015', '210305793410J6000168', '210305793410J6000171', '210305771110J6000106', '210305793410J7000011',
 '210305793410J7000024', '210305793410J7000025', '210305793410J6000160', '210305793410J6000165', '210305793410J6000166',
 '210305793410J6000137', '210305771110J6000103', '210305793410J6000121', '210305793410J6000130', '210305793410J6000167',
 '210305793410J6000159', '210305793410J6000170', '210305771110J7000001', '210305793410J6000162', '210305793410J7000014',
 '210305771110J6000099', '210305771110J6000131', '210305771110J6000112', '210305793410J6000156', '210305771110J6000102',
 '210305793410J6000169', '210305771110J6000114', '210305793410J6000161', '210305771110J7000005', '210305793410J7000036',
 '210305793410J7000037', '210305771110J7000016', '210305793410J7000039', '210305793410J7000041', '210305771110J7000009',
 '210305793410J7000005', '210305771110J7000019', '210305771110J7000013', '210305793410J7000040', '210305771110J7000008',
 '210305771110J7000018', '210305771110J7000006', '210305793410J7000059', '210305771110J7000010', '210305771110J7000012',
 '210305793410J7000049', '210305771110J7000023', '210305771110J7000015', '210305793410J7000070', '210305793410J5000063',
 '210305793410J6000038', '210305793410J6000024', '210305771110J6000069', '210305793410J6000004', '210305793410J6000046',
 '210305771110J6000082', '210305771110J5000038', '210305771110J6000074', '210305793410J6000050', '210305793410J5000074',
 '210305793410J6000057', '210305793410J6000058', '210305793410J6000016', '210305793410J5000079', '210305771110J6000100',
 '210305793410J6000073', '210305793410J6000076', '210305793410J6000048', '210305793410J6000020', '210305793410J6000028',
 '210305793410J6000014', '210305793410J6000005', '210305793410J6000033', '210305771110J6000015', '210305793410J6000023',
 '210305793410J6000027', '210305793410J6000001', '210305793410J6000032', '210305771110J6000019', '210305771110J6000017',
 '210305793410J6000036', '210305771110J6000049', '210305771110J6000081', '210305793410J6000061', '210305793410J6000069',
 '210305793410J6000062', '210305771110J6000046', '210305771110J6000045', '210305771110J6000048', '210305771110J6000065',
 '210305793410J6000071', '210305771110J6000033', '210305793410J6000068', '210305771110J6000064', '210305771110J6000025',
 '210305793410J7000022', '210305793410J7000017', '210305793410J7000031', '210305771110J6000085', '210305771110J6000087',
 '210305771110J6000133', '210305771110J6000092', '210305793410J6000118', '210305793410J6000079', '210305793410J7000009',
 '210305793410J6000151', '210305793410J6000178', '210305793410J6000184', '210305793410J7000033', '210305793410J7000027',
 '210305771110J6000093', '210305793410J7000020', '210305793410J6000179', '210305793410J6000148', '210305793410J6000120',
 '210305793410J6000106', '210305771110J6000088', '210305793410J6000092', '210305771110J6000089', '210305793410J6000089',
 '210305793410J6000097', '210305793410J6000102', '210305793410J6000111', '210305793410J6000144', '210305793410J6000100',
 '210305793410J6000105', '210305793410J6000147', '210305793410J6000155', '210305793410J6000086', '210305771110J6000120',
 '210305793410J6000164', '210305771110J6000098', '210305793410J6000127', '210305793410J6000145', '210305793410J6000122',
 '210305771110J6000109', '210305771110J6000123', '210305793410J6000123', '210305771110J6000108', '210305793410J6000146',
 '210305771110J7000002', '210305793410J7000043', '210305793410J7000038', '210305771110J7000017', '210305793410J7000042',
 '210305793410J7000065', '210305771110J7000022', '210305771110J7000025', '210305793410J7000060', '210305771110J7000029',
 '210305771110J7000021', '210305771110J7000024', '210305793410J7000046', '210305793410J7000072', '210305771110J7000014',
 '210305793410J7000069', '210305793410J5000078', '210305793410J6000052', '210305771110J6000020', '210305771110J6000018',
 '210305771110J6000028', '210305771110J6000036', '210305771110J6000038', '210305771110J6000042', '210305771110J6000053',
 '210305793410J7000008', '210305771110J6000095', '210305771110J6000096', '210305793410J6000096', '210305793410J6000142',
 '210305771110J6000094', '210305793410J7000007', '210305771110J6000122', '210305793410J6000084', '210305771110J6000129',
 '210305793410J6000141', '210305771110J7000004', '210305793410J7000045', '210305793410J7000071', '210305793410J5000036',
 '210305771110J6000078', '210305771110J6000097', '210305771110J6000002', '210305793410J6000116', '210305793410J6000182',
 '210305793410J6000087', '210305793410J7000029', '210305793410J6000094', '210305793410J6000117', '210305793410J6000143',
 '210305793410J6000082', '210305771110J6000104', '210305793410J6000133', '210305793410J6000149', '210305793410J6000131',
 '210305793410J7000006', '210305771110J6000113', '210305771110J7000007', '210305793410J7000048', '210305771110J7000011',
 '210305793410J7000050', '210305771110J7000028', '210305793410J7000066', '210305771110J6000024', '210305771110J6000044',
 '210305793410J6000163', '210305771110J6000107', '210305771110J7000020', '210305771110J6000066', '210305771110J3000003',
 '210305771110J3000004', '210305771110J3000001', '210305771110J3000002', '210305793410J3000007', '210305793410J3000008',
 '210305793410J3000009', '210305793410J3000010', '210305793410J3000015', '210305793410J3000016', '210305793410J3000013',
 '210305793410J3000014', '210305793410J3000011', '210305793410J3000012', '210305793410J3000017', '210305793410J3000018',
 '210305793410J3000021', '210305793410J3000022', '210305793410J3000024', '210305793410J5000026', '210305771110J5000012',
 '210305771110J5000020', '210305771110J5000014', '210305771110J5000015', '210305771110J5000016', '210305793410J5000030',
 '210305793410J4000050', '21030572029WJ5000075', '21030572019WJ5000020', '21030572019WJ5000010', '210305720110J5000122',
 '21030572029WJ5000088', '210305720110J5000118', '210305720110J5000131', '21030572029WJ5000047', '21030572019WJ5000012',
 '21030572019WJ5000016', '21030572019WJ5000032', '21030572019WJ5000004', '21030572019WJ5000014', '21030572019WJ5000025',
 '210305720110J5000103', '21030572019WJ5000008', '21030572029WJ5000062', '21030572029WJ5000061', '21030572029WJ5000018',
 '21030572029WJ5000035', '21030572029WJ5000027', '21030572029WJ5000033', '21030572029WJ5000036', '21030572029WJ5000013',
 '21030572029WJ5000039', '21030572029WJ5000038', '21030572029WJ5000028', '21030572029WJ5000042', '21030572029WJ5000041',
 '21030572029WJ5000016', '210305720110J5000121', '21030572019WJ5000033', '21030572019WJ5000034', '21030572019WJ5000009',
 '21030572029WJ5000089', '21030572029WJ5000037', '21030572029WJ5000034', '21030572029WJ5000021', '21030572029WJ5000020',
 '210305720110J5000132', '21030572029WJ5000192', '21030572029WJ5000204', '21030572029WJ5000141', '210305720110J5000177',
 '21030572029WJ5000195', '210305720110J5000176', '210305720310J5000187', '21030572029WJ5000190', '21030572029WJ5000170',
 '21030572029WJ5000119', '21030572029WJ5000178', '21030572029WJ5000153', '21030572029WJ5000164', '21030572029WJ5000142',
 '210305720310J5000196', '210305720110J5000274', '21030572029WJ5000139', '21030572029WJ5000160', '21030572029WJ5000155',
 '21030572029WJ5000209', '21030572029WJ5000175', '21030572029WJ5000174', '21030572029WJ5000171', '21030572029WJ5000149',
 '21030572029WJ5000145', '21030572029WJ5000156', '21030572029WJ5000206', '21030572029WJ5000152', '21030572029WJ5000127',
 '21030572029WJ5000125', '21030572029WJ5000197', '21030572029WJ5000158', '21030572029WJ5000177', '210305720310J5000203',
 '21030572029WJ5000176', '21030572029WJ5000173', '21030572029WJ5000183', '21030572029WJ5000150', '21030572029WJ5000181',
 '21030572029WJ5000239', '210305720110J5000246', '21030572029WJ5000303', '21030572029WJ5000224', '21030572029WJ5000258',
 '21030572029WJ5000250', '210305720110J5000251', '21030572029WJ5000228', '210305720110J5000255', '21030572029WJ5000251',
 '21030572029WJ5000225', '21030572029WJ5000213', '21030572029WJ5000257', '21030572029WJ5000221', '210305720110J5000242',
 '210305720110J5000244', '21030572029WJ5000299', '210305720110J5000227', '210305720110J5000235', '210305720110J5000234',
 '21030572029WJ5000335', '21030572029WJ5000286', '21030572029WJ5000302', '21030572029WJ5000296', '21030572029WJ5000309',
 '21030572029WJ5000336', '21030572029WJ5000292', '210305720110J5000224', '21030572029WJ5000273', '21030572029WJ5000285',
 '21030572029WJ5000284', '21030572029WJ5000268', '21030572029WJ5000218', '210305720110J5000254', '210305720110J5000241',
 '210305720110J5000277', '210305720110J5000238', '21030572029WJ5000236', '210305720110J5000237', '21030572029WJ5000216',
 '210305720110J5000232', '21030572029WJ5000254', '21030572029WJ5000253', '21030572029WJ5000240', '210305720110J5000248',
 '21030572029WJ5000252', '21030572029WJ5000324', '21030572029WJ5000319', '21030572029WJ5000310', '21030572029WJ5000316',
 '21030572029WJ5000305', '21030572029WJ5000308', '21030572029WJ5000317', '21030572029WJ5000339', '21030572029WJ5000337',
 '21030572029WJ5000320', '21030572029WJ5000283', '21030572029WJ5000294', '21030572029WJ5000274', '21030572029WJ5000311',
 '21030572029WJ5000276', '210305720110J5000292', '210305720110J6000024', '210305720110J5000289', '210305720110J5000290',
 '21030572029WJ5000348', '21030572019WJ5000133', '210305720110J5000258', '21030572019WJ5000161', '21030572019WJ5000132',
 '210305720110J5000291', '210305720310J5000216', '21030572019WJ5000169', '21030572039WJ5000017', '21030572019WJ5000157',
 '210305720110J5000279', '210305720110J5000278', '210305720310J5000215', '21030572019WJ5000147', '21030572019WJ5000131',
 '21030572019WJ5000158', '21030572029WJ5000343', '21030572029WJ5000359', '21030572029WJ5000342', '21030572019WJ5000135',
 '21030572019WJ5000138', '210305720210J5000074', '21030572019WJ5000171', '210305720110J5000273', '21030572019WJ5000148',
 '21030572029WJ5000307', '21030572019WJ5000120', '21030572019WJ5000128', '21030572019WJ5000127', '21030572029WJ5000328',
 '21030572029WJ5000264', '21030572029WJ5000260', '210305720110J5000282', '210305720310J6000041', '210305720210J6000004',
 '210305720210J6000008', '210305720310J5000220', '210305720210J5000058', '210305720210J5000071', '210305720210J5000047',
 '21030572039WJ5000032', '21030572019WJ5000181', '210305720210J5000054', '210305720210J5000053', '210305720210J5000046',
 '210305720210J5000079', '210305720110J6000137', '210305720210J6000078', '21030572019WJ5000176', '210305720210J5000073',
 '210305720210J5000062', '21030572019WJ5000165', '210305720210J5000075', '210305720210J6000059', '210305720310J5000218',
 '210305720210J5000072', '21030572029WJ5000344', '21030572019WJ5000173', '21030572029WJ5000341', '21030572019WJ5000155',
 '210305720110J5000294', '21030572019WJ5000162', '21030572019WJ5000163', '21030572019WJ5000137', '21030572019WJ5000150',
 '21030572019WJ5000149', '21030572019WJ5000172', '21030572029WJ5000353', '210305720110J5000259', '21030572029WJ5000357',
 '21030572019WJ5000174', '21030572019WJ5000177', '21030572029WJ5000358', '21030572029WJ5000355', '21030572019WJ5000164',
 '21030572019WJ5000183', '21030572029WJ5000347', '210305720310J5000217', '21030572039WJ5000031', '210305720110J5000304',
 '210305720210J6000066', '210305720210J6000079', '21030572019WJ6000030', '21030572029WJ5000365', '210305720210J6000080',
 '21030572019WJ6000013', '21030572019WJ6000068', '21030572019WJ6000006', '21030572029WJ6000055', '210305720210J6000065',
 '210305720110J5000314', '210305720210J6000006', '210305720210J6000064', '21030572039WJ5000028', '21030572019WJ6000034',
 '21030572019WJ6000001', '21030572019WJ6000015', '21030572029WJ5000366', '21030572029WJ5000363', '21030572019WJ6000029',
 '210305720110J5000318', '210305720110J5000315', '210305720210J5000063', '210305720210J5000052', '210305720210J5000050',
 '210305720210J5000070', '210305720110J5000286', '21030572019WJ6000183', '210305720210J5000043', '210305720210J5000048',
 '210305720210J5000064', '21030572039WJ5000018', '210305720210J5000055', '210305720210J5000076', '210305720110J5000298',
 '210305720210J6000009', '21030572029WJ6000006', '21030572029WJ6000027', '21030572029WJ6000019', '21030572029WJ6000056',
 '21030572029WJ6000001', '210305720210J6000024', '21030572019WJ6000036', '210305720110J6000245', '210305776710J6000017',
 '21030572029WJ6000002', '210305720210J6000039', '21030572029WJ6000028', '210305720110J5000311', '210305720210J6000038',
 '21030572029WJ6000003', '21030572039WJ6000139', '21030572029WJ6000020', '21030572039WJ6000142', '21030572019WJ6000021',
 '21030572029WJ6000017', '21030572019WJ6000028', '210305720210J6000023', '21030572029WJ6000015', '21030572039WJ5000036',
 '210305720110J5000305', '210305720110J6000259', '21030572029WJ6000061', '210305720210J6000002', '21030572019WJ6000010',
 '21030572039WJ5000027', '210305720210J6000067', '21030572029WJ6000063', '21030572019WJ6000007', '210305720210J6000001',
 '210305720210J6000069', '21030572029WJ6000134', '21030572029WJ6000158', '210305720110J6000236', '210305720110J6000238',
 '210305720110J6000158', '210305720310J5000239', '210305720310J5000237', '210305720310J6000107', '210305720310J6000111',
 '21030572029WJ6000169', '210305720110J6000235', '210305720110J6000264', '210305720310J6000062', '210305720110J6000196',
 '210305720110J6000168', '210305776710J6000046', '210305776710J6000048', '21030572019WJ6000251', '210305720110J5000310',
 '210305720210J6000036', '21030572019WJ6000063', '210305720110J6000016', '21030572019WJ6000066', '21030572039WJ6000141',
 '210305720310J6000143', '21030572029WJ6000025', '21030572029WJ6000014', '21030572019WJ6000032', '21030572029WJ6000066',
 '21030572019WJ6000005', '210305720110J6000248', '210305720210J6000091', '21030572029WJ5000367', '21030572029WJ6000310',
 '21030572029WJ6000300', '21030572029WJ6000316', '210305720110J6000011', '210305720110J6000199', '21030572029WJ6000255',
 '21030572029WJ6000289', '21030572029WJ6000266', '21030572029WJ6000177', '21030572029WJ6000315', '21030572029WJ6000302',
 '210305720110J6000193', '21030572029WJ6000135', '210305720310J5000238', '210305720110J6000267', '210305720310J5000236',
 '210305720310J6000109', '210305720110J6000263', '210305720110J6000195', '210305720310J6000102', '21030572019WJ5000198',
 '21030572029WJ6000012', '21030572019WJ6000026', '21030572019WJ6000195', '210305720110J6000068', '21030572019WJ6000209',
 '21030572029WJ6000108', '21030572019WJ6000137', '21030572019WJ6000197', '21030572029WJ6000098', '210305720310J6000027',
 '21030572029WJ6000132', '21030572029WJ6000155', '210305720110J6000169', '21030572029WJ6000024', '210305720110J6000059',
 '21030572029WJ6000021', '21030572019WJ6000040', '21030572019WJ6000038', '21030572019WJ6000073', '21030572019WJ6000047',
 '21030572019WJ6000079', '21030572019WJ6000083', '21030572019WJ6000093', '21030572019WJ6000058', '21030572029WJ6000067',
 '21030572029WJ6000048', '21030572029WJ6000029', '21030572019WJ6000043', '21030572019WJ6000050', '21030572019WJ6000041',
 '21030572029WJ6000044', '21030572019WJ6000055', '21030572019WJ6000138', '21030572029WJ6000053', '21030572019WJ6000141',
 '210305720110J6000073', '21030572019WJ6000094', '210305720110J6000074', '21030572029WJ6000068', '21030572019WJ6000165',
 '21030572029WJ6000058', '210305720110J6000017', '21030572019WJ6000164', '210305720110J6000070', '21030572019WJ6000046',
 '21030572029WJ6000174', '21030572019WJ6000085', '21030572019WJ6000176', '21030572019WJ6000042', '21030572019WJ6000078',
 '21030572029WJ6000034', '21030572029WJ6000041', '21030572029WJ6000040', '21030572029WJ6000047', '21030572029WJ6000060',
 '21030572019WJ6000077', '21030572029WJ6000054', '21030572019WJ6000187', '210305776710J6000028', '210305720110J6000129',
 '210305720310J6000073', '210305720110J6000082', '210305776710J6000041', '210305720310J6000019', '210305720110J6000027',
 '210305720110J6000039', '210305720110J6000216', '210305720110J6000041', '21030572019WJ6000221', '210305720110J6000081',
 '210305720110J6000045', '21030572019WJ6000232', '210305720110J6000076', '210305720310J6000030', '210305720110J6000056',
 '210305720110J6000038', '210305720110J6000218', '210305720110J6000102', '210305720110J6000208', '210305720110J6000112',
 '210305720110J6000091', '210305776710J6000027', '210305720110J6000110', '210305720110J6000258', '210305720110J6000257',
 '210305720310J6000090', '210305720310J6000018', '21030572029WJ6000235', '210305720310J6000029', '21030572029WJ6000246',
 '21030572029WJ6000304', '210305720110J6000217', '210305776710J6000029', '21030572029WJ6000245', '21030572019WJ6000231',
 '210305720310J6000088', '21030572019WJ6000222', '210305720110J6000242', '21030572019WJ6000216', '210305720110J6000219',
 '210305720310J6000079', '210305720110J6000043', '210305720110J6000085', '210305720110J6000026', '210305720110J6000061',
 '210305720110J6000092', '210305720110J6000080', '210305720110J6000062', '210305720110J6000214', '21030572019WJ6000223',
 '210305720110J6000223', '21030572019WJ6000229', '210305720110J6000100', '210305720310J6000021', '210305720110J6000079',
 '210305720110J6000106', '210305720110J6000093', '210305720110J6000057', '210305720110J6000078', '210305720110J6000105',
 '210305720110J6000064', '210305720110J6000225', '21030572019WJ6000230', '210305720110J6000220', '210305720110J6000067',
 '210305720110J6000047', '210305720310J6000020', '210305720110J6000111', '21030572029WJ6000189', '21030572029WJ6000206',
 '210305720110J6000231', '210305720110J6000232', '210305720110J6000227', '21030572029WJ6000117', '21030572029WJ6000196',
 '210305720310J6000145', '21030572029WJ6000119', '21030572029WJ6000188', '210305720310J6000093', '210305720110J6000228',
 '210305720310J6000033', '21030572029WJ6000210', '210305720110J6000203', '210305720110J6000250', '210305720310J6000099',
 '210305720310J6000322', '21030572029WJ6000213', '210305720110J6000252', '210305720110J6000030', '21030572029WJ6000247',
 '21030572029WJ6000284', '21030572029WJ6000239', '21030572029WJ6000226', '21030572029WJ6000227', '210305720110J6000254',
 '210305720110J6000244', '210305720210J6000049', '21030572029WJ6000193', '210305720110J6000206', '210305720210J6000055',
 '210305720210J6000033', '21030572029WJ6000195', '210305720110J6000261', '210305720210J6000041', '210305720210J6000044',
 '210305720210J6000047', '210305720210J6000032', '210305720210J6000057', '210305720210J6000025', '21030572019WJ6000168',
 '210305720110J6000201', '210305720310J6000101', '210305720210J6000056', '21030572019WJ6000169', '210305720210J6000046',
 '21030572029WJ6000216', '210305720310J6000064', '210305720210J6000045', '210305720310J6000034', '210305720110J6000243',
 '21030572029WJ6000124', '21030572029WJ6000197', '210305720310J6000097', '21030572019WJ6000177', '210305720310J6000032',
 '210305720110J6000207', '210305720110J6000125', '21030572029WJ6000130', '210305720110J6000230', '21030572029WJ6000211',
 '21030572019WJ6000178', '210305720310J6000096', '210305720110J6000205', '21030572029WJ6000192', '210305720210J6000050',
 '21030572019WJ6000170', '210305720210J6000051', '210305720310J6000051', '210305720310J6000098', '210305720110J6000481',
 '210305720310J6000144', '210305720210J6000034', '210305720110J6000151', '21030572019WJ6000161', '210305720110J6000153',
 '210305720110J6000143', '21030572019WJ6000171', '210305720110J6000152', '21030572019WJ6000162', '210305720110J6000144',
 '21030572019WJ6000172', '21030572019WJ6000173', '21030572019WJ6000241', '21030572019WJ6000337', '21030572019WJ6000360',
 '21030572019WJ6000384', '210305776710J6000025', '210305720110J6000284', '21030572019WJ6000359', '210305776710J6000024',
 '21030572019WJ6000354', '21030572019WJ6000332', '21030572019WJ6000386', '21030572019WJ6000252', '21030572019WJ6000369',
 '21030572019WJ6000373', '210305720310J6000114', '21030572019WJ6000375', '21030572019WJ6000338', '21030572019WJ6000339',
 '21030572019WJ6000366', '21030572019WJ6000388', '21030572019WJ6000365', '21030572019WJ6000334', '210305720310J6000140',
 '21030572019WJ6000417', '210305720310J6000119', '21030572019WJ6000402', '21030572019WJ6000387', '21030572019WJ6000342',
 '21030572019WJ6000368', '21030572019WJ6000376', '21030572019WJ6000353', '21030572019WJ6000350', '21030572019WJ6000346',
 '21030572019WJ6000404', '21030572019WJ6000358', '21030572019WJ6000367', '21030572019WJ6000383', '21030572019WJ6000242',
 '21030572019WJ6000341', '21030572019WJ6000349', '21030572019WJ6000355', '21030572019WJ6000385', '21030572019WJ6000371',
 '21030572019WJ6000270', '21030572019WJ6000265', '210305720110J6000328', '21030572019WJ6000276', '21030572019WJ6000257',
 '21030572019WJ6000411', '210305720310J6000153', '210305720310J6000115', '210305720310J6000137', '21030572019WJ6000418',
 '210305720310J6000131', '210305720110J6000290', '210305720310J6000152', '21030572019WJ6000408', '21030572019WJ6000275',
 '210305720310J6000154', '21030572019WJ6000271', '21030572019WJ6000234', '210305720110J6000330', '21030572019WJ6000256',
 '210305720110J6000278', '210305720310J6000126', '210305720110J6000283', '21030572019WJ6000414', '210305720310J6000128',
 '210305720310J6000122', '210305720310J6000121', '210305720110J6000276', '210305720110J6000337', '210305720310J6000146',
 '21030572019WJ6000421', '210305720110J6000383', '210305720310J6000157', '210305720110J6000331', '210305720310J6000155',
 '210305720310J7000017', '210305720310J7000018', '210305720110J6000308', '210305720310J7000013', '210305720110J6000294',
 '210305720310J6000150', '210305720110J7000010', '210305720110J6000382', '210305720310J6000325', '21030572019WJ6000236',
 '21030572019WJ6000258', '21030572019WJ6000244', '210305720110J6000285', '21030572019WJ6000273', '210305720110J6000329',
 '210305720310J6000118', '210305720110J6000282', '21030572019WJ6000308', '210305720110J6000286', '21030572019WJ6000245',
 '21030572019WJ6000277', '210305720110J7000028', '21030572019WJ7000007', '210305776710J6000052', '21030572019WJ6000315',
 '210305720110J7000050', '210305720110J6000341', '210305720110J6000355', '210305720310J6000163', '210305720110J6000434',
 '21030572019WJ6000312', '210305720310J6000162', '21030572019WJ6000306', '21030572019WJ6000310', '210305720110J7000033',
 '210305720110J6000389', '210305720110J7000059', '210305720110J7000049', '210305720110J7000052', '21030572019WJ6000296',
 '210305720310J6000315', '210305720110J6000346', '210305720110J7000044', '210305720110J7000051', '210305776710J6000051',
 '210305720110J6000390', '210305720110J6000357', '210305720110J6000297', '210305720110J6000306', '210305720310J6000159',
 '210305720310J6000156', '210305720110J6000303', '210305720110J6000292', '210305720110J6000416', '21030572019WJ6000293',
 '210305720110J6000359', '210305720110J6000499', '210305720110J6000377', '210305720110J7000057', '210305720110J6000502',
 '210305720110J6000491', '210305720110J6000498', '210305720110J6000424', '210305720110J6000360', '210305720110J6000490',
 '210305720110J6000379', '210305720110J6000398', '210305720110J6000365', '210305720110J6000495', '210305720110J6000366',
 '210305720310J6000317', '210305720110J6000397', '21030572039WJ6000201', '21030572019WJ6000295', '210305720110J6000388',
 '210305720110J6000364', '210305720110J6000378', '210305720110J6000513', '210305720110J6000372', '210305720110J6000345',
 '210305720110J7000047', '210305720110J6000402', '210305720110J6000410', '210305720110J6000354', '210305720110J6000363',
 '210305720110J6000362', '210305720110J6000334', '21030572019WJ6000303', '210305720110J7000231', '21030572019WJ6000311',
 '21030572019WJ6000284', '21030572019WJ6000314', '21030572019WJ6000281', '21030572019WJ6000285', '21030572019WJ6000309',
 '210305720310J6000161', '210305720110J6000403', '21030572019WJ6000287', '21030572019WJ6000279', '210305720310J6000179',
 '210305720110J6000391', '210305720110J7000032', '210305720110J7000060', '210305720110J7000041', '210305720110J7000039',
 '210305720110J6000485', '210305720110J6000450', '210305720110J6000455', '210305720110J7000037', '210305720110J6000407',
 '210305720110J6000484', '210305720110J6000475', '210305720110J7000068', '210305720310J7000042', '210305720110J7000053',
 '210305720110J6000420', '210305720110J6000432', '210305720110J7000065', '210305720110J6000459', '210305720110J7000031',
 '210305720110J6000486', '210305720110J6000443', '210305720310J6000192', '210305720110J6000453', '210305720110J7000025',
 '210305720110J6000435', '210305720110J7000056', '210305720110J6000477', '210305720110J6000465', '210305720110J6000483',
 '210305720110J7000066', '210305720110J7000058', '210305720110J6000395', '210305720110J6000460', '210305720110J6000430',
 '210305720110J6000421', '210305720110J6000419', '210305720110J6000369', '210305720310J6000187', '210305720110J6000392',
 '210305720110J6000464', '210305720110J6000461', '210305720310J6000193', '210305720110J6000438', '210305720110J6000373',
 '210305720110J6000506', '210305720110J7000038', '210305720110J7000064', '210305720110J7000042', '210305720110J6000423',
 '210305720110J6000510', '210305720110J6000418', '210305720110J6000509', '210305720110J6000440', '210305720110J6000474',
 '210305720310J6000196', '210305720310J6000313', '210305720110J6000441', '210305720110J7000070', '210305720110J6000467',
 '210305720110J6000487', '210305720110J6000437', '210305720110J6000433', '210305720310J6000186', '210305720110J6000426',
 '210305720110J6000405', '210305720110J6000436', '210305720110J6000445', '210305720110J6000452', '21030572039WJ7000010',
 '210305720110J7000002', '21030572029WJ7000004', '210305720110J7000005', '210305720310J7000015', '210305720310J7000003',
 '210305720110J7000011', '21030572039WJ7000009', '210305720310J7000019', '210305720310J7000020', '210305720310J7000111',
 '21030572019WJ7000003', '210305720310J7000029', '210305720310J7000079', '210305720310J7000031', '210305720310J7000030',
 '210305720310J7000025', '210305720310J7000085', '210305720310J7000032', '210305720310J7000023', '210305720310J7000084',
 '210305720310J7000075', '210305720310J7000076', '21030572029WJ7000105', '210305720110J7000024', '21030572019WJ7000022',
 '21030572019WJ7000020', '21030572029WJ7000032', '21030572029WJ7000031', '21030572019WJ7000019', '21030572019WJ7000021',
 '21030572029WJ7000044', '21030572029WJ7000119', '21030572029WJ7000038', '21030572029WJ7000037', '21030572029WJ7000120',
 '21030572029WJ7000114', '210305720110J7000190', '210305720210J7000025', '210305720110J7000191', '21030572029WJ7000084',
 '21030572029WJ7000034', '21030572029WJ7000083', '21030572029WJ7000081', '21030572029WJ7000025', '21030572029WJ7000035',
 '21030572019WJ7000050', '210305720210J7000024', '210305720210J7000019', '210305720310J7000045', '210305720310J7000044',
 '210305720310J7000038', '210305720310J7000040', '210305720310J7000043', '210305720310J7000056', '210305720110J7000232',
 '210305720310J7000114', '21030572019WJ5000026', '21030572019WJ5000031', '21030572029WJ5000011', '21030572029WJ5000012',
 '210305720110J5000111', '21030572029WJ5000015', '21030572029WJ5000017', '21030572029WJ5000029', '21030572029WJ5000014',
 '21030572029WJ5000019', '21030572029WJ5000030', '21030572029WJ5000022', '21030572029WJ5000059', '21030572019WJ5000054',
 '210305720310J5000110', '210305720110J5000140', '21030572029WJ5000126', '210305720310J5000186', '21030572029WJ5000148',
 '210305720310J5000206', '210305720110J5000182', '21030572029WJ5000159', '21030572029WJ5000144', '210305720310J5000194',
 '21030572029WJ5000205', '21030572029WJ5000157', '21030572029WJ5000179', '21030572029WJ5000184', '21030572029WJ5000169',
 '21030572029WJ5000154', '21030572029WJ5000255', '210305720110J5000245', '210305720110J5000249', '210305720110J5000247',
 '21030572029WJ5000220', '21030572029WJ5000288', '210305720110J5000243', '21030572029WJ5000247', '210305720110J5000231',
 '210305720110J5000253', '210305720110J5000228', '21030572029WJ5000235', '21030572029WJ5000217', '21030572029WJ5000275',
 '21030572029WJ5000214', '21030572029WJ5000229', '21030572029WJ5000211', '21030572029WJ5000287', '21030572029WJ5000261',
 '21030572029WJ5000301', '21030572029WJ5000278', '21030572029WJ5000277', '21030572029WJ5000293', '21030572029WJ5000212',
 '210305720110J5000239', '210305720110J5000240', '21030572029WJ5000219', '210305720110J5000266', '21030572019WJ5000118',
 '21030572019WJ5000117', '21030572029WJ5000314', '21030572029WJ5000327', '21030572019WJ5000121', '21030572029WJ5000321',
 '21030572029WJ5000332', '21030572029WJ5000334', '21030572029WJ5000315', '21030572019WJ5000129', '21030572029WJ5000259',
 '21030572029WJ5000267', '21030572029WJ5000265', '21030572029WJ5000362', '210305720110J5000276', '21030572019WJ5000123',
 '21030572019WJ5000125', '21030572019WJ5000154', '210305720110J5000270', '21030572019WJ5000119', '21030572029WJ5000323',
 '21030572019WJ5000122', '210305720110J5000272', '210305720110J5000271', '21030572019WJ5000184', '210305720210J6000012',
 '21030572019WJ5000192', '21030572019WJ5000194', '21030572029WJ5000352', '21030572019WJ5000175', '21030572019WJ5000180',
 '21030572029WJ5000349', '210305720210J5000056', '21030572029WJ5000345', '210305720210J5000067', '210305720210J5000078',
 '210305720310J7000110', '210305720210J5000059', '21030572019WJ5000193', '21030572019WJ5000182', '21030572029WJ5000350',
 '21030572019WJ5000168', '21030572019WJ5000139', '21030572029WJ5000356', '21030572029WJ5000361', '210305720210J6000060',
 '210305720210J6000070', '21030572029WJ5000364', '21030572029WJ6000004', '21030572019WJ6000014', '21030572019WJ6000004',
 '21030572039WJ5000035', '21030572019WJ6000002', '21030572029WJ6000065', '21030572019WJ6000033', '210305720210J5000069',
 '210305720110J5000297', '210305720210J5000051', '210305720110J6000139', '210305720110J6000138', '210305720110J5000285',
 '210305720110J5000300', '210305720210J5000061', '210305720210J5000077', '210305720210J5000060', '21030572019WJ5000200',
 '210305720110J5000283', '21030572019WJ6000031', '21030572029WJ6000011', '21030572019WJ6000003', '21030572029WJ6000005',
 '21030572029WJ6000026', '210305776710J6000016', '21030572019WJ6000020', '210305720110J5000309', '210305720110J6000246',
 '21030572019WJ5000190', '21030572029WJ6000008', '21030572019WJ6000052', '21030572039WJ5000024', '210305720110J6000188',
 '210305720110J6000177', '210305720310J6000110', '210305720110J6000197', '210305720110J6000020', '210305720310J6000052',
 '210305720110J6000274', '210305720210J6000035', '21030572019WJ6000011', '21030572029WJ6000062', '21030572029WJ6000294',
 '21030572029WJ6000309', '21030572029WJ6000133', '210305720310J6000065', '210305720110J6000018', '210305776710J6000020',
 '210305720110J6000161', '210305720110J6000013', '21030572029WJ6000018', '210305776710J6000015', '21030572029WJ6000292',
 '21030572029WJ6000287', '21030572029WJ6000296', '21030572029WJ6000293', '21030572019WJ6000152', '21030572029WJ6000265',
 '21030572029WJ6000260', '21030572029WJ6000136', '21030572019WJ6000199', '21030572019WJ6000044', '21030572029WJ6000057',
 '210305720110J6000015', '21030572019WJ6000039', '21030572019WJ6000163', '210305720110J6000052', '21030572019WJ6000059',
 '21030572019WJ6000080', '21030572029WJ6000257', '21030572019WJ6000099', '21030572029WJ6000173', '210305720110J6000071',
 '21030572019WJ6000037', '210305720110J6000117', '21030572029WJ6000059', '21030572029WJ6000032', '210305720310J6000060',
 '210305776710J6000034', '21030572019WJ6000225', '21030572019WJ6000226', '210305720110J6000063', '210305720310J6000082',
 '210305720310J6000078', '210305720110J6000099', '210305720110J6000066', '210305720110J6000087', '210305776710J6000011',
 '210305720110J6000118', '210305720310J6000050', '210305720110J6000127', '21030572029WJ6000248', '21030572029WJ6000224',
 '210305720110J6000033', '21030572019WJ6000228', '21030572029WJ6000228', '210305720110J6000210', '21030572029WJ6000231',
 '210305720110J6000221', '21030572019WJ6000227', '210305720110J6000086', '210305720110J6000051', '210305720110J6000094',
 '210305720110J6000107', '210305720110J6000224', '210305720110J6000088', '21030572019WJ6000224', '21030572019WJ6000220',
 '210305720310J6000077', '210305720110J6000035', '210305720110J6000104', '210305720110J6000050', '210305720110J6000121',
 '210305720310J6000094', '21030572019WJ6000174', '21030572029WJ6000118', '21030572029WJ6000194', '21030572029WJ6000187',
 '21030572029WJ6000232', '21030572029WJ6000283', '210305720110J6000256', '21030572029WJ6000236', '210305720110J6000251',
 '210305720110J6000253', '21030572029WJ6000303', '210305720110J6000249', '210305720210J6000042', '210305720110J6000116',
 '210305720310J6000024', '210305720110J6000202', '21030572029WJ6000207', '210305720210J6000048', '210305720310J6000035',
 '21030572029WJ6000212', '210305720110J6000108', '210305720210J6000054', '210305720310J6000100', '210305720210J6000043',
 '210305720110J6000145', '210305720110J6000142', '210305720110J6000150', '21030572019WJ6000374', '21030572019WJ6000333',
 '21030572019WJ6000340', '21030572019WJ6000372', '21030572019WJ6000370', '210305720110J6000281', '21030572019WJ6000401',
 '21030572019WJ6000345', '21030572019WJ6000415', '210305720310J6000141', '210305720310J6000133', '210305720310J6000116',
 '21030572019WJ6000413', '210305720310J6000136', '21030572019WJ6000407', '21030572019WJ6000409', '21030572019WJ6000423',
 '210305720110J6000336', '21030572019WJ6000410', '210305720110J6000275', '21030572019WJ6000412', '21030572039WJ6000164',
 '21030572019WJ6000235', '210305720110J6000298', '21030572019WJ6000278', '210305720110J6000299', '21030572019WJ6000422',
 '210305720110J6000302', '210305720110J6000300', '210305720110J6000307', '210305720110J7000012', '210305720310J6000326',
 '210305720110J6000291', '210305720110J6000293', '21030572019WJ6000269', '210305720110J6000289', '21030572019WJ6000246',
 '21030572019WJ6000243', '210305720310J6000151', '210305720110J6000296', '210305720310J6000123', '21030572019WJ6000255',
 '210305720110J6000353', '210305720310J6000166', '210305720310J7000073', '21030572029WJ7000100', '21030572019WJ6000291',
 '21030572019WJ6000304', '210305720110J6000332', '210305720310J6000164', '210305720310J6000165', '21030572029WJ7000099',
 '21030572019WJ6000280', '21030572019WJ6000292', '210305720310J6000167', '210305720110J7000043', '210305720110J7000034',
 '210305720110J6000356', '210305720110J6000352', '210305720310J6000149', '210305720310J6000327', '210305720110J6000301',
 '210305720110J6000380', '210305720110J6000488', '210305720110J6000496', '210305720310J6000314', '210305720110J6000381',
 '210305720110J6000358', '210305720110J6000349', '210305720310J6000319', '210305720110J6000370', '210305720110J6000512',
 '210305720110J6000493', '210305720110J6000505', '210305720110J6000374', '210305720110J6000427', '210305720110J6000375',
 '210305720310J7000072', '21030572019WJ6000282', '21030572019WJ6000288', '21030572039WJ7000001', '210305720110J6000361',
 '21030572019WJ6000283', '210305720110J7000062', '210305720110J6000425', '210305720110J6000454', '210305720110J6000404',
 '210305720310J6000198', '210305720110J6000411', '210305720110J6000482', '210305720110J7000069', '210305720110J6000476',
 '210305720310J6000191', '210305720110J7000054', '210305720310J6000194', '210305720310J6000320', '210305720110J6000414',
 '210305720110J6000409', '210305720110J6000456', '210305720110J6000463', '210305720310J6000312', '210305720110J6000492',
 '210305720110J6000422', '210305720110J6000368', '210305720110J6000396', '210305720110J7000048', '210305720110J6000393',
 '210305720110J7000055', '210305720110J6000394', '210305720110J6000417', '210305720110J6000462', '210305720110J7000063',
 '210305720110J6000471', '210305720110J7000067', '210305720110J7000061', '210305720110J6000376', '210305720110J6000412',
 '210305720110J7000230', '210305720110J6000472', '210305720310J6000188', '210305720110J6000431', '210305720110J6000468',
 '210305720110J6000473', '210305720310J7000035', '210305720310J7000034', '210305720110J7000003', '21030572029WJ7000003',
 '210305720310J7000078', '210305720310J7000028', '210305720310J7000087', '210305720310J7000026', '210305720310J7000071',
 '210305720310J7000022', '210305720310J7000024', '21030572029WJ7000113', '210305720310J7000021', '21030572029WJ7000106',
 '210305720310J7000077', '210305720310J7000070', '210305720110J7000022', '21030572019WJ7000049', '21030572029WJ7000033',
 '210305720110J7000023', '21030572019WJ7000028', '210305720310J7000027', '210305720110J7000192', '210305720110J7000193',
 '210305720210J7000016', '210305720210J7000017', '210305776710J7000018', '210305720110J7000154', '210305720110J7000096',
 '210305720110J7000233', '210305720310J7000113', '21030572029WJ5000048', '210305720110J5000106', '210305720110J5000100',
 '210305720110J5000112', '21030572029WJ5000040', '21030572029WJ5000085', '21030572019WJ5000018', '210305720110J5000275',
 '21030572029WJ5000200', '210305720110J5000173', '21030572029WJ5000167', '21030572029WJ5000161', '210305720310J5000205',
 '21030572029WJ5000185', '210305720310J5000197', '21030572029WJ5000186', '21030572029WJ5000298', '21030572029WJ5000231',
 '21030572029WJ5000233', '21030572029WJ5000300', '21030572029WJ5000223', '210305720110J5000230', '210305720110J5000233',
 '21030572029WJ5000331', '21030572029WJ5000338', '21030572029WJ5000330', '21030572029WJ5000295', '21030572019WJ5000160',
 '210305720210J5000080', '210305720110J5000299', '21030572019WJ5000126', '210305720110J5000296', '21030572029WJ5000322',
 '210305720110J5000268', '210305720110J5000267', '210305720210J5000066', '210305720110J5000288', '210305720110J5000281',
 '210305720210J6000007', '21030572019WJ5000166', '210305720210J5000065', '21030572019WJ5000170', '210305720210J6000068',
 '21030572019WJ6000067', '210305720110J5000316', '210305720110J5000312', '210305720210J6000003', '21030572029WJ6000064',
 '210305720110J5000284', '210305720110J5000293', '210305776710J6000019', '21030572029WJ6000007', '210305720210J6000037',
 '21030572039WJ6000140', '210305720210J6000030', '210305720110J6000194', '21030572019WJ6000009', '21030572019WJ6000012',
 '210305720110J6000191', '210305720110J6000237', '210305720110J6000189', '210305720110J6000271', '21030572029WJ6000013',
 '210305720210J6000028', '210305720210J6000027', '21030572019WJ6000017', '21030572029WJ6000156', '210305720310J6000055',
 '210305720110J6000159', '21030572019WJ6000019', '210305720310J6000025', '21030572019WJ6000086', '21030572019WJ6000049',
 '21030572029WJ6000030', '21030572019WJ6000060', '21030572019WJ6000081', '21030572029WJ6000036', '210305720310J6000026',
 '21030572029WJ6000039', '210305720110J6000083', '210305720310J6000049', '210305720110J6000222', '21030572029WJ6000240',
 '210305720110J6000157', '21030572029WJ6000223', '21030572029WJ6000225', '210305720110J6000241', '210305720110J6000211',
 '210305720110J6000089', '210305720110J6000114', '210305720310J6000017', '210305720110J6000262', '210305720110J6000200',
 '21030572029WJ6000129', '210305720110J6000204', '210305720310J6000095', '210305720310J6000031', '210305720210J6000053',
 '210305720310J6000092', '210305720310J6000323', '21030572029WJ6000128', '210305720210J6000058', '21030572019WJ6000167',
 '210305720210J6000052', '21030572019WJ6000331', '21030572019WJ6000403', '210305720310J6000129', '21030572019WJ6000347',
 '21030572019WJ6000348', '210305776710J6000026', '21030572019WJ6000357', '210305720110J6000333', '210305720310J6000117',
 '21030572019WJ6000416', '21030572019WJ6000419', '21030572019WJ6000274', '21030572019WJ6000307', '21030572019WJ6000272',
 '21030572019WJ6000266', '210305720310J6000127', '210305720310J6000135', '210305720310J6000134', '210305720310J6000125',
 '210305720110J6000277', '210305720310J6000120', '21030572019WJ6000237', '210305720310J6000324', '210305720310J6000158',
 '21030572019WJ6000424', '210305720310J6000168', '210305720310J6000178', '21030572019WJ6000294', '210305720110J6000335',
 '210305720110J7000046', '210305720310J6000169', '21030572019WJ7000008', '210305720110J6000347', '210305720110J7000045',
 '210305720110J6000305', '210305720110J6000340', '210305720110J6000497', '210305720110J6000511', '210305720110J6000344',
 '210305720310J6000316', '210305720110J6000507', '21030572019WJ6000305', '21030572019WJ6000286', '210305720110J6000470',
 '210305720110J6000442', '210305720310J6000199', '210305720110J6000428', '210305720110J6000415', '210305720110J6000406',
 '210305720110J6000451', '210305720110J6000469', '210305720110J6000408', '210305720310J6000321', '210305720310J6000190',
 '210305720110J7000029', '210305720110J7000040', '210305720110J7000030', '210305720310J6000189', '210305720110J6000503',
 '210305720110J6000457', '210305720110J6000466', '210305720310J7000016', '210305720310J7000004', '210305720110J7000004',
 '210305720110J7000009', '210305720310J7000074', '21030572029WJ7000054', '21030572029WJ7000036', '21030572019WJ7000027',
 '210305720110J7000020', '21030572029WJ7000082', '210305720210J7000018', '21030572029WJ7000053', '21030572019WJ7000054',
 '210305720310J7000057', '210305720110J7000026', '210305720310J7000039', '210305720310J7000041', '21030572019WJ5000047',
 '21030572029WJ5000151', '21030572029WJ5000146', '210305720310J5000195', '21030572029WJ5000210', '21030572029WJ5000162',
 '21030572029WJ5000180', '21030572029WJ5000256', '21030572029WJ5000291', '21030572029WJ5000280', '210305720110J5000250',
 '21030572029WJ5000313', '21030572019WJ5000124', '21030572019WJ5000156', '210305720110J5000295', '21030572019WJ6000016',
 '210305720210J5000057', '21030572019WJ5000187', '21030572019WJ6000027', '210305776710J6000050', '210305720110J6000190',
 '21030572029WJ6000161', '210305776710J6000035', '21030572019WJ6000214', '21030572029WJ6000290', '210305720110J6000007',
 '21030572019WJ6000057', '21030572029WJ6000037', '21030572029WJ6000045', '210305720110J6000055', '210305720110J6000065',
 '210305720110J6000255', '210305720110J6000480', '210305720110J6000229', '210305720310J6000022', '210305720210J6000031',
 '210305720310J6000023', '210305720310J6000132', '21030572019WJ6000406', '21030572019WJ6000405', '210305720110J6000295',
 '210305720310J7000014', '210305720110J6000348', '210305720110J6000413', '210305720110J6000458', '210305720310J6000197',
 '210305720310J6000195', '210305720110J6000399', '21030572039WJ6000202', '210305720110J6000367', '210305720110J6000371',
 '210305720110J6000447', '210305720310J7000086', '21030572029WJ7000043', '21030572029WJ7000026', '21030572019WJ5000007',
 '21030572019WJ5000027', '21030572029WJ5000143', '21030572029WJ5000340', '210305720210J5000081', '21030572019WJ5000153',
 '21030572019WJ6000022', '210305776710J6000049', '210305776710J6000018', '210305720110J6000090', '21030572019WJ6000084',
 '210305720110J6000025', '21030572039WJ6000163', '21030572019WJ6000420', '210305720310J6000124', '210305720310J6000130',
 '210305720110J6000304', '210305720110J7000027', '210305720110J6000494', '210305720310J6000318', '210305720110J6000446',
 '210305720110J6000439', '210305720110J6000444', '21030572019WJ7000004', '21030572029WJ5000346', '210305720210J5000049',
 '210305720210J6000026', '21030572019WJ6000356', '21030572039WJ7000002', '210305720110J6000489', '210305720110J6000429',
 '210305720210J6000092', '210305720110J2000083', '210305720110J2000084', '210305720310J2000113', '210305720310J2000114',
 '21030572019WJ2000135', '21030572019WJ2000136', '21030572019WJ2000123', '21030572019WJ2000124', '210305720110J2000115',
 '210305720310J2000141', '21030572019WJ2000081', '21030572019WJ2000082', '21030572019WJ2000101', '21030572019WJ2000102',
 '21030572019WJ2000087', '21030572019WJ2000088', '210305720110J3000020', '21030572019WJ2000099', '21030572019WJ2000100',
 '210305720310J3000059', '210305720310J3000061', '21030572029WJ3000019', '21030572029WJ3000041', '21030572029WJ3000042',
 '21030572029WJ3000073', '21030572029WJ3000074', '21030572029WJ3000075', '21030572029WJ3000076', '21030572029WJ3000016',
 '21030572029WJ3000017', '21030572029WJ3000018', '21030572029WJ3000040', '21030572029WJ3000034', '21030572029WJ3000035',
 '21030572019WJ2000131', '21030572019WJ2000132', '21030572019WJ2000137', '21030572019WJ2000138', '21030572019WJ2000127',
 '21030572019WJ2000128', '21030572019WJ2000129', '21030572019WJ2000133', '21030572019WJ2000134', '21030572029WJ3000077',
 '21030572029WJ3000078', '21030572029WJ3000024', '21030572019WJ2000115', '21030572019WJ2000116', '21030572019WJ2000079',
 '21030572019WJ2000080', '21030572019WJ2000077', '21030572019WJ2000078', '21030572019WJ2000093', '21030572019WJ2000094',
 '21030572019WJ2000075', '21030572019WJ2000076', '21030572029WJ3000185', '21030572029WJ3000186', '21030572029WJ3000173',
 '21030572029WJ3000214', '21030572029WJ3000200', '21030572029WJ3000195', '21030572029WJ3000196', '21030572029WJ3000152',
 '210305720110J2000110', '210305720110J2000112', '210305720110J2000113', '21030572029WJ3000178', '21030572029WJ3000209',
 '21030572029WJ3000206', '21030572029WJ3000212', '21030572029WJ3000215', '21030572019WJ2000097', '21030572019WJ2000098',
 '210305720110J2000111', '21030572029WJ3000030', '210305720110J2000108', '210305720310J3000288', '21030572029WJ2000095',
 '21030572029WJ2000096', '210305720310J3000116', '210305720310J3000112', '210305720310J3000156', '210305720310J3000157',
 '210305720310J3000197', '210305720310J3000198', '210305776710J3000007', '210305776710J3000008', '210305720110J3000053',
 '210305720110J3000054', '210305720110J3000055', '210305720110J3000056', '21030572019WJ3000135', '21030572019WJ3000136',
 '21030572019WJ3000099', '21030572019WJ3000101', '21030572019WJ3000127', '21030572019WJ3000128', '21030572019WJ3000133',
 '21030572019WJ3000134', '21030572019WJ3000125', '21030572019WJ3000126', '21030572019WJ3000123', '21030572019WJ3000124',
 '21030572019WJ3000147', '21030572019WJ3000148', '21030572019WJ3000145', '21030572019WJ3000146', '21030572019WJ3000139',
 '21030572019WJ3000140', '21030572019WJ3000131', '21030572019WJ3000132', '21030572019WJ3000100', '21030572019WJ3000102',
 '21030572019WJ3000141', '21030572019WJ3000142', '210305720110J3000059', '210305720110J3000060', '21030572029WJ3000271',
 '21030572029WJ3000272', '21030572029WJ3000273', '21030572029WJ3000274', '21030572029WJ3000263', '21030572029WJ3000266',
 '21030572019WJ3000090', '21030572019WJ3000094', '21030572019WJ3000097', '21030572019WJ3000098', '21030572019WJ3000095',
 '21030572019WJ3000096', '21030572029WJ3000267', '21030572029WJ3000268', '21030572019WJ3000075', '21030572019WJ3000076',
 '21030572019WJ3000077', '21030572019WJ3000078', '21030572019WJ3000081', '21030572019WJ3000082', '21030572029WJ3000249',
 '21030572029WJ3000250', '21030572019WJ3000089', '21030572019WJ3000091', '21030572029WJ3000247', '21030572029WJ3000248',
 '21030572029WJ3000253', '21030572029WJ3000254', '21030572029WJ3000262', '21030572029WJ3000265', '21030572029WJ3000269',
 '21030572029WJ3000270', '21030572019WJ3000151', '21030572019WJ3000152', '21030572029WJ3000257', '21030572029WJ3000258',
 '21030572029WJ3000251', '21030572029WJ3000252', '21030572029WJ3000259', '21030572029WJ3000260', '21030572029WJ3000255',
 '21030572029WJ3000256', '21030572019WJ3000155', '21030572019WJ3000156', '21030572019WJ3000157', '21030572019WJ3000158',
 '21030572019WJ3000161', '21030572019WJ3000162', '21030572019WJ3000165', '21030572019WJ3000166', '21030572019WJ3000167',
 '21030572019WJ3000168', '21030572019WJ3000169', '21030572019WJ3000170', '210305720110J3000057', '210305720110J3000058',
 '210305720310J3000203', '210305720310J3000204', '210305720310J3000205', '210305720310J3000206', '210305720310J3000199',
 '21030572029WJ3000281', '21030572029WJ3000282', '21030572019WJ3000079', '21030572019WJ3000080', '21030572019WJ3000083',
 '21030572019WJ3000084', '21030572019WJ3000087', '21030572019WJ3000088', '21030572019WJ3000092', '21030572019WJ3000093',
 '210305720110J3000061', '210305720110J3000048', '210305720110J3000049', '210305720310J3000176', '21030572029WJ3000261',
 '21030572029WJ3000264', '210305720110J3000092', '210305720110J3000093', '21030572019WJ3000129', '21030572019WJ3000130',
 '21030572019WJ3000144', '21030572019WJ3000137', '21030572019WJ3000138', '21030572019WJ3000149', '21030572019WJ3000150',
 '21030572019WJ3000153', '21030572019WJ3000154', '21030572019WJ3000163', '21030572019WJ3000164', '21030572019WJ3000171',
 '21030572019WJ3000172', '21030572019WJ3000175', '21030572019WJ3000176', '21030572019WJ3000179', '21030572019WJ3000180',
 '21030572019WJ3000183', '21030572019WJ3000184', '21030572019WJ3000185', '21030572019WJ3000186', '21030572019WJ3000177',
 '21030572019WJ3000178', '21030572019WJ3000191', '21030572019WJ3000192', '21030572019WJ3000193', '21030572019WJ3000194',
 '21030572019WJ3000195', '21030572019WJ3000196', '21030572019WJ3000197', '21030572019WJ3000198', '21030572019WJ3000199',
 '21030572019WJ3000200', '21030572019WJ3000201', '21030572019WJ3000202', '21030572019WJ3000203', '21030572019WJ3000204',
 '21030572019WJ3000207', '21030572019WJ3000208', '21030572019WJ3000239', '21030572019WJ3000240', '21030572019WJ3000246',
 '21030572029WJ3000283', '21030572029WJ3000284', '21030572029WJ3000291', '21030572029WJ3000292', '21030572029WJ3000289',
 '21030572029WJ3000290', '21030572029WJ3000277', '21030572029WJ3000278', '21030572029WJ3000279', '21030572029WJ3000353',
 '21030572029WJ3000354', '21030572029WJ3000357', '21030572029WJ3000358', '21030572029WJ3000351', '21030572029WJ3000352',
 '21030572029WJ3000343', '21030572029WJ3000344', '21030572029WJ3000315', '21030572029WJ3000316', '21030572029WJ3000317',
 '21030572029WJ3000318', '21030572029WJ3000319', '21030572029WJ3000320', '21030572029WJ3000323', '21030572029WJ3000324',
 '21030572029WJ3000325', '21030572029WJ3000326', '21030572029WJ3000339', '21030572029WJ3000340', '21030572029WJ3000335',
 '21030572029WJ3000336', '21030572029WJ3000333', '21030572029WJ3000334', '21030572029WJ3000285', '21030572029WJ3000286',
 '21030572029WJ3000337', '21030572029WJ3000338', '21030572029WJ3000341', '21030572029WJ3000342', '21030572029WJ3000355',
 '21030572029WJ3000356', '21030572029WJ3000347', '21030572029WJ3000348', '21030572029WJ3000275', '21030572029WJ3000276',
 '21030572029WJ3000349', '21030572029WJ3000350', '21030572019WJ3000085', '21030572019WJ3000086', '21030572019WJ3000249',
 '21030572019WJ3000250', '21030572029WJ3000327', '21030572029WJ3000328', '21030572029WJ3000331', '21030572029WJ3000332',
 '21030572019WJ3000216', '21030572029WJ3000313', '21030572029WJ3000314', '21030572029WJ3000311', '21030572029WJ3000312',
 '21030572019WJ3000205', '21030572019WJ3000206', '21030572019WJ3000251', '21030572019WJ3000252', '21030572029WJ3000321',
 '21030572029WJ3000322', '21030572029WJ3000329', '21030572029WJ3000330', '21030572029WJ3000345', '21030572029WJ3000346',
 '21030572019WJ3000217', '21030572019WJ3000218', '210305720310J3000248', '210305720310J3000249', '210305720310J3000250',
 '210305720310J3000251', '210305720310J3000252', '210305720310J3000253', '21030572029WJ3000287', '21030572029WJ3000288',
 '210305720110J3000076', '21030572029WJ3000243', '21030572029WJ3000244', '210305720310J3000254', '210305720310J3000255',
 '210305720110J3000104', '210305720110J3000105', '210305720110J3000103', '210305720110J3000147', '210305720110J3000148',
 '210305720110J3000179', '210305720110J3000180', '210305720110J3000181', '210305720110J3000182', '210305720110J3000183',
 '210305720110J3000184', '210305720110J3000171', '210305720110J3000172', '210305720310J3000321', '210305720110J3000161',
 '210305720110J3000160', '210305720110J3000157', '210305720110J3000156', '210305720110J3000158', '210305720110J3000153',
 '210305720110J3000078', '210305720110J3000079', '210305720310J3000319', '210305720310J3000320', '21030572029WJ3000245',
 '21030572029WJ3000246', '210305720110J3000044', '210305720110J3000045', '210305720110J3000115', '210305720110J3000116',
 '210305720110J3000080', '210305720110J3000083', '210305720110J3000139', '210305720110J3000140', '210305720110J3000085',
 '210305720110J3000086', '210305720110J3000113', '210305720110J3000114', '210305720110J3000081', '210305720110J3000090',
 '210305720110J3000129', '210305720110J3000087', '210305720110J3000088', '210305720110J3000082', '210305720110J3000128',
 '210305720110J3000091', '210305720110J3000141', '210305720110J3000142', '21030572019WJ3000159', '21030572019WJ3000160',
 '21030572019WJ3000173', '21030572019WJ3000174', '21030572019WJ3000181', '21030572019WJ3000182', '21030572019WJ3000187',
 '21030572019WJ3000188', '21030572019WJ3000189', '21030572019WJ3000190', '21030572019WJ3000263', '210305720310J3000284',
 '210305720310J3000286', '210305720310J3000291', '210305720310J3000246', '210305720310J3000247', '210305720310J4000061',
 '210305720310J4000064', '210305720110J3000143', '210305720110J4000032', '210305720110J4000033', '210305720110J4000031',
 '210305720110J4000028', '210305720110J4000029', '21030572019WJ3000261', '21030572019WJ3000262', '21030572019WJ3000258',
 '21030572019WJ3000255', '210305720310J4000045', '210305720310J4000053', '210305720310J4000276', '210305720110J4000172',
 '210305776710J4000037', '210305776710J4000038', '210305720110J4000174', '210305720110J4000175', '210305720110J4000176',
 '210305720110J4000177', '210305720310J4000302', '210305720310J4000303', '210305720310J4000286', '210305720110J4000161',
 '210305720110J4000162', '210305720110J4000184', '210305720310J4000318', '210305720110J4000195', '210305720110J4000196',
 '210305720110J4000192', '210305720110J4000201', '210305720110J4000185', '210305720110J4000186', '210305720110J4000199',
 '210305720310J4000349', '210305720110J4000197', '210305720110J4000198', '210305720110J4000268', '210305720110J4000203',
 '210305720110J4000204', '21030572029WJ4000078', '210305720310J4000330', '210305720310J4000331', '210305720310J4000329',
 '210305720310J4000342', '210305720310J4000337', '21030572019WJ4000033', '21030572019WJ4000028', '21030572019WJ4000029',
 '21030572019WJ4000019', '21030572019WJ4000020', '21030572029WJ4000055', '21030572029WJ4000056', '21030572029WJ4000040',
 '21030572029WJ4000042', '21030572029WJ4000035', '21030572029WJ4000036', '21030572029WJ4000034', '21030572029WJ4000031',
 '21030572029WJ4000032', '21030572029WJ4000059', '21030572029WJ4000060', '21030572029WJ4000057', '21030572029WJ4000058',
 '21030572029WJ4000065', '21030572029WJ4000079', '210305720110J5000080', '210305720110J5000001', '210305720110J5000002',
 '21030572029WJ4000069', '21030572029WJ4000070', '210305720310J5000064', '210305720310J5000065', '210305720310J5000069',
 '210305720310J5000100', '210305720310J5000101', '210305720310J5000098', '210305720310J5000099', '21030572029WJ4000067',
 '210305720310J4000290', '210305720310J4000291', '210305720310J4000289', '210305720310J5000023', '210305720310J5000024',
 '210305720310J5000021', '210305720310J5000022', '210305720310J5000019', '210305720310J5000020', '210305720310J5000017',
 '210305720310J5000018', '210305720310J5000036', '210305720310J5000037', '21030572029WJ5000003', '210305720110J5000151',
 '210305720110J5000152', '210305720110J5000150', '210305720110J5000154', '210305720110J5000158', '210305720110J5000162',
 '210305720110J5000138', '210305720110J5000139', '210305720110J5000137', '210305720310J5000044', '210305720310J5000045',
 '210305720110J5000126', '210305720110J4000156', '210305720110J4000158', '210305720110J4000157', '210305720110J4000150',
 '210305720110J4000151', '21030572019WJ5000076', '21030572019WJ5000078', '210305720110J5000147', '21030572029WJ5000130',
 '21030572019WJ5000107', '21030572019WJ5000108', '21030572019WJ5000093', '21030572019WJ5000098', '21030572029WJ5000055',
 '21030572019WJ5000113', '21030572019WJ5000114', '21030572019WJ5000086', '21030572019WJ5000087', '210305720110J4000154',
 '21030572029WJ5000052', '21030572019WJ5000001', '21030572019WJ5000075', '21030572019WJ5000115', '21030572019WJ5000116',
 '210305720110J4000153', '210305720110J4000155', '210305720110J4000159', '21030572019WJ5000100', '21030572019WJ5000102',
 '21030572019WJ5000095', '21030572019WJ5000096', '21030572019WJ5000110', '21030572019WJ5000111', '21030572019WJ5000112',
 '21030572019WJ5000103', '21030572019WJ5000104', '21030572019WJ5000099', '21030572019WJ5000097', '210305720310J4000268',
 '210305720310J4000260', '210305720310J4000262', '21030572019WJ4000038', '21030572019WJ4000042', '210305720310J4000263',
 '21030572019WJ5000081', '21030572019WJ5000083', '21030572019WJ5000084', '21030572019WJ5000085', '21030572019WJ5000089',
 '21030572019WJ5000036', '21030572019WJ5000077', '21030572019WJ5000079', '210305720110J5000262', '210305720110J5000170',
 '210305720210J5000028', '210305720210J5000019', '210305720210J5000022', '210305720210J5000027', '210305720210J5000015',
 '210305720210J5000024', '210305720210J5000021', '210305720310J6000063', '210305720110J4000271', '210305720110J5000008',
 '210305720310J4000348', '210305720110J6000180', '210305720310J5000031', '210305720110J6000124', '210305720310J4000347',
 '210305720310J5000032', '210305720110J5000005', '210305720110J5000009', '210305720110J5000004', '210305720110J5000011',
 '210305720310J5000006', '210305720310J5000026', '210305720310J5000067', '210305720310J4000041', '210305720310J1000245',
 '210305720110HC000355', '210305720310HC000297', '210305720310HC000268', '210305776710HC000043', '210305720310HC000265',
 '210305720110HC000225', '210305720110HC000457', '210305776710HC000037', '210305720310HC000364', '210305720310HC000299',
 '210305720110HC000308', '210305720110HC000302', '210305720310HC000269', '210305720110HC000311', '210305720110HC000253',
 '210305720110HC000230', '21030572019WHC000321', '210305720110HC000424', '210305720110HC000458', '210305720110HC000245',
 '210305720110HC000485', '210305720110HC000419', '210305720110HC000421', '210305720310HC000305', '210305720110HC000306',
 '210305720110HC000223', '210305720110HC000429', '210305720110HC000427', '210305720310HC000354', '210305776710HC000040',
 '210305720310HC000296', '210305720310HC000294', '210305720110HC000320', '21030572019WHC000306', '210305720110HC000318',
 '210305720310HC000286', '210305720110HC000313', '210305720110HC000247', '210305720110HC000254', '210305776710HC000038',
 '210305720110HC000297', '210305720110HC000224', '210305720110HC000324', '210305720310HC000363', '210305720110HC000327',
 '210305720110HC000296', '210305720310HC000314', '210305776710HC000041', '210305720110HC000312', '210305720110HC000268',
 '210305720110HC000310', '210305720110HC000430', '210305720110HC000423', '210305720310HC000355', '210305720310HC000357',
 '210305776710HC000045', '21030572019WHC000291', '21030572029WHC000300', '21030572029WHC000140', '21030572029WHC000299',
 '210305771910HC000001', '210305720310HC000156', '210305720310HC000193', '21030572029WHC000173', '210305720110J1000598',
 '210305720310HC000169', '21030572019WHC000296', '210305720110HC000300', '21030572029WHC000268', '21030572029WHC000298',
 '210305720310HC000233', '210305720310HC000234', '21030572029WHC000255', '21030572029WHC000235', '21030572029WHC000176',
 '21030572029WHC000180', '21030572029WHC000324', '21030572019WHC000294', '21030572029WHC000321', '210305720310HC000150',
 '210305720110J1000619', '210305720110HC000184', '210305720110J1000596', '21030572029WHC000323', '210305720310HC000165',
 '21030572029WHC000296', '21030572029WHC000137', '21030572029WHC000179', '210305720110HC000195', '21030572029WHC000237',
 '210305720310HC000246', '210305720310J1000018', '210305720110HC000243', '210305720310J1000005', '210305720110HC000199',
 '210305720310HC000198', '210305720110HC000175', '210305720110HC000176', '21030572019WHC000331', '21030572029WHC000200',
 '21030572019WHC000326', '210305720310HC000131', '21030572029WHC000181', '21030572019WHC000345', '210305720110HC000209',
 '21030572019WHC000304', '21030572019WHC000303', '21030572019WHC000308', '21030572019WHC000401', '21030572019WHC000252',
 '21030572019WHC000359', '21030572019WHC000348', '21030572019WHC000357', '210305720310HC000094', '21030572019WHC000399',
 '21030572019WHC000408', '210305720110HC000282', '21030572029WHC000244', '21030572019WHC000400', '210305720110HC000220',
 '210305720110HC000222', '210305720310HC000101', '21030572019WHC000307', '210305720110HC000211', '21030572029WHC000232',
 '21030572019WHC000314', '210305720110HC000147', '21030572029WHC000234', '21030572029WHC000218', '21030572019WHC000402',
 '210305720110HC000289', '210305720310HC000126', '21030572029WHC000214', '21030572019WHC000313', '21030572019WHC000351',
 '210305720110HC000215', '210305720110HC000275', '21030572019WHC000386', '210305720110HC000181', '21030572029WHC000245',
 '21030572019WHC000346', '210305720110HC000214', '21030572019WHC000368', '210305720110HC000292', '21030572019WHC000356',
 '210305720110HC000155', '210305720310HC000100', '21030572029WHC000231', '210305720110HC000272', '21030572029WHC000293',
 '21030572019WHC000250', '21030572029WHC000213', '210305720110HC000216', '21030572019WHC000334', '210305720110HC000157',
 '21030572019WHC000339', '21030572019WHC000406', '210305720310HC000175', '21030572029WHC000222', '21030572019WHC000403',
 '210305720110HC000212', '21030572029WHC000246', '210305720110HC000221', '21030572019WHC000352', '21030572019WHC000283',
 '21030572019WHC000148', '21030572019WHC000237', '21030572019WHC000272', '210305776710HC000029', '21030572019WHC000257',
 '21030572019WHC000246', '21030572019WHC000265', '210305720110HC000499', '210305720110HC000471', '210305720110HC000562',
 '210305720110HC000528', '21030572019WJ1000054', '210305720110HC000141', '21030572019WHC000377', '21030572019WHC000173',
 '21030572029WHC000343', '21030572029WHC000337', '21030572029WHC000338', '210305720310HC000062', '210305776710HC000009',
 '21030572019WHC000216', '210305776710HC000057', '21030572019WHC000217', '21030572029WHC000344', '210305776710J4000021',
 '210305720110HC000467', '210305776710HC000011', '210305720110HC000466', '210305720310HC000239', '21030572019WHC000289',
 '210305776710HC000060', '21030572019WHC000213', '210305776710HC000064', '21030572019WHC000204', '210305720310HC000084',
 '21030572019WHC000363', '21030572019WHC000235', '210305720310HC000091', '210305720110J4000063', '21030572019WHC000167',
 '21030572019WHC000189', '21030572019WHC000193', '210305720310HC000063', '210305720310HC000092', '21030572019WHC000184',
 '21030572019WHC000225', '210305720110HC000497', '210305776710HC000015', '210305720110HC000101', '21030572019WHC000218',
 '21030572019WHC000226', '21030572019WHC000179', '21030572019WHC000178', '21030572019WHC000188', '210305776710HC000010',
 '210305720110HC000142', '21030572019WHC000176', '21030572019WHC000195', '21030572019WHC000236', '21030572019WHC000180',
 '21030572019WHC000290', '21030572019WHC000372', '21030572029WHC000340', '21030572019WHC000192', '210305720110HC000110',
 '210305720310HC000083', '21030572019WHC000364', '210305720110HC000099', '210305720110HC000465', '210305776710HC000058',
 '21030572019WHC000194', '210305720110HC000143', '21030572019WHC000196', '21030572019WHC000203', '21030572019WHC000214',
 '210305720110HC000100', '210305776710HC000012', '210305720110HC000468', '210305720310HC000110', '21030572019WHC000186',
 '210305720310HC000111', '210305720310J1000062', '21030572019WJ1000003', '21030572019WHB000385', '21030572019WHB000336',
 '21030572019WHB000387', '210305720310J1000034', '210305720310J1000037', '210305776710HC000002', '21030572029WJ2000008',
 '210305720310J1000172', '21030572029WHC000053', '210305720110HB000327', '21030572019WHB000322', '21030572029WHB000990',
 '210305720110HB000335', '210305720110HB000369', '21030572019WHB000287', '21030572029WHB000996', '21030572029WHB001017',
 '21030572029WHB000972', '21030572029WHB000994', '210305720110HB000333', '21030572019WHB000314', '21030572019WHB000315',
 '210305720310HC000014', '21030572029WHB001038', '21030572029WHB000978', '210305720310HC000015', '210305720110J1000047',
 '210305720310J1000558', '210305720310J1000237', '210305720310HB000436', '210305720110J1000045', '210305720310HB000427',
 '210305720110J1000042', '210305720110HB000377', '210305720110J1000046', '210305720310HB000432', '21030572019WHB000236',
 '210305720310J4000114', '21030572019WHB000264', '210305720110HB000349', '21030572019WHB000278', '21030572019WHB000274',
 '210305720310HB000403', '21030572019WHC000071', '21030572029WHB000940', '21030572019WHB000262', '21030572019WHB000276',
 '21030572019WHB000280', '21030572019WHB000243', '21030572019WHC000065', '21030572019WHC000034', '21030572019WHB000212',
 '210305720110J4000148', '210305720110HB000282', '21030572029WHB000954', '21030572029WHB000937', '21030572019WHC000059',
 '21030572019WHC000035', '21030572019WHC000066', '21030572019WHC000015', '210305720110HB000302', '21030572019WHC000030',
 '21030572019WHB000210', '21030572029WHB000941', '21030572019WHB000291', '21030572019WHC000057', '210305720110HB000280',
 '21030572019WHB000269', '210305720310J1000335', '21030572019WHB000292', '21030572019WHC000024', '21030572019WHB000277',
 '21030572019WHC000060', '21030572019WHB000263', '21030572019WHC000073', '21030572019WHC000032', '21030572019WHB000214',
 '21030572029WHB000942', '21030572029WHB000949', '21030572029WHB000939', '21030572019WHB000285', '21030572019WHB000211',
 '21030572029WHB000983', '21030572019WHB000213', '21030572019WHC000063', '21030572019WHB000271', '21030572019WHC000056',
 '210305720310HB000404', '210305720310HB000402', '21030572019WHC000068', '210305720110HB000292', '21030572019WHC000062',
 '21030572019WHB000248', '210305720310HB000401', '210305720310J1000337', '21030572019WHB000279', '210305720110HB000350',
 '21030572029WHB000950', '21030572019WHC000064', '210305720310J1000327', '210305720110HB000312', '21030572019WHB000209',
 '21030572029WHB000991', '210305720110HB000310', '21030572019WHC000019', '210305720110HB000347', '21030572019WHC000016',
 '21030572019WHC000074', '21030572029WHB000984', '21030572019WHC000028', '210305720110HB000317', '210305720110HB000278',
 '21030572029WH9000897', '21030572029WHA000063', '21030572029WH9000951', '21030572029WHA000056', '21030572029WHA000081',
 '21030572029WH9000954', '21030572029WHA000068', '21030572029WHA000185', '21030572029WHA000053', '21030572029WH9000910',
 '21030572029WHA000065', '21030572029WHA000124', '21030572029WH9000939', '21030572029WH9000956', '21030572029WHA000059',
 '21030572029WH9000886', '21030572029WH9000966', '210305720110HA000036', '21030572029WHA000072', '210305720110HA000008',
 '21030572029WHA000183', '21030572029WHA000312', '21030572029WHA000311', '21030572029WH9000930', '21030572029WH9000885',
 '21030572029WH9000960', '21030572029WH9000904', '21030572029WH9000962', '21030572029WH9000942', '21030572029WHA000186',
 '21030572029WHA000003', '21030572029WH9000937', '210305720110HA000097', '21030572029WHA000027', '21030572029WHA000097',
 '210305720110HA000122', '21030572029WHA000594', '21030572029WHA000015', '21030572029WHA000020', '21030572029WHA000303',
 '21030572029WHA000112', '21030572029WHA000050', '21030572029WHA000040', '21030572029WHA000285', '21030572029WHA000035',
 '21030572029WHA000042', '21030572029WHA000168', '21030572029WHA000290', '21030572029WHA000046', '21030572029WHA000593',
 '210305720110HA000021', '21030572029WHA000021', '21030572029WHA000153', '21030572019WHA000017', '21030572029WHA000011',
 '21030572029WHA000116', '21030572029WHA000150', '21030572029WHA000108', '21030572029WHA000133', '21030572029WHA000167',
 '21030572029WHA000255', '21030572029WHA000077', '21030572029WHA000085', '210305720110HA000118', '21030572029WHA000288',
 '21030572029WHA000147', '21030572029WHA000128', '21030572029WHA000044', '21030572029WHA000083', '21030572029WHA000078',
 '210305720110HA000153', '21030572029WHA000304', '21030572029WHA000010', '21030572019WHA000016', '210305776710HA000004',
 '21030572029WHA000080', '21030572029WHA000111', '21030572029WHA000014', '21030572029WHA000049', '21030572029WHA000279',
 '21030572029WHA000018', '21030572029WHA000019', '21030572029WHA000095', '21030572029WHA000301', '21030572029WHA000597',
 '21030572029WHA000256', '21030572029WHA000254', '21030572029WH9000552', '21030572029WHA000131', '210305720110HA000159',
 '21030572029WHA000287', '21030572029WHA000033', '210305720110HA000109', '21030572029WHA000591', '21030572029WHA000284',
 '21030572029WHA000104', '210305720110HA000121', '21030572029WHA000029', '210305720110HA000113', '210305720110HA000161',
 '21030572029WHA000125', '210305720110HA000112', '210305720110HA000108', '21030572029WHA000089', '210305720110HA000163',
 '21030572029WHA000047', '210305720110HA000094', '21030572029WHA000048', '21030572029WHA000127', '21030572029WH9000534',
 '210305720110HB000161', '21030572029WH9000545', '210305776710HA000005', '210305720110HB000164', '210305720110HB000165',
 '21030572029WH9000550', '210305720110HB000163', '210305720110HB000162', '21030572029WH9000549', '21030572029WH9000547',
 '210305720110HB000160', '21030572029WH9000544', '21030572029WH9000533', '21030572029WH9000541', '21030572029WHA000092',
 '21030572029WH9000548', '21030572029WH9000543', '210305720110HB000157', '21030572029WH9000546', '210305720110HB000156',
 '21030572029WH9000553', '21030572029WH9000403', '21030572029WH9000374', '21030572029WH9000400', '21030572019WH9000302',
 '21030572029WH9000355', '210305720110H9000235', '210305720110H9000261', '210305720110H9000182', '210305720110H9000302',
 '210305720110H9000186', '21030572029WH9000341', '21030572029WH9000421', '210305720110H9000180', '210305720110H9000207',
 '21030572029WH9000414', '210305720110H9000237', '210305720110H9000202', '21030572029WH9000388', '210305720110H9000170',
 '21030572029WH9000415', '21030572019WH9000306', '21030572029WH9000345', '21030572029WH9000406', '21030572029WH9000356',
 '21030572029WH9000384', '21030572029WH9000387', '210305720110H9000412', '210305720110H9000185', '21030572029WH9000375',
 '21030572029WH9000408', '21030572019WH9000309', '21030572029WH9000407', '210305720110H9000424', '210305720110H9000204',
 '21030572019WH9000293', '210305720110H9000236', '21030572029WH9000361', '21030572029WH9000340', '21030572029WH9000413',
 '210305720110H9000179', '210305720110H9000193', '21030572029WH9000369', '21030572029WH9000367', '210305720110H9000198',
 '21030572029WH9000376', '210305720110H9000173', '210305720110H9000222', '210305720110H9000445', '21030572029WH9000404',
 '21030572019WH9000296', '210305720110H9000178', '210305720110H9000262', '210305720110H9000414', '210305720110H9000176',
 '21030572029WH9000359', '21030572029WH9000378', '21030572029WH9000399', '21030572029WH9000352', '210305720110H9000206',
 '21030572029WH9000539', '21030572029WH9000362', '210305720110H9000423', '21030572029WH9000354', '21030572029WH9000422',
 '21030572029WH9000417', '210305720110H9000174', '210305720110H9000158', '210305720110H9000137', '21030572029WH9000381',
 '21030572029WH9000536', '21030572029WH9000338', '21030572029WH9000479', '21030572029WH9000343', '21030572029WH9000540',
 '210305720110H9000142', '210305720110H9000195', '21030572029WH9000260', '21030572019WH9000071', '21030572019WH9000176',
 '21030572029WH9000106', '210305720310H8000317', '21030572019WH9000178', '21030572019WH9000068', '210305720110H9000011',
 '21030572019WH9000151', '21030572029WH9000015', '21030572029WH9000196', '21030572019WH9000140', '21030572019WH9000133',
 '21030572019WH9000079', '21030572029WH9000180', '21030572019WH9000149', '21030572019WH9000153', '21030572019WH9000120',
 '21030572019WH9000074', '21030572019WH9000044', '21030572029WH9000117', '21030572019WH9000156', '21030572029WH9000014',
 '21030572019WH9000175', '21030572019WH9000158', '210305720110H8000299', '21030572029WH9000104', '21030572019WH9000059',
 '21030572019WH9000115', '210305720310H8000318', '21030572029WH9000167', '21030572019WH9000139', '21030572019WH9000162',
 '21030572019WH9000152', '21030572019WH9000157', '21030572019WH9000164', '210305720110H8000294', '21030572019WH9000160',
 '21030572019WH9000172', '210305720110H8000298', '21030572019WH9000161', '21030572019WH9000171', '210305720110H8000295',
 '21030572019WH9000154', '21030572019WH9000163', '21030572019WH9000069', '21030572019WH9000072', '21030572019WH9000159',
 '21030572029WH9000264', '21030572019WH9000057', '21030572019WH9000150', '21030572019WH9000137', '21030572029WH9000108',
 '21030572019WH9000186', '21030572029WH9000126', '21030572019WH9000082', '21030572029WH9000170', '21030572019WH9000166',
 '21030572019WH9000124', '21030572029WH9000118', '210305720110H9000008', '21030572019WH9000180', '21030572019WH9000165',
 '21030572029WH9000125', '21030572019WH9000177', '21030572029WH9000010', '21030572019WH9000155', '21030572019WH9000060',
 '21030572019WH9000179', '21030572029WH9000016', '21030572029WH9000160', '21030572019WH9000067', '21030572019WH9000083',
 '21030572019WH9000183', '21030572029WH9000276', '21030572029WH9000116', '21030572019WH9000116', '21030572019WH9000076',
 '21030572029WH9000007', '21030572029WH9000168', '21030572019WH9000080', '21030572029WH9000166', '21030572019WH9000185',
 '21030572029WH9000013', '21030572029WH9000259', '21030572019WH9000122', '21030572019WH9000181', '21030572019WH9000167',
 '210305720110H9000029', '21030572019WH9000182', '21030572029WH9000275', '21030572019WH9000138', '21030572019WH9000168',
 '21030572019WH9000123', '21030572019WH9000073', '21030572029WH9000009', '21030572019WH9000184', '21030572019WH9000084',
 '21030572019WH9000085', '21030572019WH9000117', '21030572029WH9000019', '21030572019WH9000130', '21030572019WH9000170',
 '21030572019WH9000136', '21030572029WH9000115', '21030572029WH9000103', '21030572029WH9000008', '21030572029WH9000107',
 '210305720110H8000296', '21030572019WH9000075', '21030572029WH9000193', '21030572019WH9000174', '21030572019WH9000144',
 '21030572019WH9000081', '21030572019WH9000121', '21030572029WH9000179', '21030572029WH9000195', '21030572019WH9000141',
 '21030572029WH9000120', '21030572019WH9000070', '21030572019WH9000118', '21030572019WH9000134', '21030572019WH9000129',
 '21030572019WH9000142', '210305720110H9000010', '21030572029WH9000119', '21030572019WH9000135', '210305720110H9000002',
 '21030572029WH9000165', '21030572019WH9000169', '21030572019WH9000119', '21030572029WH9000273', '21030572019WH9000043',
 '210305720110J5000226', '210305771110J5000040', '21030572029WJ5000351', '21030572019WJ5000204', '21030572019WJ5000178',
 '21030572019WJ5000167', '210305793410J6000002', '210305720310J5000219', '21030572019WJ5000136', '21030572019WJ5000159',
 '21030572029WJ5000262', '21030572029WJ5000354', '210305720210J5000068', '21030572029WJ6000010', '210305720210J6000005',
 '210305720210J6000010', '21030572029WJ5000312', '21030572029WJ5000249', '21030572029WJ5000279', '21030572029WJ5000318',
 '210305793410J6000044', '210305771110J6000013', '21030572019WJ6000065', '210305720210J6000063', '210305720110J5000317',
 '210305720110J6000260', '21030572029WJ5000360', '210305771110J6000071', '21030572019WJ6000051', '21030572019WJ5000140',
 '21030572019WJ5000179', '21030572029WJ6000170', '21030572039WJ5000034', '210305720110J6000103', '210305720110J6000101',
 '210305720110J6000097', '21030572029WJ7000049', '21030572029WJ7000050', '21030572029WJ7000039', '21030572029WJ7000040',
 '210305720110J7000265', '210305720110J7000266', '210305720110J7000271', '210305720110J7000272', '210305720110J7000267',
 '210305720110J7000268', '210305720310J6000085', '210305720310J7000010', '210305720310J7000005', '210305720310J7000012',
 '210305720310J6000080', '210305720310J6000083', '210305793410J5000025', '210305771110J5000007', '210305793410J5000029',
 '210305771110J5000021', '210305771110J5000019', '210305771110J5000018', '210305771110J5000017', '210305793410J5000035',
 '210305771110J6000011', '210305771110J6000010', '210305771110J6000006', '210305793410J6000181', '210305793410J7000044',
 '210305793410J7000077', '210305793410J6000021', '210305793410J5000086', '210305793410J5000083', '210305793410J6000022',
 '210305771110J6000009', '210305771110J6000007', '210305771110J6000001', '210305771110J6000132', '210305793410J7000078',
 '210305720110J5000148', '210305720310J5000130', '210305720310J5000198', '210305720310J5000202', '210305720310J5000199',
 '210305720210J5000039', '210305720310J5000214', '210305720110J5000280', '210305720210J6000105', '210305720210J6000108',
 '210305720210J6000109', '210305720310J5000229', '210305720210J6000115', '210305720310J6000112', '210305720110J6000005',
 '210305720310J5000232', '210305720110J6000003', '210305720110J6000265', '210305720310J5000231', '210305720110J6000239',
 '210305720310J6000038', '210305720310J6000040', '210305720310J6000037', '210305720110J6000310', '210305720110J6000313',
 '210305720210J6000118', '210305720110J6000309', '210305720210J6000117', '210305720110J7000035', '210305720310J7000033',
 '210305720110J6000316', '210305720110J6000311', '210305720110J6000315', '210305720110J6000312', '210305720210J7000005',
 '210305720210J7000001', '210305720110J7000006', '210305720210J7000003', '210305720110J7000013', '210305720110J7000008',
 '210305720110J7000015', '210305720110J7000224', '210305720110J7000226', '210305720210J7000026', '210305720110J7000235',
 '210305720110J7000236', '210305720210J5000013', '210305720110J5000133', '210305720210J6000114', '210305720210J6000106',
 '210305720310J5000233', '210305720210J6000112', '210305720110J5000320', '210305720110J5000323', '210305720310J5000230',
 '210305720110J6000141', '210305720210J6000119', '210305720110J6000314', '210305720110J7000007', '210305720110J7000227',
 '210305720110J7000223', '210305720110J7000234', '210305720110J7000238', '210305720310J7000112', '210305720210J6000113',
 '210305720110J6000226', '210305720110J6000240', '210305720110J6000317', '210305720110J7000036', '210305720110J6000339',
 '210305720110J6000327', '210305720110J7000225', '210305720110J7000237', '210305720110J6000338', '210305720210J7000027',
 '210305720210J5000014', '210305720210J7000006', '210305720110J2000082', '210305720110J3000052', '210305720210J4000004',
 '210305720110J3000178', '210305720310J3000140', '210305720110J3000106', '210305720110J3000107', '210305720110J3000108',
 '210305720110J3000109', '210305720110J3000110', '210305720210J4000003', '210305720310J5000029', '210305720210J5000008',
 '210305720310J4000294', '210305720310J4000297', '210305720310J4000296', '210305720310J4000295', '210305720110J4000188',
 '210305720110J4000189', '210305720210J5000034', '210305720210J5000009', '210305720210J5000004', '210305720210J5000006',
 '210305720210J3000009', '210305720110J3000077', '210305720310HC000226', '210305720110HC000192', '210305720110HB000352',
 '210305720210HB000009', '210305720210HB000010', '210305720110HB000286', '210305720110HB000351', '210305720110HB000285',
 '210305720110H9000152', '210305720110H9000005', '210305720110H9000004', '210305720110H9000006', '210305720110H9000007',
 '210305720110H9000003', '210305720210J6000107', '210305720110J7000165', '210305720110J7000167', '210305720110J7000168',
 '210305720110J7000169', '210305720110J7000174', '210305720310J7000099', '210305720110J7000209', '210305720110J7000187',
 '210305771110J5000025', '210305771110J5000001', '210305771110J5000010', '210305771110J7000003', '210305720310J5000200',
 '210305720310J5000213', '210305720110J6000004', '210305720210J6000110', '210305720110J6000029', '210305720210J7000009',
 '210305720210J7000007', '210305720210J7000013', '210305720210J7000011', '210305720110J7000228', '210305720210J7000010',
 '210305720110J7000240', '210305720210J7000032', '210305720210J7000033', '210305720110J7000241', '210305720210J7000031',
 '210305720110J7000239', '210305720110J7000242', '210305720210J5000040', '210305776710J7000001', '210305720310J6000039',
 '210305720210J7000004', '210305720210J7000002', '210305720210J7000008', '210305720110J7000229', '210305720110J7000221',
 '210305720110J7000222', '210305720110J7000219', '210305720110J7000218', '210305720110J7000014', '210305720110J7000220',
 '210305720210J6000111', '210305720210J7000012', '210305720110J2000077', '210305720210J2000005', '210305720110J2000127',
 '210305720310J3000141', '210305720110J3000051', '210305720310J3000196', '210305720110J3000050', '210305720310J4000293',
 '21030572029WJ7000060', '210305776710J7000011', '210305776710J7000015', '210305776710J7000002', '210305776710J7000007',
 '210305776710J7000008', '210305776710J7000016', '210305776710J7000003', '210305776710J7000005', '210305776710J7000004',
 '210305776710J7000014', '210305776710J7000017', '210305720310J7000036', '210305720310J7000037', '210305776710J7000012',
 '210305776710J7000009', '210305776710J7000010', '210305776710J7000006', '21030572029WJ7000059', '210305776710J7000013',
 '210305771110J5000043', '210305793410J7000058', '210305793410J7000056', '210305771110J5000046', '210305771110J5000047',
 '210305793410J7000068', '210305771110J5000042', '210305793410J7000055', '210305793410J7000067', '210305793410J7000057',
 '210305771110J5000024', '21030572029WJ5000050', '21030572029WJ5000045', '21030572029WJ5000043', '21030572029WJ5000031',
 '21030572029WJ5000049', '21030572029WJ5000024', '21030572029WJ5000046', '21030572019WJ6000088', '21030572019WJ6000101',
 '21030572019WJ6000087', '21030572019WJ6000092', '21030572019WJ6000089', '210305720310J6000087', '210305720310J6000081',
 '210305720310J6000076', '210305720310J6000075', '210305720310J6000091', '21030572029WJ6000121', '21030572029WJ6000126',
 '21030572019WJ6000320', '21030572029WJ6000120', '21030572029WJ6000205', '21030572019WJ6000324', '21030572029WJ6000214',
 '21030572029WJ6000209', '21030572029WJ6000184', '21030572029WJ6000181', '21030572029WJ6000215', '21030572029WJ6000123',
 '210305720110J7000185', '21030572019WJ6000250', '21030572019WJ6000249', '21030572019WJ6000392', '21030572019WJ6000328',
 '21030572019WJ6000318', '21030572019WJ6000300', '21030572019WJ6000299', '210305720110J7000172', '21030572019WJ6000327',
 '21030572019WJ6000329', '21030572019WJ6000319', '210305720310J7000089', '210305720110J7000124', '210305720310J7000009',
 '210305720110J7000126', '210305720110J7000125', '210305720110J7000128', '210305720310J7000011', '210305720310J7000006',
 '210305720110J7000204', '210305720110J7000171', '210305720110J7000177', '210305720110J7000175', '210305720110J7000178',
 '210305720110J7000200', '210305720110J7000176', '210305720110J7000112', '210305720110J7000196', '210305720110J7000195',
 '210305720110J7000214', '210305720110J7000106', '210305720110J7000114', '210305720310J7000103', '210305720110J7000115',
 '210305720110J7000108', '210305720110J7000122', '210305720110J7000213', '210305720110J7000203', '210305720110J7000156',
 '210305720310J7000104', '210305720110J7000217', '210305720110J7000116', '210305720110J7000117', '210305720110J7000111',
 '210305720110J7000121', '210305720110J7000118', '210305720110J7000162', '210305720310J7000096', '210305720310J7000091',
 '210305720110J7000212', '210305720310J7000095', '210305720310J7000098', '210305720110J7000170', '210305720110J7000216',
 '210305720110J7000109', '210305720110J7000075', '210305720110J7000087', '210305720110J7000072', '210305720110J7000084',
 '210305720110J7000080', '210305720310J7000094', '210305720110J7000076', '210305720110J7000088', '210305720110J7000093',
 '210305720110J7000159', '210305720110J7000089', '210305720110J7000091', '210305720110J7000092', '210305720110J7000166',
 '210305720110J7000155', '210305720110J7000078', '210305720310J7000097', '210305720110J7000199', '210305720110J7000210',
 '210305720110J7000201', '210305720110J7000074', '210305720110J7000086', '210305720110J7000083', '210305720110J7000260',
 '210305720110J7000261', '210305720110J7000258', '21030572029WJ5000072', '21030572019WJ5000069', '21030572029WJ5000023',
 '21030572029WJ5000044', '21030572029WJ6000168', '21030572019WJ6000090', '21030572029WJ6000140', '210305720310J6000084',
 '21030572029WJ6000208', '21030572029WJ6000199', '21030572019WJ6000321', '21030572029WJ6000183', '21030572029WJ6000185',
 '21030572029WJ6000201', '21030572029WJ6000198', '21030572019WJ6000325', '21030572029WJ6000203', '21030572029WJ6000122',
 '21030572029WJ6000204', '21030572019WJ6000330', '21030572019WJ6000301', '21030572019WJ6000302', '210305720110J7000127',
 '210305720310J7000007', '210305720110J7000123', '210305720110J7000194', '210305720310J7000105', '210305720110J7000107',
 '210305720110J7000198', '210305720310J7000102', '210305720310J7000088', '210305720110J7000186', '210305720110J7000205',
 '210305720110J7000079', '210305720110J7000160', '210305720110J7000157', '210305720110J7000071', '210305720110J7000163',
 '210305720110J7000077', '210305720110J7000188', '210305720110J7000081', '210305720110J7000264', '210305720110J7000259',
 '210305720110J7000257', '210305720110J7000263', '210305720110J7000262', '21030572029WJ5000032', '21030572029WJ6000176',
 '210305720310J6000086', '21030572029WJ6000127', '21030572029WJ6000186', '21030572029WJ6000202', '21030572029WJ6000200',
 '21030572019WJ6000391', '210305720310J7000008', '210305720110J7000119', '210305720110J7000105', '210305720110J7000197',
 '210305720110J7000113', '210305720110J7000206', '210305720110J7000082', '210305720110J7000161', '210305720110J7000073',
 '210305720110J7000164', '210305720110J7000090', '210305720110J7000085', '210305720310J6000074', '21030572029WJ6000182',
 '210305720110J7000173', '210305720110J7000120', '210305720110J7000202', '210305720110J7000211', '210305720110J7000110',
 '210305720110J7000158', '210305720110J7000094', '210305720310J6000072', '210305720310J6000089', '210305720110J7000207',
 '21030572019WJ5000039', '21030572019WJ5000040', '21030572019WJ5000037', '21030572019WJ5000072', '21030572019WJ5000074',
 '21030572019WJ5000080', '21030572019WJ5000082', '21030572019WJ5000070', '21030572019WJ5000071', '21030572019WJ5000094',
 '21030572029WHC000333', '21030572019WJ5000038', '21030572019WJ6000102', '21030572019WJ6000097', '21030572029WJ6000151',
 '21030572029WJ6000175', '21030572039WJ6000103', '21030572039WJ6000078', '21030572039WJ6000073', '21030572039WJ6000074',
 '21030572039WJ6000077', '21030572039WJ6000130', '21030572039WJ6000104', '21030572039WJ6000086', '21030572039WJ6000076',
 '21030572039WJ6000075', '210305720210J7000028', '210305720110J7000181', '210305720110J7000182', '210305720110J7000179',
 '210305720110J7000180', '210305720210J7000030', '210305720110J7000183', '210305720110HA000147', '210305776710J9000001',
 '210305720110J8000012', '210305771110J9000006', '210305720110J9000032', '210305720110J8000042', '210305720210J8000077',
 '210305720110J8000068', '210305720210J9000008', '210305720310J8000011', '210305720210J9000010', '210305771110J9000007',
 '210305720210J8000005', '210305720210J8000067', '210305771110J8000008', '210305720110J9000015', '210305720310J8000015',
 '210305720210J8000089', '210305720210J8000075', '210305720110J9000008', '210305720210J9000003', '210305720210J8000093',
 '210305720310J8000005', '210305771110J8000004', '210305720310J8000008', '210305720210J8000049', '210305720110J8000049',
 '210305720210J8000057', '210305720310J8000007', '210305720110J9000019', '210305720310J8000035', '210305720310J8000033',
 '210305720210J8000042', '210305720110J9000013', '210305720110J9000001', '210305720110J8000015', '210305720210J8000054',
 '210305720110J8000059', '210305720310J8000014', '210305720110J8000050', '210305720210J8000072', '210305771110J8000006',
 '210305720310J8000016', '210305720210J9000001', '210305720110J9000021', '210305720110J9000009', '210305720110J9000003',
 '210305776710J8000004', '210305720110J8000006', '210305720110J9000016', '210305793410J8000004', '210305720110J9000039',
 '210305720210J8000041', '210305771110J8000001', '210305720210J8000071', '210305720310J8000004', '210305720210J8000069',
 '210305720110J8000044', '210305720310J8000021', '210305720210J8000010', '210305720110J8000028', '210305720110J8000029',
 '210305793410J9000002', '210305771110J9000002', '210305793410J9000003', '210305720210J8000087', '210305720110J8000041',
 '210305720210J8000088', '210305720310J8000034', '210305720210J8000064', '210305720210J8000039', '210305720110J8000058',
 '210305720110J8000039', '210305720110J9000037', '210305720110J8000032', '210305720210J8000080', '210305720110J8000031',
 '210305720110J8000020', '210305793410J9000009', '210305793410J8000003', '210305793410J8000002', '210305720110J8000022',
 '210305720210J9000004', '210305776710J8000003', '210305720210J8000092', '210305720210J8000040', '210305793410J8000010',
 '210305720210J8000004', '210305776710J8000005', '210305720210J8000085', '210305793410J9000005', '210305720210J8000009',
 '210305720310J8000037', '210305720110J8000061', '210305720110J8000057', '210305720110J8000003', '210305793410J8000016',
 '210305771110J8000007', '210305793410J8000014', '210305720210J9000007', '210305720110J9000036', '210305720110J9000020',
 '210305771110J9000018', '210305720110J8000033', '210305771110J9000004', '210305720210J8000056', '210305720310J8000028',
 '210305720110J8000017', '210305720110J8000040', '210305720210J8000037', '210305771110J9000019', '210305771110J9000014',
 '210305720310J8000020', '210305720210J8000011', '210305720210J8000070', '210305720210J8000008', '210305720210J8000066',
 '210305793410J8000008', '210305720210J9000009', '210305720210J8000076', '210305720210J8000003', '210305720210J8000074',
 '210305771110J8000010', '210305720110J8000019', '210305720310J8000024', '210305720110J8000014', '210305720210J8000050',
 '210305720110J8000035', '210305720110J9000034', '210305720310J8000009', '210305720110J8000034', '210305720210J8000091',
 '210305720110J8000021', '210305720110J9000014', '210305720110J9000006', '210305720110J9000007', '210305720310J8000019',
 '210305720310J8000023', '210305720110J9000030', '210305720110J9000002', '210305720210J8000062', '210305720110J8000027',
 '210305720210J8000046', '210305793410J9000008', '210305720110J8000009', '210305776710J8000001', '210305720210J8000078',
 '210305720210J8000079', '210305720110J8000065', '210305720110J9000033', '210305720210J8000055', '210305720210J8000086',
 '210305720310J8000027', '210305720110J8000038', '210305720210J8000068', '210305720210J8000013', '210305720110J8000053',
 '210305720110J8000036', '210305720110J8000018', '210305720110J8000037', '210305720210J9000016', '210305720110J8000063',
 '210305720210J9000005', '210305720210J8000061', '210305720110J8000010', '210305771110J9000001', '210305793410J8000001',
 '210305720110J8000067', '210305720210J8000063', '210305720110J8000005', '210305720310J8000013', '210305720210J8000006',
 '210305720210J8000002', '210305720310J8000012', '210305793410J8000005', '210305720210J8000059', '210305771110J8000003',
 '210305720110J9000041', '210305776710J8000002', '210305793410J8000011', '210305720110J8000052', '210305720110J9000043',
 '210305771110J9000020', '210305720110J9000004', '210305720210J8000095', '210305720110J8000002', '210305720110J8000008',
 '210305720110J9000018', '210305720110J8000030', '210305720110J8000054', '210305720110J9000022', '210305720210J8000044',
 '210305776710J9000002', '210305720210J8000048', '210305720310J8000022', '210305720110J8000001', '210305720210J9000012',
 '210305793410J8000009', '210305720210J8000090', '210305720210J9000011', '210305720210J8000047', '210305771110J9000005',
 '210305720110J8000013', '210305720210J8000082', '210305720110J9000040', '210305720110J8000016', '210305793410J9000004',
 '210305720110J8000055', '210305720210J9000006', '210305720110J9000017', '210305793410J9000001', '210305720110J8000060',
 '210305720310J8000036', '210305771110J9000015', '210305720110J8000066', '210305771110J9000003', '210305720210J8000051',
 '210305720310J8000006', '210305720310J8000025', '210305720310J8000018', '210305720110J9000005', '210305720110J8000011',
 '210305793410J8000015', '210305771110J8000014', '210305720110J9000012', '210305771110J8000009', '210305720210J8000081',
 '210305720210J8000053', '210305720110J8000043', '210305720210J8000038', '210305776710J9000003', '210305771110J9000017',
 '210305720210J8000058', '210305720110J8000007', '210305720110J8000023', '210305720210J8000083', '210305720210J8000073',
 '210305720210J8000012', '210305720210J8000065', '210305720310J8000003', '210305793410J8000012', '210305720110J9000031',
 '210305720310J8000010', '210305720210J9000002', '210305720210J8000060', '210305720210J8000036', '210305720110J8000025',
 '210305720110J8000062', '210305720210J8000094', '210305771110J9000013', '210305771110J9000016', '210305720310J8000026',
 '210305793410J8000013', '210305720210J8000001', '210305720210J8000052', '210305720210J8000007', '210305771110J8000002',
 '210305720210J8000045', '210305720210J8000043', '210305720110J8000051', '210305720210J9000013', '210305720210J8000084',
 '210305720110J8000024', '210305720110J8000056', '210305771110J8000005', '210305720110J8000026', '210305720110J8000004',
 '210305720310J8000017', '210305720110J9000042', '210305720110J8000064', '210305720110HA000137', '210305793410J5000069',
 '210305793410J5000070', '210305793410J5000067', '210305771110J4000053', '210305771110J4000054', '21030572039WJ5000016',
 '21030572039WJ5000015', '210305720110J7000019', '21030572039WJ7000064', '210305720110J7000018', '21030572039WJ7000063',
 '210305720110J3000167', '210305720110J3000169', '210305720110J3000168', '210305720110J3000170', '210305720110J3000165',
 '210305720110J3000164', '210305720110J3000175', '210305771110J5000005', '210305771110J5000002']

# 运营商IT版本风险控制器SN
RISK_SN_OPERATORS_IT = ['210305771110J6000011', '210305771110J6000010', '210305771110J6000006', '210305793410J6000181', '210305793410J7000044',
 '210305793410J7000077', '210305793410J6000021', '210305793410J5000086', '210305793410J5000083', '210305793410J6000022',
 '210305771110J6000009', '210305771110J6000007', '210305771110J6000001', '210305771110J6000132', '210305793410J7000078',
 '210305720110J5000148', '210305720310J5000130', '210305720310J5000198', '210305720310J5000202', '210305720310J5000199',
 '210305720210J5000039', '210305720310J5000214', '210305720110J5000280', '210305720210J6000105', '210305720210J6000108',
 '210305720210J6000109', '210305720310J5000229', '210305720210J6000115', '210305720310J6000112', '210305720110J6000005',
 '210305720310J5000232', '210305720110J6000003', '210305720110J6000265', '210305720310J5000231', '210305720110J6000239',
 '210305720310J6000038', '210305720310J6000040', '210305720310J6000037', '210305720110J6000310', '210305720110J6000313',
 '210305720210J6000118', '210305720110J6000309', '210305720210J6000117', '210305720110J7000035', '210305720310J7000033',
 '210305720110J6000316', '210305720110J6000311', '210305720110J6000315', '210305720110J6000312', '210305720210J7000005',
 '210305720210J7000001', '210305720110J7000006', '210305720210J7000003', '210305720110J7000013', '210305720110J7000008',
 '210305720110J7000015', '210305720110J7000224', '210305720110J7000226', '210305720210J7000026', '210305720110J7000235',
 '210305720110J7000236', '210305720210J5000013', '210305720110J5000133', '210305720210J6000114', '210305720210J6000106',
 '210305720310J5000233', '210305720210J6000112', '210305720110J5000320', '210305720110J5000323', '210305720310J5000230',
 '210305720110J6000141', '210305720210J6000119', '210305720110J6000314', '210305720110J7000007', '210305720110J7000227',
 '210305720110J7000223', '210305720110J7000234', '210305720110J7000238', '210305720310J7000112', '210305720210J6000113',
 '210305720110J6000226', '210305720110J6000240', '210305720110J6000317', '210305720110J7000036', '210305720110J6000339',
 '210305720110J6000327', '210305720110J7000225', '210305720110J7000237', '210305720110J6000338', '210305720210J7000027',
 '210305720210J5000014', '210305720210J7000006', '210305720110J2000082', '210305720110J3000052', '210305720210J4000004',
 '210305720110J3000178', '210305720310J3000140', '210305720110J3000106', '210305720110J3000107', '210305720110J3000108',
 '210305720110J3000109', '210305720110J3000110', '210305720210J4000003', '210305720310J5000029', '210305720210J5000008',
 '210305720310J4000294', '210305720310J4000297', '210305720310J4000296', '210305720310J4000295', '210305720110J4000188',
 '210305720110J4000189', '210305720210J5000034', '210305720210J5000009', '210305720210J5000004', '210305720210J5000006',
 '210305720210J3000009', '210305720110J3000077', '210305720310HC000226', '210305720110HC000192', '210305720110HB000352',
 '210305720210HB000009', '210305720210HB000010', '210305720110HB000286', '210305720110HB000351', '210305720110HB000285',
 '210305720110H9000152', '210305720110H9000005', '210305720110H9000004', '210305720110H9000006', '210305720110H9000007',
 '210305720110H9000003', '210305720210J6000107', '210305720110J7000165', '210305720110J7000167', '210305720110J7000168',
 '210305720110J7000169', '210305720110J7000174', '210305720310J7000099', '210305720110J7000209', '210305720110J7000187',
 '210305771110J5000025', '210305771110J5000001', '210305771110J5000010', '210305771110J7000003', '210305720310J5000200',
 '210305720310J5000213', '210305720110J6000004', '210305720210J6000110', '210305720110J6000029', '210305720210J7000009',
 '210305720210J7000007', '210305720210J7000013', '210305720210J7000011', '210305720110J7000228', '210305720210J7000010',
 '210305720110J7000240', '210305720210J7000032', '210305720210J7000033', '210305720110J7000241', '210305720210J7000031',
 '210305720110J7000239', '210305720110J7000242', '210305720210J5000040', '210305776710J7000001', '210305720310J6000039',
 '210305720210J7000004', '210305720210J7000002', '210305720210J7000008', '210305720110J7000229', '210305720110J7000221',
 '210305720110J7000222', '210305720110J7000219', '210305720110J7000218', '210305720110J7000014', '210305720110J7000220',
 '210305720210J6000111', '210305720210J7000012', '210305720110J2000077', '210305720210J2000005', '210305720110J2000127',
 '210305720310J3000141', '210305720110J3000051', '210305720310J3000196', '210305720110J3000050', '210305720310J4000293',
 '21030572029WJ7000060', '210305776710J7000011', '210305776710J7000015', '210305776710J7000002', '210305776710J7000007',
 '210305776710J7000008', '210305776710J7000016', '210305776710J7000003', '210305776710J7000005', '210305776710J7000004',
 '210305776710J7000014', '210305776710J7000017', '210305720310J7000036', '210305720310J7000037', '210305776710J7000012',
 '210305776710J7000009', '210305776710J7000010', '210305776710J7000006', '21030572029WJ7000059', '210305776710J7000013',
 '210305771110J5000043', '210305793410J7000058', '210305793410J7000056', '210305771110J5000046', '210305771110J5000047',
 '210305793410J7000068', '210305771110J5000042', '210305793410J7000055', '210305793410J7000067', '210305793410J7000057',
 '210305771110J5000024', '21030572029WJ5000050', '21030572029WJ5000045', '21030572029WJ5000043', '21030572029WJ5000031',
 '21030572029WJ5000049', '21030572029WJ5000024', '21030572029WJ5000046', '21030572019WJ6000088', '21030572019WJ6000101',
 '21030572019WJ6000087', '21030572019WJ6000092', '21030572019WJ6000089', '210305720310J6000087', '210305720310J6000081',
 '210305720310J6000076', '210305720310J6000075', '210305720310J6000091', '21030572029WJ6000121', '21030572029WJ6000126',
 '21030572019WJ6000320', '21030572029WJ6000120', '21030572029WJ6000205', '21030572019WJ6000324', '21030572029WJ6000214',
 '21030572029WJ6000209', '21030572029WJ6000184', '21030572029WJ6000181', '21030572029WJ6000215', '21030572029WJ6000123',
 '210305720110J7000185', '21030572019WJ6000250', '21030572019WJ6000249', '21030572019WJ6000392', '21030572019WJ6000328',
 '21030572019WJ6000318', '21030572019WJ6000300', '21030572019WJ6000299', '210305720110J7000172', '21030572019WJ6000327',
 '21030572019WJ6000329', '21030572019WJ6000319', '210305720310J7000089', '210305720110J7000124', '210305720310J7000009',
 '210305720110J7000126', '210305720110J7000125', '210305720110J7000128', '210305720310J7000011', '210305720310J7000006',
 '210305720110J7000204', '210305720110J7000171', '210305720110J7000177', '210305720110J7000175', '210305720110J7000178',
 '210305720110J7000200', '210305720110J7000176', '210305720110J7000112', '210305720110J7000196', '210305720110J7000195',
 '210305720110J7000214', '210305720110J7000106', '210305720110J7000114', '210305720310J7000103', '210305720110J7000115',
 '210305720110J7000108', '210305720110J7000122', '210305720110J7000213', '210305720110J7000203', '210305720110J7000156',
 '210305720310J7000104', '210305720110J7000217', '210305720110J7000116', '210305720110J7000117', '210305720110J7000111',
 '210305720110J7000121', '210305720110J7000118', '210305720110J7000162', '210305720310J7000096', '210305720310J7000091',
 '210305720110J7000212', '210305720310J7000095', '210305720310J7000098', '210305720110J7000170', '210305720110J7000216',
 '210305720110J7000109', '210305720110J7000075', '210305720110J7000087', '210305720110J7000072', '210305720110J7000084',
 '210305720110J7000080', '210305720310J7000094', '210305720110J7000076', '210305720110J7000088', '210305720110J7000093',
 '210305720110J7000159', '210305720110J7000089', '210305720110J7000091', '210305720110J7000092', '210305720110J7000166',
 '210305720110J7000155', '210305720110J7000078', '210305720310J7000097', '210305720110J7000199', '210305720110J7000210',
 '210305720110J7000201', '210305720110J7000074', '210305720110J7000086', '210305720110J7000083', '210305720110J7000260',
 '210305720110J7000261', '210305720110J7000258', '21030572029WJ5000072', '21030572019WJ5000069', '21030572029WJ5000023',
 '21030572029WJ5000044', '21030572029WJ6000168', '21030572019WJ6000090', '21030572029WJ6000140', '210305720310J6000084',
 '21030572029WJ6000208', '21030572029WJ6000199', '21030572019WJ6000321', '21030572029WJ6000183', '21030572029WJ6000185',
 '21030572029WJ6000201', '21030572029WJ6000198', '21030572019WJ6000325', '21030572029WJ6000203', '21030572029WJ6000122',
 '21030572029WJ6000204', '21030572019WJ6000330', '21030572019WJ6000301', '21030572019WJ6000302', '210305720110J7000127',
 '210305720310J7000007', '210305720110J7000123', '210305720110J7000194', '210305720310J7000105', '210305720110J7000107',
 '210305720110J7000198', '210305720310J7000102', '210305720310J7000088', '210305720110J7000186', '210305720110J7000205',
 '210305720110J7000079', '210305720110J7000160', '210305720110J7000157', '210305720110J7000071', '210305720110J7000163',
 '210305720110J7000077', '210305720110J7000188', '210305720110J7000081', '210305720110J7000264', '210305720110J7000259',
 '210305720110J7000257', '210305720110J7000263', '210305720110J7000262', '21030572029WJ5000032', '21030572029WJ6000176',
 '210305720310J6000086', '21030572029WJ6000127', '21030572029WJ6000186', '21030572029WJ6000202', '21030572029WJ6000200',
 '21030572019WJ6000391', '210305720310J7000008', '210305720110J7000119', '210305720110J7000105', '210305720110J7000197',
 '210305720110J7000113', '210305720110J7000206', '210305720110J7000082', '210305720110J7000161', '210305720110J7000073',
 '210305720110J7000164', '210305720110J7000090', '210305720110J7000085', '210305720310J6000074', '21030572029WJ6000182',
 '210305720110J7000173', '210305720110J7000120', '210305720110J7000202', '210305720110J7000211', '210305720110J7000110',
 '210305720110J7000158', '210305720110J7000094', '210305720310J6000072', '210305720310J6000089', '210305720110J7000207',
 '21030572019WJ5000039', '21030572019WJ5000040', '21030572019WJ5000037', '21030572019WJ5000072', '21030572019WJ5000074',
 '21030572019WJ5000080', '21030572019WJ5000082', '21030572019WJ5000070', '21030572019WJ5000071', '21030572019WJ5000094',
 '21030572029WHC000333', '21030572019WJ5000038', '21030572019WJ6000102', '21030572019WJ6000097', '21030572029WJ6000151',
 '21030572029WJ6000175', '21030572039WJ6000103', '21030572039WJ6000078', '21030572039WJ6000073', '21030572039WJ6000074',
 '21030572039WJ6000077', '21030572039WJ6000130', '21030572039WJ6000104', '21030572039WJ6000086', '21030572039WJ6000076',
 '21030572039WJ6000075', '210305720210J7000028', '210305720110J7000181', '210305720110J7000182', '210305720110J7000179',
 '210305720110J7000180', '210305720210J7000030', '210305720110J7000183', '210305720110HA000147', '210305793410J5000069',
 '210305793410J5000070', '210305771110J7000027', '210305793410J7000034', '210305793410J7000073', '210305771110J7000026',
 '210305793410J7000074', '210305793410J7000061', '210305793410J7000035', '210305793410J7000063', '210305793410J7000064',
 '210305771110J5000033', '210305793410J5000067', '210305793410J7000062', '210305720110J5000097', '210305720110J5000096',
 '210305720110J5000099', '210305720110J5000098', '210305720110J5000214', '210305720110J5000198', '210305720110J5000186',
 '210305720110J5000194', '210305720110J5000220', '210305720110J5000204', '210305720110J5000221', '210305720110J5000187',
 '210305720110J5000209', '210305720110J5000200', '210305720110J5000197', '210305720310J5000211', '210305720310J5000225',
 '210305720310J5000226', '210305720310J5000212', '210305720310J6000013', '210305720310J6000056', '210305720310J6000057',
 '210305720310J5000224', '210305720110J6000008', '210305720310J6000011', '210305720310J6000006', '210305720310J6000004',
 '210305720110J7000017', '210305720310J6000066', '210305720110J7000016', '210305720310J6000043', '210305720310J6000045',
 '210305720110J6000287', '210305720310J7000116', '210305720310J6000174', '210305720310J6000173', '210305720310J6000171',
 '210305720310J7000100', '210305720310J7000101', '210305720310J7000049', '210305720310J7000054', '210305720310J7000053',
 '210305720310J7000046', '210305720310J7000052', '210305720310J7000048', '210305720310J5000143', '210305720110J5000189',
 '210305720110J5000188', '210305720110J5000201', '210305720110J5000202', '210305720110J5000223', '210305720310J5000227',
 '210305720310J6000012', '210305720310J5000228', '210305720310J6000010', '210305720310J6000046', '210305720310J6000044',
 '210305720310J6000175', '210305720310J7000115', '210305720310J6000172', '210305720310J7000083', '210305720110J7000019',
 '210305720310J7000050', '210305720310J7000109', '210305720310J7000108', '210305720110J5000094', '210305720110J5000222',
 '210305720110J5000210', '210305720110J5000185', '210305720310J6000005', '210305720310J6000170', '210305720110J7000018',
 '210305720310J7000082', '210305720310J7000047', '210305720310J7000106', '210305720310J7000107', '210305720110J5000192',
 '210305720310J6000007', '210305720110J6000288', '210305720310J7000055', '210305720310J3000148', '210305720310J3000149',
 '210305720310J3000154', '210305720310J3000155', '210305720310J3000146', '210305720310J3000147', '210305720310J3000150',
 '210305720310J3000151', '210305720310J3000152', '210305720310J3000153', '210305720110J3000063', '210305720110J3000064',
 '210305720310J3000226', '210305720110J3000073', '210305720110J3000074', '210305720310J3000275', '210305720310J3000272',
 '210305720110J3000167', '210305720110J3000169', '210305720110J3000168', '210305720110J3000170', '210305720110J3000165',
 '210305720110J3000164', '210305720110J3000175', '210305720310J4000258', '210305720310J4000259', '210305720310J4000254',
 '210305720310J4000255', '210305720310J4000257', '210305720310J4000320', '210305720310J5000096', '210305720310J5000097',
 '210305720310J5000118', '210305720310J5000119', '210305720310J1000512', '210305720310HC000148', '210305720310HC000199',
 '210305720310HC000043', '210305720310HC000057', '210305720310HC000087', '210305720110HC000055', '210305720110HC000040',
 '210305720110HC000062', '210305720110HC000041', '210305720110HC000060', '210305720110HC000038', '210305720110HC000057',
 '210305720110HC000058', '210305720110HC000064', '210305720110HC000030', '210305720110HC000004', '210305720110HB000287',
 '210305720110HB000290', '210305720110HB000289', '210305720110HC000003', '210305720110H8000301', '210305720110H8000292',
 '210305720110H8000293', '210305720110H8000300', '210305720310J5000223', '21030572039WJ7000019', '21030572039WJ7000003',
 '21030572039WJ7000020', '21030572039WJ7000006', '21030572039WJ7000008', '21030572039WJ7000004', '21030572039WJ7000021',
 '210305720110HA000137', '210305776710J9000001', '210305720110J8000012', '210305771110J9000006', '210305720110J9000032',
 '210305720110J8000042', '210305720210J8000077', '210305720110J8000068', '210305720210J9000008', '210305720310J8000011',
 '210305720210J9000010', '210305771110J9000007', '210305720210J8000005', '210305720210J8000067', '210305771110J8000008',
 '210305720110J9000015', '210305720310J8000015', '210305720210J8000089', '210305720210J8000075', '210305720110J9000008',
 '210305720210J9000003', '210305720210J8000093', '210305720310J8000005', '210305771110J8000004', '210305720310J8000008',
 '210305720210J8000049', '210305720110J8000049', '210305720210J8000057', '210305720310J8000007', '210305720110J9000019',
 '210305720310J8000035', '210305720310J8000033', '210305720210J8000042', '210305720110J9000013', '210305720110J9000001',
 '210305720110J8000015', '210305720210J8000054', '210305720110J8000059', '210305720310J8000014', '210305720110J8000050',
 '210305720210J8000072', '210305771110J8000006', '210305720310J8000016', '210305720210J9000001', '210305720110J9000021',
 '210305720110J9000009', '210305720110J9000003', '210305776710J8000004', '210305720110J8000006', '210305720110J9000016',
 '210305793410J8000004', '210305720110J9000039', '210305720210J8000041', '210305771110J8000001', '210305720210J8000071',
 '210305720310J8000004', '210305720210J8000069', '210305720110J8000044', '210305720310J8000021', '210305720210J8000010',
 '210305720110J8000028', '210305720110J8000029', '210305793410J9000002', '210305771110J9000002', '210305793410J9000003',
 '210305720210J8000087', '210305720110J8000041', '210305720210J8000088', '210305720310J8000034', '210305720210J8000064',
 '210305720210J8000039', '210305720110J8000058', '210305720110J8000039', '210305720110J9000037', '210305720110J8000032',
 '210305720210J8000080', '210305720110J8000031', '210305720110J8000020', '210305793410J9000009', '210305793410J8000003',
 '210305793410J8000002', '210305720110J8000022', '210305720210J9000004', '210305776710J8000003', '210305720210J8000092',
 '210305720210J8000040', '210305793410J8000010', '210305720210J8000004', '210305776710J8000005', '210305720210J8000085',
 '210305793410J9000005', '210305720210J8000009', '210305720310J8000037', '210305720110J8000061', '210305720110J8000057',
 '210305720110J8000003', '210305793410J8000016', '210305771110J8000007', '210305793410J8000014', '210305720210J9000007',
 '210305720110J9000036', '210305720110J9000020', '210305771110J9000018', '210305720110J8000033', '210305771110J9000004',
 '210305720210J8000056', '210305720310J8000028', '210305720110J8000017', '210305720110J8000040', '210305720210J8000037',
 '210305771110J9000019', '210305771110J9000014', '210305720310J8000020', '210305720210J8000011', '210305720210J8000070',
 '210305720210J8000008', '210305720210J8000066', '210305793410J8000008', '210305720210J9000009', '210305720210J8000076',
 '210305720210J8000003', '210305720210J8000074', '210305771110J8000010', '210305720110J8000019', '210305720310J8000024',
 '210305720110J8000014', '210305720210J8000050', '210305720110J8000035', '210305720110J9000034', '210305720310J8000009',
 '210305720110J8000034', '210305720210J8000091', '210305720110J8000021', '210305720110J9000014', '210305720110J9000006',
 '210305720110J9000007', '210305720310J8000019', '210305720310J8000023', '210305720110J9000030', '210305720110J9000002',
 '210305720210J8000062', '210305720110J8000027', '210305720210J8000046', '210305793410J9000008', '210305720110J8000009',
 '210305776710J8000001', '210305720210J8000078', '210305720210J8000079', '210305720110J8000065', '210305720110J9000033',
 '210305720210J8000055', '210305720210J8000086', '210305720310J8000027', '210305720110J8000038', '210305720210J8000068',
 '210305720210J8000013', '210305720110J8000053', '210305720110J8000036', '210305720110J8000018', '210305720110J8000037',
 '210305720210J9000016', '210305720110J8000063', '210305720210J9000005', '210305720210J8000061', '210305720110J8000010',
 '210305771110J9000001', '210305793410J8000001', '210305720110J8000067', '210305720210J8000063', '210305720110J8000005',
 '210305720310J8000013', '210305720210J8000006', '210305720210J8000002', '210305720310J8000012', '210305793410J8000005',
 '210305720210J8000059', '210305771110J8000003', '210305720110J9000041', '210305776710J8000002', '210305793410J8000011',
 '210305720110J8000052', '210305720110J9000043', '210305771110J9000020', '210305720110J9000004', '210305720210J8000095',
 '210305720110J8000002', '210305720110J8000008', '210305720110J9000018', '210305720110J8000030', '210305720110J8000054',
 '210305720110J9000022', '210305720210J8000044', '210305776710J9000002', '210305720210J8000048', '210305720310J8000022',
 '210305720110J8000001', '210305720210J9000012', '210305793410J8000009', '210305720210J8000090', '210305720210J9000011',
 '210305720210J8000047', '210305771110J9000005', '210305720110J8000013', '210305720210J8000082', '210305720110J9000040',
 '210305720110J8000016', '210305793410J9000004', '210305720110J8000055', '210305720210J9000006', '210305720110J9000017',
 '210305793410J9000001', '210305720110J8000060', '210305720310J8000036', '210305771110J9000015', '210305720110J8000066',
 '210305771110J9000003', '210305720210J8000051', '210305720310J8000006', '210305720310J8000025', '210305720310J8000018',
 '210305720110J9000005', '210305720110J8000011', '210305793410J8000015', '210305771110J8000014', '210305720110J9000012',
 '210305771110J8000009', '210305720210J8000081', '210305720210J8000053', '210305720110J8000043', '210305720210J8000038',
 '210305776710J9000003', '210305771110J9000017', '210305720210J8000058', '210305720110J8000007', '210305720110J8000023',
 '210305720210J8000083', '210305720210J8000073', '210305720210J8000012', '210305720210J8000065', '210305720310J8000003',
 '210305793410J8000012', '210305720110J9000031', '210305720310J8000010', '210305720210J9000002', '210305720210J8000060',
 '210305720210J8000036', '210305720110J8000025', '210305720110J8000062', '210305720210J8000094', '210305771110J9000013',
 '210305771110J9000016', '210305720310J8000026', '210305793410J8000013', '210305720210J8000001', '210305720210J8000052',
 '210305720210J8000007', '210305771110J8000002', '210305720210J8000045', '210305720210J8000043', '210305720110J8000051',
 '210305720210J9000013', '210305720210J8000084', '210305720110J8000024', '210305720110J8000056', '210305771110J8000005',
 '210305720110J8000026', '210305720110J8000004', '210305720310J8000017', '210305720110J9000042', '210305720110J8000064',
 '210305793410J7000049', '210305793410J7000050', '210305793410J5000072', '210305793410J5000071', '210305771110J7000001',
 '210305771110J7000013', '210305771110J7000012', '210305793410J5000074', '210305771110J7000002', '210305771110J4000053',
 '210305771110J4000054', '210305771110J5000014', '210305771110J5000015', '210305771110J5000016', '210305720310J5000196',
 '21030572039WJ5000016', '21030572039WJ5000028', '21030572039WJ5000027', '210305720310J7000079', '210305720310J7000075',
 '210305720310J7000076', '210305720310J5000194', '21030572039WJ5000015', '21030572039WJ5000024', '210305720310J7000073',
 '210305720310J7000072', '210305720310J7000078', '210305720310J7000071', '210305720310J7000077', '210305720310J7000070',
 '21030572039WJ7000064', '210305720310J5000197', '210305720310J7000074', '21030572039WJ7000063', '210305720310J5000195',
 '210305720110J3000161', '210305720110J3000160', '210305720110J3000157', '210305720110J3000156', '210305720110J3000158',
 '210305720110J5000170', '210305771910HC000001', '210305771110J5000005', '210305771110J5000007', '210305771110J5000002',
 '210305771110J5000017']
# 运营商软件版本风险控制器SN
RISK_SN_BUSINESS_SOFTWARE = ['210305771110J6000011', '210305771110J6000010', '210305771110J6000006', '210305793410J6000181', '210305793410J7000044',
 '210305793410J7000077', '210305793410J6000021', '210305793410J5000086', '210305793410J5000083', '210305793410J6000022',
 '210305771110J6000009', '210305771110J6000007', '210305771110J6000001', '210305771110J6000132', '210305793410J7000078',
 '210305720110J5000148', '210305720310J5000130', '210305720310J5000198', '210305720310J5000202', '210305720310J5000199',
 '210305720210J5000039', '210305720310J5000214', '210305720110J5000280', '210305720210J6000105', '210305720210J6000108',
 '210305720210J6000109', '210305720310J5000229', '210305720210J6000115', '210305720310J6000112', '210305720110J6000005',
 '210305720310J5000232', '210305720110J6000003', '210305720110J6000265', '210305720310J5000231', '210305720110J6000239',
 '210305720310J6000038', '210305720310J6000040', '210305720310J6000037', '210305720110J6000310', '210305720110J6000313',
 '210305720210J6000118', '210305720110J6000309', '210305720210J6000117', '210305720110J7000035', '210305720310J7000033',
 '210305720110J6000316', '210305720110J6000311', '210305720110J6000315', '210305720110J6000312', '210305720210J7000005',
 '210305720210J7000001', '210305720110J7000006', '210305720210J7000003', '210305720110J7000013', '210305720110J7000008',
 '210305720110J7000015', '210305720110J7000224', '210305720110J7000226', '210305720210J7000026', '210305720110J7000235',
 '210305720110J7000236', '210305720210J5000013', '210305720110J5000133', '210305720210J6000114', '210305720210J6000106',
 '210305720310J5000233', '210305720210J6000112', '210305720110J5000320', '210305720110J5000323', '210305720310J5000230',
 '210305720110J6000141', '210305720210J6000119', '210305720110J6000314', '210305720110J7000007', '210305720110J7000227',
 '210305720110J7000223', '210305720110J7000234', '210305720110J7000238', '210305720310J7000112', '210305720210J6000113',
 '210305720110J6000226', '210305720110J6000240', '210305720110J6000317', '210305720110J7000036', '210305720110J6000339',
 '210305720110J6000327', '210305720110J7000225', '210305720110J7000237', '210305720110J6000338', '210305720210J7000027',
 '210305720210J5000014', '210305720210J7000006', '210305720110J2000082', '210305720110J3000052', '210305720210J4000004',
 '210305720110J3000178', '210305720310J3000140', '210305720110J3000106', '210305720110J3000107', '210305720110J3000108',
 '210305720110J3000109', '210305720110J3000110', '210305720210J4000003', '210305720310J5000029', '210305720210J5000008',
 '210305720310J4000294', '210305720310J4000297', '210305720310J4000296', '210305720310J4000295', '210305720110J4000188',
 '210305720110J4000189', '210305720210J5000034', '210305720210J5000009', '210305720210J5000004', '210305720210J5000006',
 '210305720210J3000009', '210305720110J3000077', '210305720310HC000226', '210305720110HC000192', '210305720110HB000352',
 '210305720210HB000009', '210305720210HB000010', '210305720110HB000286', '210305720110HB000351', '210305720110HB000285',
 '210305720110H9000152', '210305720110H9000005', '210305720110H9000004', '210305720110H9000006', '210305720110H9000007',
 '210305720110H9000003', '210305720210J6000107', '210305720110J7000165', '210305720110J7000167', '210305720110J7000168',
 '210305720110J7000169', '210305720110J7000174', '210305720310J7000099', '210305720110J7000209', '210305720110J7000187',
 '210305771110J5000025', '210305771110J5000001', '210305771110J5000010', '210305771110J7000003', '210305720310J5000200',
 '210305720310J5000213', '210305720110J6000004', '210305720210J6000110', '210305720110J6000029', '210305720210J7000009',
 '210305720210J7000007', '210305720210J7000013', '210305720210J7000011', '210305720110J7000228', '210305720210J7000010',
 '210305720110J7000240', '210305720210J7000032', '210305720210J7000033', '210305720110J7000241', '210305720210J7000031',
 '210305720110J7000239', '210305720110J7000242', '210305720210J5000040', '210305776710J7000001', '210305720310J6000039',
 '210305720210J7000004', '210305720210J7000002', '210305720210J7000008', '210305720110J7000229', '210305720110J7000221',
 '210305720110J7000222', '210305720110J7000219', '210305720110J7000218', '210305720110J7000014', '210305720110J7000220',
 '210305720210J6000111', '210305720210J7000012', '210305720110J2000077', '210305720210J2000005', '210305720110J2000127',
 '210305720310J3000141', '210305720110J3000051', '210305720310J3000196', '210305720110J3000050', '210305720310J4000293',
 '21030572029WJ7000060', '210305776710J7000011', '210305776710J7000015', '210305776710J7000002', '210305776710J7000007',
 '210305776710J7000008', '210305776710J7000016', '210305776710J7000003', '210305776710J7000005', '210305776710J7000004',
 '210305776710J7000014', '210305776710J7000017', '210305720310J7000036', '210305720310J7000037', '210305776710J7000012',
 '210305776710J7000009', '210305776710J7000010', '210305776710J7000006', '21030572029WJ7000059', '210305776710J7000013',
 '210305771110J5000043', '210305793410J7000058', '210305793410J7000056', '210305771110J5000046', '210305771110J5000047',
 '210305793410J7000068', '210305771110J5000042', '210305793410J7000055', '210305793410J7000067', '210305793410J7000057',
 '210305771110J5000024', '21030572029WJ5000050', '21030572029WJ5000045', '21030572029WJ5000043', '21030572029WJ5000031',
 '21030572029WJ5000049', '21030572029WJ5000024', '21030572029WJ5000046', '21030572019WJ6000088', '21030572019WJ6000101',
 '21030572019WJ6000087', '21030572019WJ6000092', '21030572019WJ6000089', '210305720310J6000087', '210305720310J6000081',
 '210305720310J6000076', '210305720310J6000075', '210305720310J6000091', '21030572029WJ6000121', '21030572029WJ6000126',
 '21030572019WJ6000320', '21030572029WJ6000120', '21030572029WJ6000205', '21030572019WJ6000324', '21030572029WJ6000214',
 '21030572029WJ6000209', '21030572029WJ6000184', '21030572029WJ6000181', '21030572029WJ6000215', '21030572029WJ6000123',
 '210305720110J7000185', '21030572019WJ6000250', '21030572019WJ6000249', '21030572019WJ6000392', '21030572019WJ6000328',
 '21030572019WJ6000318', '21030572019WJ6000300', '21030572019WJ6000299', '210305720110J7000172', '21030572019WJ6000327',
 '21030572019WJ6000329', '21030572019WJ6000319', '210305720310J7000089', '210305720110J7000124', '210305720310J7000009',
 '210305720110J7000126', '210305720110J7000125', '210305720110J7000128', '210305720310J7000011', '210305720310J7000006',
 '210305720110J7000204', '210305720110J7000171', '210305720110J7000177', '210305720110J7000175', '210305720110J7000178',
 '210305720110J7000200', '210305720110J7000176', '210305720110J7000112', '210305720110J7000196', '210305720110J7000195',
 '210305720110J7000214', '210305720110J7000106', '210305720110J7000114', '210305720310J7000103', '210305720110J7000115',
 '210305720110J7000108', '210305720110J7000122', '210305720110J7000213', '210305720110J7000203', '210305720110J7000156',
 '210305720310J7000104', '210305720110J7000217', '210305720110J7000116', '210305720110J7000117', '210305720110J7000111',
 '210305720110J7000121', '210305720110J7000118', '210305720110J7000162', '210305720310J7000096', '210305720310J7000091',
 '210305720110J7000212', '210305720310J7000095', '210305720310J7000098', '210305720110J7000170', '210305720110J7000216',
 '210305720110J7000109', '210305720110J7000075', '210305720110J7000087', '210305720110J7000072', '210305720110J7000084',
 '210305720110J7000080', '210305720310J7000094', '210305720110J7000076', '210305720110J7000088', '210305720110J7000093',
 '210305720110J7000159', '210305720110J7000089', '210305720110J7000091', '210305720110J7000092', '210305720110J7000166',
 '210305720110J7000155', '210305720110J7000078', '210305720310J7000097', '210305720110J7000199', '210305720110J7000210',
 '210305720110J7000201', '210305720110J7000074', '210305720110J7000086', '210305720110J7000083', '210305720110J7000260',
 '210305720110J7000261', '210305720110J7000258', '21030572029WJ5000072', '21030572019WJ5000069', '21030572029WJ5000023',
 '21030572029WJ5000044', '21030572029WJ6000168', '21030572019WJ6000090', '21030572029WJ6000140', '210305720310J6000084',
 '21030572029WJ6000208', '21030572029WJ6000199', '21030572019WJ6000321', '21030572029WJ6000183', '21030572029WJ6000185',
 '21030572029WJ6000201', '21030572029WJ6000198', '21030572019WJ6000325', '21030572029WJ6000203', '21030572029WJ6000122',
 '21030572029WJ6000204', '21030572019WJ6000330', '21030572019WJ6000301', '21030572019WJ6000302', '210305720110J7000127',
 '210305720310J7000007', '210305720110J7000123', '210305720110J7000194', '210305720310J7000105', '210305720110J7000107',
 '210305720110J7000198', '210305720310J7000102', '210305720310J7000088', '210305720110J7000186', '210305720110J7000205',
 '210305720110J7000079', '210305720110J7000160', '210305720110J7000157', '210305720110J7000071', '210305720110J7000163',
 '210305720110J7000077', '210305720110J7000188', '210305720110J7000081', '210305720110J7000264', '210305720110J7000259',
 '210305720110J7000257', '210305720110J7000263', '210305720110J7000262', '21030572029WJ5000032', '21030572029WJ6000176',
 '210305720310J6000086', '21030572029WJ6000127', '21030572029WJ6000186', '21030572029WJ6000202', '21030572029WJ6000200',
 '21030572019WJ6000391', '210305720310J7000008', '210305720110J7000119', '210305720110J7000105', '210305720110J7000197',
 '210305720110J7000113', '210305720110J7000206', '210305720110J7000082', '210305720110J7000161', '210305720110J7000073',
 '210305720110J7000164', '210305720110J7000090', '210305720110J7000085', '210305720310J6000074', '21030572029WJ6000182',
 '210305720110J7000173', '210305720110J7000120', '210305720110J7000202', '210305720110J7000211', '210305720110J7000110',
 '210305720110J7000158', '210305720110J7000094', '210305720310J6000072', '210305720310J6000089', '210305720110J7000207',
 '21030572019WJ5000039', '21030572019WJ5000040', '21030572019WJ5000037', '21030572019WJ5000072', '21030572019WJ5000074',
 '21030572019WJ5000080', '21030572019WJ5000082', '21030572019WJ5000070', '21030572019WJ5000071', '21030572019WJ5000094',
 '21030572029WHC000333', '21030572019WJ5000038', '21030572019WJ6000102', '21030572019WJ6000097', '21030572029WJ6000151',
 '21030572029WJ6000175', '21030572039WJ6000103', '21030572039WJ6000078', '21030572039WJ6000073', '21030572039WJ6000074',
 '21030572039WJ6000077', '21030572039WJ6000130', '21030572039WJ6000104', '21030572039WJ6000086', '21030572039WJ6000076',
 '21030572039WJ6000075', '210305720210J7000028', '210305720110J7000181', '210305720110J7000182', '210305720110J7000179',
 '210305720110J7000180', '210305720210J7000030', '210305720110J7000183', '210305720110HA000147', '21030572039WJ5000057',
 '21030572039WJ5000020', '21030572039WJ5000061', '21030572039WJ5000016', '21030572039WJ5000046', '21030572039WJ5000043',
 '21030572039WJ5000058', '21030572039WJ5000012', '21030572039WJ5000038', '21030572039WJ5000049', '21030572039WJ5000021',
 '21030572039WJ5000039', '21030572039WJ5000026', '21030572039WJ6000008', '21030572039WJ5000054', '21030572039WJ6000009',
 '21030572039WJ6000136', '21030572039WJ6000127', '21030572039WJ6000124', '21030572039WJ6000007', '21030572039WJ6000131',
 '21030572039WJ6000123', '21030572039WJ6000002', '21030572039WJ6000006', '21030572039WJ6000106', '21030572039WJ6000105',
 '21030572039WJ6000121', '21030572039WJ6000005', '21030572039WJ6000138', '21030572039WJ6000171', '21030572039WJ6000021',
 '21030572039WJ6000096', '21030572039WJ6000041', '21030572039WJ6000039', '21030572039WJ6000030', '21030572039WJ6000050',
 '21030572039WJ6000095', '21030572039WJ6000068', '21030572039WJ6000149', '21030572039WJ6000148', '21030572039WJ6000161',
 '21030572039WJ6000143', '21030572039WJ6000147', '21030572039WJ6000154', '21030572039WJ6000158', '21030572039WJ6000150',
 '21030572039WJ6000145', '21030572039WJ6000144', '21030572039WJ6000162', '21030572039WJ6000157', '21030572039WJ6000152',
 '21030572039WJ6000153', '21030572039WJ6000183', '21030572039WJ6000091', '21030572039WJ6000184', '21030572039WJ6000179',
 '21030572039WJ6000081', '21030572039WJ6000054', '21030572039WJ6000070', '21030572039WJ6000051', '21030572039WJ6000072',
 '21030572039WJ6000082', '21030572039WJ6000053', '21030572039WJ6000079', '21030572039WJ6000083', '21030572039WJ6000080',
 '21030572039WJ6000069', '21030572039WJ6000176', '21030572039WJ6000166', '21030572039WJ6000191', '21030572039WJ6000186',
 '21030572039WJ6000168', '21030572039WJ6000192', '21030572039WJ7000034', '21030572039WJ6000175', '21030572039WJ6000165',
 '21030572039WJ6000196', '21030572039WJ7000030', '21030572039WJ7000033', '21030572039WJ6000195', '21030572039WJ6000194',
 '21030572039WJ7000018', '21030572039WJ6000198', '21030572039WJ6000193', '21030572039WJ7000016', '21030572039WJ6000197',
 '21030572039WJ7000025', '21030572039WJ7000023', '21030572039WJ7000026', '21030572039WJ7000028', '21030572039WJ7000014',
 '21030572039WJ7000027', '21030572039WJ7000012', '21030572039WJ7000017', '21030572039WJ7000062', '21030572039WJ5000060',
 '21030572039WJ5000019', '21030572039WJ5000015', '21030572039WJ5000014', '21030572039WJ5000041', '21030572039WJ6000003',
 '21030572039WJ6000010', '21030572039WJ6000118', '21030572039WJ6000122', '21030572039WJ6000115', '21030572039WJ6000119',
 '21030572039WJ6000004', '21030572039WJ5000050', '21030572039WJ5000040', '21030572039WJ6000042', '21030572039WJ6000067',
 '21030572039WJ6000160', '21030572039WJ6000092', '21030572039WJ6000101', '21030572039WJ6000087', '21030572039WJ6000052',
 '21030572039WJ6000084', '21030572039WJ6000167', '21030572039WJ6000180', '21030572039WJ7000011', '21030572039WJ7000013',
 '21030572039WJ7000035', '21030572039WJ7000036', '21030572039WJ7000064', '21030572039WJ5000011', '21030572039WJ5000048',
 '21030572039WJ6000001', '21030572039WJ6000116', '21030572039WJ5000055', '21030572039WJ5000051', '21030572039WJ6000107',
 '21030572039WJ6000128', '21030572039WJ6000146', '21030572039WJ6000151', '21030572039WJ6000063', '21030572039WJ6000102',
 '21030572039WJ6000071', '21030572039WJ7000015', '21030572039WJ7000063', '21030572039WJ7000061', '21030572039WJ5000042',
 '21030572039WJ5000056', '21030572039WJ6000159', '21030572039WJ6000185', '21030572039WJ7000029', '21030572039WJ7000024',
 '21030572039WJ5000059', '210305720310J3000022', '210305720310J2000125', '210305720310J2000129', '210305720310J2000120',
 '210305720310J3000078', '210305720310J3000079', '210305720310J3000074', '210305720310J3000075', '210305720310J3000076',
 '210305720310J3000077', '210305720310J3000066', '210305720310J3000067', '210305720310J3000097', '210305720310J3000098',
 '210305720310J3000068', '210305720310J3000069', '210305720310J3000070', '210305720310J3000071', '210305720310J3000072',
 '210305720310J3000073', '210305720310J3000193', '210305720310J3000219', '210305720310J3000297', '210305720310J3000298',
 '210305720310J3000301', '210305720310J3000302', '210305720310J3000214', '210305720310J3000194', '210305720310J3000311',
 '210305720310J3000312', '210305720310J3000222', '210305720310J3000328', '210305720310J3000313', '210305720310J3000314',
 '210305720310J3000317', '210305720310J3000318', '210305720310J3000236', '210305720310J3000269', '210305720310J3000184',
 '210305720310J3000185', '210305720310J4000190', '210305720310J3000212', '210305720310J4000352', '210305720310J4000358',
 '210305720310J4000359', '210305720310J4000360', '210305720310J4000361', '210305720310J4000354', '210305720310J4000355',
 '210305720310J4000366', '210305720310J4000367', '210305720310J5000010', '210305720310J5000011', '210305720310J4000365',
 '210305720310J5000016', '210305720310J5000048', '210305720310J4000362', '210305720310J4000363', '210305720310J5000057',
 '210305720310J5000059', '210305720310J5000063', '210305720310J4000369', '210305720310J5000047', '210305720310J5000114',
 '210305720310J4000368', '210305720310J4000356', '210305720310J4000357', '210305720310J5000042', '210305720310J5000043',
 '210305720310J5000040', '210305720310J5000041', '210305720310J5000038', '210305720310J5000120', '210305720310J5000121',
 '210305720310J5000122', '210305720310J5000123', '210305720310J5000034', '210305720310J5000035', '210305720310J5000124',
 '210305720310J5000008', '210305720310J5000009', '210305720310J5000126', '210305720310J5000127', '210305720310J5000133',
 '210305720310J5000131', '210305720310J5000132', '210305720310J5000128', '210305720310J5000080', '210305720310J5000135',
 '210305720310J5000136', '210305720310J5000072', '210305720310J5000086', '210305720310J5000153', '210305720310J5000085',
 '210305720310J5000174', '210305720310J5000089', '210305720310J5000078', '210305720310J5000074', '210305720310J5000104',
 '210305720310J5000077', '210305720310J5000015', '210305720310J1000019', '210305720310J1000024', '210305720310J1000008',
 '210305720310HC000381', '210305720310HC000213', '210305720310HC000377', '210305720310HC000241', '210305720310HC000376',
 '210305720310HC000379', '210305720310HC000369', '210305720310HC000243', '210305720310HC000216', '210305720310HC000244',
 '210305720310HC000212', '210305720310HC000245', '210305720310HC000211', '210305720310HC000215', '210305720310HC000380',
 '210305720310HC000222', '210305720310HC000368', '210305720310HC000210', '210305720310HC000209', '210305720310HC000064',
 '210305720310HB000469', '210305720310J1000429', '210305720310HB000425', '210305720310HB000426', '210305720310HC000008',
 '210305720310HC000003', '210305720310HC000010', '210305720310HC000001', '210305720310H9000229', '210305720310H9000185',
 '210305720310H9000245', '210305720310H9000247', '210305720310H9000184', '210305720310H9000191', '210305720310H9000224',
 '210305720310H9000220', '210305720310H9000246', '21030572039WJ5000013', '21030572039WJ6000135', '21030572039WJ5000022',
 '21030572039WJ6000200', '21030572039WJ6000199', '21030572039WJ7000052', '210305771110J5000005', '210305771110J5000002',
 '210305771110J4000053', '210305771110J4000054', '210305776710J9000001', '210305720110J8000012', '210305771110J9000006',
 '210305720110J9000032', '210305720110J8000042', '210305720210J8000077', '210305720110J8000068', '210305720210J9000008',
 '210305720310J8000011', '210305720210J9000010', '210305771110J9000007', '210305720210J8000005', '210305720210J8000067',
 '210305771110J8000008', '210305720110J9000015', '210305720310J8000015', '210305720210J8000089', '210305720210J8000075',
 '210305720110J9000008', '210305720210J9000003', '210305720210J8000093', '210305720310J8000005', '210305771110J8000004',
 '210305720310J8000008', '210305720210J8000049', '210305720110J8000049', '210305720210J8000057', '210305720310J8000007',
 '210305720110J9000019', '210305720310J8000035', '210305720310J8000033', '210305720210J8000042', '210305720110J9000013',
 '210305720110J9000001', '210305720110J8000015', '210305720210J8000054', '210305720110J8000059', '210305720310J8000014',
 '210305720110J8000050', '210305720210J8000072', '210305771110J8000006', '210305720310J8000016', '210305720210J9000001',
 '210305720110J9000021', '210305720110J9000009', '210305720110J9000003', '210305776710J8000004', '210305720110J8000006',
 '210305720110J9000016', '210305793410J8000004', '210305720110J9000039', '210305720210J8000041', '210305771110J8000001',
 '210305720210J8000071', '210305720310J8000004', '210305720210J8000069', '210305720110J8000044', '210305720310J8000021',
 '210305720210J8000010', '210305720110J8000028', '210305720110J8000029', '210305793410J9000002', '210305771110J9000002',
 '210305793410J9000003', '210305720210J8000087', '210305720110J8000041', '210305720210J8000088', '210305720310J8000034',
 '210305720210J8000064', '210305720210J8000039', '210305720110J8000058', '210305720110J8000039', '210305720110J9000037',
 '210305720110J8000032', '210305720210J8000080', '210305720110J8000031', '210305720110J8000020', '210305793410J9000009',
 '210305793410J8000003', '210305793410J8000002', '210305720110J8000022', '210305720210J9000004', '210305776710J8000003',
 '210305720210J8000092', '210305720210J8000040', '210305793410J8000010', '210305720210J8000004', '210305776710J8000005',
 '210305720210J8000085', '210305793410J9000005', '210305720210J8000009', '210305720310J8000037', '210305720110J8000061',
 '210305720110J8000057', '210305720110J8000003', '210305793410J8000016', '210305771110J8000007', '210305793410J8000014',
 '210305720210J9000007', '210305720110J9000036', '210305720110J9000020', '210305771110J9000018', '210305720110J8000033',
 '210305771110J9000004', '210305720210J8000056', '210305720310J8000028', '210305720110J8000017', '210305720110J8000040',
 '210305720210J8000037', '210305771110J9000019', '210305771110J9000014', '210305720310J8000020', '210305720210J8000011',
 '210305720210J8000070', '210305720210J8000008', '210305720210J8000066', '210305793410J8000008', '210305720210J9000009',
 '210305720210J8000076', '210305720210J8000003', '210305720210J8000074', '210305771110J8000010', '210305720110J8000019',
 '210305720310J8000024', '210305720110J8000014', '210305720210J8000050', '210305720110J8000035', '210305720110J9000034',
 '210305720310J8000009', '210305720110J8000034', '210305720210J8000091', '210305720110J8000021', '210305720110J9000014',
 '210305720110J9000006', '210305720110J9000007', '210305720310J8000019', '210305720310J8000023', '210305720110J9000030',
 '210305720110J9000002', '210305720210J8000062', '210305720110J8000027', '210305720210J8000046', '210305793410J9000008',
 '210305720110J8000009', '210305776710J8000001', '210305720210J8000078', '210305720210J8000079', '210305720110J8000065',
 '210305720110J9000033', '210305720210J8000055', '210305720210J8000086', '210305720310J8000027', '210305720110J8000038',
 '210305720210J8000068', '210305720210J8000013', '210305720110J8000053', '210305720110J8000036', '210305720110J8000018',
 '210305720110J8000037', '210305720210J9000016', '210305720110J8000063', '210305720210J9000005', '210305720210J8000061',
 '210305720110J8000010', '210305771110J9000001', '210305793410J8000001', '210305720110J8000067', '210305720210J8000063',
 '210305720110J8000005', '210305720310J8000013', '210305720210J8000006', '210305720210J8000002', '210305720310J8000012',
 '210305793410J8000005', '210305720210J8000059', '210305771110J8000003', '210305720110J9000041', '210305776710J8000002',
 '210305793410J8000011', '210305720110J8000052', '210305720110J9000043', '210305771110J9000020', '210305720110J9000004',
 '210305720210J8000095', '210305720110J8000002', '210305720110J8000008', '210305720110J9000018', '210305720110J8000030',
 '210305720110J8000054', '210305720110J9000022', '210305720210J8000044', '210305776710J9000002', '210305720210J8000048',
 '210305720310J8000022', '210305720110J8000001', '210305720210J9000012', '210305793410J8000009', '210305720210J8000090',
 '210305720210J9000011', '210305720210J8000047', '210305771110J9000005', '210305720110J8000013', '210305720210J8000082',
 '210305720110J9000040', '210305720110J8000016', '210305793410J9000004', '210305720110J8000055', '210305720210J9000006',
 '210305720110J9000017', '210305793410J9000001', '210305720110J8000060', '210305720310J8000036', '210305771110J9000015',
 '210305720110J8000066', '210305771110J9000003', '210305720210J8000051', '210305720310J8000006', '210305720310J8000025',
 '210305720310J8000018', '210305720110J9000005', '210305720110J8000011', '210305793410J8000015', '210305771110J8000014',
 '210305720110J9000012', '210305771110J8000009', '210305720210J8000081', '210305720210J8000053', '210305720110J8000043',
 '210305720210J8000038', '210305776710J9000003', '210305771110J9000017', '210305720210J8000058', '210305720110J8000007',
 '210305720110J8000023', '210305720210J8000083', '210305720210J8000073', '210305720210J8000012', '210305720210J8000065',
 '210305720310J8000003', '210305793410J8000012', '210305720110J9000031', '210305720310J8000010', '210305720210J9000002',
 '210305720210J8000060', '210305720210J8000036', '210305720110J8000025', '210305720110J8000062', '210305720210J8000094',
 '210305771110J9000013', '210305771110J9000016', '210305720310J8000026', '210305793410J8000013', '210305720210J8000001',
 '210305720210J8000052', '210305720210J8000007', '210305771110J8000002', '210305720210J8000045', '210305720210J8000043',
 '210305720110J8000051', '210305720210J9000013', '210305720210J8000084', '210305720110J8000024', '210305720110J8000056',
 '210305771110J8000005', '210305720110J8000026', '210305720110J8000004', '210305720310J8000017', '210305720110J9000042',
 '210305720110J8000064', '210305720110HA000137', '210305793410J7000049', '210305793410J7000050', '210305793410J5000069',
 '210305793410J5000072', '210305793410J5000071', '210305793410J5000070', '210305771110J7000001', '210305771110J7000013',
 '210305771110J7000012', '210305793410J5000074', '210305771110J7000002', '210305793410J5000067', '210305771110J5000014',
 '210305771110J5000015', '210305771110J5000016', '210305720310J5000196', '21030572039WJ5000028', '21030572039WJ5000027',
 '210305720310J7000079', '210305720310J7000075', '210305720310J7000076', '210305720310J5000194', '21030572039WJ5000024',
 '210305720310J7000073', '210305720310J7000072', '210305720310J7000078', '210305720310J7000071', '210305720110J7000019',
 '210305720310J7000077', '210305720310J7000070', '210305720310J5000197', '210305720310J7000074', '210305720110J7000018',
 '210305720310J5000195', '210305720110J3000167', '210305720110J3000169', '210305720110J3000168', '210305720110J3000170',
 '210305720110J3000165', '210305720110J3000164', '210305720110J3000161', '210305720110J3000160', '210305720110J3000157',
 '210305720110J3000156', '210305720110J3000158', '210305720110J3000175', '210305720110J5000170', '210305771910HC000001',
 '210305771110J5000007', '210305771110J5000017']

RECT_NOTICE_SOTRAGE_IN_2019_SN_LIST = ["2102351WBN10J5000001",
"2102351PLR10J9000003",
"2102351PLR10J9000002",
"2102351PLQ10J9000003",
"2102351NBD10J3000007",
"2102351NBD10J2000006",
"2102351NBD10J2000005",
"2102351NBD10J2000004",
"2102351NBD10J2000003",
"2102351NBD10J1000001",
"2102351NBD10HB000006",
"2102351NBD10HB000005",
"2102351LWG10JC000026",
"2102351LWG10JC000025",
"2102351LWG10JC000024",
"2102351LWG10JC000023",
"2102351LWG10JC000013",
"2102351LWG10JC000012",
"2102351LWG10JB000026",
"2102351LWG10JB000025",
"2102351LWG10JA000005",
"2102351LWG10JA000004",
"2102351LWG10JA000003",
"2102351LWG10JA000002",
"2102351LVD10J8000003",
"2102351LVD10J5000004",
"2102351GSA10HA000002",
"2102351GSA10HA000001",
"2102351GSA10H9000008",
"2102350RMG10J9000001",
"2102350RMG10HC000014",
"2102350RMG10HA000001",
"2102350RMG10GB000006",
"2102350RMG10GB000005",
"2102350BVB10H2000088",
"2102351LWJ10JB000001",
"2102351LWH10JC000023",
"2102351LWH10JC000018",
"2102351LWH10JC000017",
"2102351LWH10JC000016",
"210235982610JB000005",
"210235982610J7000009",
"210235982610J7000007",
"210235982610J7000006",
"210235982610J7000005",
"210235982610J7000004",
"210235982610J7000003",
"210235982610J7000002",
"210235982610J5000013",
"210235982610J5000004",
"210235982610J4000012",
"210235982610J4000010",
"210235982610J4000009",
"210235982610J4000008",
"210235982610J4000007",
"210235982610J4000006",
"210235982610J3000011",
"210235982610J3000010",
"210235982610J3000009",
"210235982610J3000004",
"210235982610J3000003",
"210235982610J2000003",
"210235982610J1000017",
"210235982610J1000016",
"210235982610J1000015",
"210235982610J1000005",
"210235982610J1000004",
"210235982610J1000003",
"210235982610J1000002",
"210235982610HC000016",
"210235982610HC000014",
"210235982610HC000013",
"210235982610HC000012",
"210235982610HB000007",
"210235982610HB000006",
"210235982610HA000024",
"210235982610HA000022",
"210235982610HA000018",
"210235982610HA000015",
"210235982610HA000014",
"210235982610HA000011",
"210235982610HA000003",
"210235982610H9000018",
"210235982610H9000017",
"210235982610H9000014",
"210235982610H9000007",
"210235982610H9000006",
"210235982610H8000012",
"210235982610H8000011",
"210235982610H8000010",
"210235982610H8000009",
"210235982610H8000008",
"210235982610H8000007",
"210235982610H8000006",
"210235982610H8000005",
"210235982610H8000003",
"210235982610H7000016",
"210235982610H7000015",
"210235982610H7000013",
"210235982610H7000010",
"210235982610H7000009",
"210235982610H7000008",
"210235982610H7000006",
"210235982610H7000005",
"210235982610H7000004",
"210235982610H7000002",
"210235982610H6000002",
"210235982610H5000016",
"210235982610H5000013",
"210235982610H5000007",
"210235982610H5000006",
"210235982610H5000004",
"210235982610H5000003",
"210235982610H3000027",
"210235982610H3000020",
"210235982610H3000019",
"210235982610H3000014",
"210235982610H3000009",
"210235982610H2000002",
"210235982610H2000001",
"210235982610H1000026",
"210235982610H1000024",
"210235982610H1000022",
"210235982610H1000021",
"210235982610H1000019",
"210235982610H1000011",
"210235982610H1000004",
"210235982610H1000003",
"210235982610GC000026",
"210235982610GC000023",
"210235982610GB000040",
"210235982610GB000039",
"210235982610GB000029",
"210235982610GB000027",
"210235982610GB000024",
"210235982610GB000023",
"210235982610GB000012",
"210235982610GB000011",
"210235982610GB000009",
"210235982610GB000008",
"210235982610GA000043",
"210235982610GA000042",
"210235982610GA000040",
"210235982610GA000039",
"210235982610GA000038",
"210235982610GA000037",
"210235982610GA000036",
"210235982610GA000035",
"210235982610GA000023",
"210235982610GA000019",
"210235982610GA000004",
"210235982610G7000046",
"210235982610G7000044",
"210235982610G7000025",
"210235982610G7000005",
"210235982610G7000003",
"210235982610G7000002",
"210235982610G7000001",
"210235982610G6000022",
"210235982610G6000021",
"210235982610G5000009",
"210235982610G2000006",
"210235982610G2000002",
"210235982610G2000001",
"210235982610G1000020",
"210235982610G1000017",
"210235982610G1000016",
"210235982610G1000015",
"210235982610G1000014",
"210235982610G1000013",
"210235982610G1000008",
"210235982610G1000006",
"210235982610G1000005",
"210235982610FC000007",
"210235982610F8000007",
"210235982510J1000006",
"210235982510J1000005",
"210235982510J1000004",
"210235982510J1000003",
"210235982510HC000026",
"210235982510HB000001",
"210235982510HA000012",
"210235982510HA000011",
"210235982510H9000012",
"210235982510H9000011",
"210235982510H9000010",
"210235982510H8000022",
"210235982510H8000021",
"210235982510H8000020",
"210235982510H8000019",
"210235982510H8000018",
"210235982510H8000017",
"210235982510H8000016",
"210235982510H8000015",
"210235982510H8000014",
"210235982510H8000013",
"210235982510H8000007",
"210235982510H7000008",
"210235982510H7000007",
"210235982510H7000006",
"210235982510H7000002",
"210235982510H5000017",
"210235982510H5000016",
"210235982510H4000044",
"210235982510H4000043",
"210235982510H4000039",
"210235982510H4000032",
"210235982510H4000019",
"210235982510H4000018",
"210235982510H4000015",
"210235982510H4000014",
"210235982510H4000013",
"210235982510H4000011",
"210235982510H4000010",
"210235982510H4000009",
"210235982510H4000008",
"210235982510H3000034",
"210235982510H2000007",
"210235982510H2000005",
"210235982510H2000003",
"210235982510GC000029",
"210235982510GB000028",
"210235982510GB000027",
"210235982510GB000025",
"210235982510GB000024",
"210235982510G7000007",
"210235982510G6000015",
"210235982510G2000008",
"210235982510G2000007",
"210235982510G2000004",
"210235982510G2000003",
"210235982510G2000002",
"210235982510G2000001",
"210235982510F6000028",
"2102351FEB10J4000008",
"2102351FEB10J4000007",
"2102351FEB10J4000006",
"2102351FEB10J4000005",
"2102351FEB10J4000004",
"2102351FEB10J4000003",
"2102351FEB10J4000002",
"2102351FEB10J4000001",
"2102350YEM10J1000002",
"2102350YEM10J1000001",
"2102350YEM10H7000001",
"2102350YEL10J1000001",
"2102350YEJ10J7000003",
"2102350YEJ10J7000001",
"2102350YEJ10J5000006",
"2102350YEJ10J5000005",
"2102350YEJ10J5000004",
"2102350YEJ10J5000003",
"2102350YEJ10J5000002",
"2102350YEJ10J5000001",
"2102350YEJ10HA000001",
"2102350XCS10J3000005",
"2102350XCS10H6000001",
"2102350XCS10H4000011",
"2102350XCS10H4000009",
"2102350XCS10H3000005",
"2102350XCS10H2000001",
"2102350UHP10H9000001",
"2102350UHJ10J7000003",
"2102350UHJ10J7000002",
"2102350UHJ10J7000001",
"2102350UHJ10H3000002",
"2102350UHJ10GB000011",
"2102350GFF10J6000002",
"2102350GFF10J6000001",
"2102350GFF10J4000005",
"2102350GFF10J4000004",
"2102350GFF10J4000003",
"2102350GFF10J4000002",
"2102350GFF10J4000001",
"2102350GFF10J3000004",
"2102350GFF10J3000002",
"2102350GFF10J3000001",
"2102350GFF10J2000003",
"2102350GFF10HA000009",
"2102350GFF10HA000003",
"2102350GFF10HA000002",
"2102350GFF10HA000001",
"2102350GFF10H9000004",
"2102350GFF10H9000003",
"2102350GFF10H9000002",
"2102350GFF10H9000001",
"2102350GFF10H8000003",
"2102350GFF10H8000002",
"2102350GFF10H8000001",
"2102350GFF10H7000002",
"2102350GFF10H7000001",
"2102350GFF10H6000004",
"2102350GFF10H5000002",
"2102350GFF10H4000003",
"2102350GFF10H4000001",
"2102350GFF10G9000014",
"2102350GFF10G9000009",
"2102350GFF10G9000008",
"2102350GFF10G9000007",
"2102350GFF10G9000006",
"2102350GFF10G9000005",
"2102350GFF10G9000004",
"2102350GFF10G9000003",
"2102350GFF10G8000003",
"2102350GFF10G7000001",
"2102350GFF10G6000008",
"2102350GFF10G6000007",
"2102350GFF10G6000006",
"2102350GFF10G6000005",
"2102350GFF10G4000002",
"2102350GFF10FC000003",
"2102350FJQ10G2000010",
"2102350FJH10GB000012",
"2102350FJG10GC000020",
"2102350FJG10GC000013",
"2102350FJG10G7000010",
"2102350FJG10G7000009",
"2102350FJF10H8000008",
"2102350FJF10H8000007",
"2102350FJF10G6000003",
"2102350FJF10FC000010",
"2102350FHK10H1000001",
"2102350FHK10G9000009",
"2102350FHK10G9000007",
"2102350FHK10G7000011",
"2102350FHK10G2000007",
"2102350FHK10G2000006",
"2102350FHK10G2000005",
"2102350DHW10H1000052",
"2102350BSA10J7000005",
"2102350BSA10J7000004",
"2102350BSA10J7000003",
"2102350BSA10J7000002",
"2102350BSA10J7000001",
"2102350BSA10J4000004",
"2102350BSA10J4000003",
"2102350BSA10J4000002",
"2102350BSA10J4000001",
"2102350BSA10J3000004",
"2102350BSA10J3000003",
"2102350BSA10HA000013",
"2102350BSA10HA000012",
"2102350BSA10HA000004",
"2102350BSA10HA000003",
"2102350BSA10HA000002",
"2102350BSA10HA000001",
"2102350BSA10H7000006",
"2102350BSA10H7000005",
"2102350BSA10H4000001",
"2102350BSA10G7000001",
"2102350BSA10G5000009",
"2102350BSA10G4000003",
"2102350BRY10JA000010",
"2102350BRY10J7000013",
"2102350BRY10J7000012",
"2102350BRY10J7000011",
"2102350BRY10J7000010",
"2102350BRY10J7000009",
"2102350BRY10J7000006",
"2102350BRY10J7000005",
"2102350BRY10J7000004",
"2102350BRY10J7000003",
"2102350BRY10J7000002",
"2102350BRY10J7000001",
"2102350BRY10J6000014",
"2102350BRY10J4000003",
"2102350BRY10J3000007",
"2102350BRY10J3000003",
"2102350BRY10J3000002",
"2102350BRY10J3000001",
"2102350BRY10J2000002",
"2102350BRY10J2000001",
"2102350BRY10J1000021",
"2102350BRY10J1000007",
"2102350BRY10J1000006",
"2102350BRY10J1000004",
"2102350BRY10HC000008",
"2102350BRY10HC000007",
"2102350BRY10HA000019",
"2102350BRY10HA000009",
"2102350BRY10HA000008",
"2102350BRY10HA000007",
"2102350BRY10HA000006",
"2102350BRY10HA000005",
"2102350BRY10HA000004",
"2102350BRY10HA000003",
"2102350BRY10HA000002",
"2102350BRY10H9000033",
"2102350BRY10H9000028",
"2102350BRY10H9000027",
"2102350BRY10H9000026",
"2102350BRY10H9000025",
"2102350BRY10H9000024",
"2102350BRY10H9000023",
"2102350BRY10H9000022",
"2102350BRY10H9000021",
"2102350BRY10H9000020",
"2102350BRY10H9000019",
"2102350BRY10H9000018",
"2102350BRY10H9000017",
"2102350BRY10H9000016",
"2102350BRY10H9000015",
"2102350BRY10H9000014",
"2102350BRY10H9000013",
"2102350BRY10H9000012",
"2102350BRY10H9000010",
"2102350BRY10H9000009",
"2102350BRY10H9000008",
"2102350BRY10H9000007",
"2102350BRY10H9000006",
"2102350BRY10H9000005",
"2102350BRY10H9000002",
"2102350BRY10H9000001",
"2102350BRY10H8000008",
"2102350BRY10H8000007",
"2102350BRY10H8000006",
"2102350BRY10H8000004",
"2102350BRY10H8000001",
"2102350BRY10H7000011",
"2102350BRY10H7000010",
"2102350BRY10H7000009",
"2102350BRY10H7000008",
"2102350BRY10H7000003",
"2102350BRY10H6000018",
"2102350BRY10H6000017",
"2102350BRY10H6000016",
"2102350BRY10H6000014",
"2102350BRY10H6000009",
"2102350BRY10H6000008",
"2102350BRY10H5000008",
"2102350BRY10H4000009",
"2102350BRY10H4000007",
"2102350BRY10H4000006",
"2102350BRY10H4000004",
"2102350BRY10H4000003",
"2102350BRY10H4000001",
"2102350BRY10H3000006",
"2102350BRY10H3000005",
"2102350BRY10H3000004",
"2102350BRY10H3000003",
"2102350BRY10H3000002",
"2102350BRY10H2000001",
"2102350BRY10H1000007",
"2102350BRY10H1000006",
"2102350BRY10H1000005",
"2102350BRY10H1000001",
"2102350BRY10GC000025",
"2102350BRY10GC000020",
"2102350BRY10GC000018",
"2102350BRY10GC000017",
"2102350BRY10GC000015",
"2102350BRY10GC000002",
"2102350BRY10GC000001",
"2102350BRY10GB000008",
"2102350BRY10GB000005",
"2102350BRY10GA000017",
"2102350BRY10GA000016",
"2102350BRY10GA000014",
"2102350BRY10GA000001",
"2102350BRY10G8000021",
"2102350BRY10G8000020",
"2102350BRY10G8000019",
"2102350BRY10G8000010",
"2102350BRY10G7000016",
"2102350BRY10G6000010",
"2102350BRY10G6000009",
"2102350BRY10G6000008",
"2102350BRY10G6000005",
"2102350BRY10G5000007",
"2102350BRY10G5000002",
"2102350BRY10G5000001",
"2102350BRY10G4000018",
"2102350BRY10G4000014",
"2102350BRY10G4000013",
"2102350BRY10G4000011",
"2102350BRY10G4000006",
"2102350BRY10G4000003",
"2102350BRY10G4000002",
"2102350BRY10G4000001",
"2102350BRY10G3000011",
"2102350BRY10G3000010",
"2102350BRY10G3000009",
"2102350BRY10G2000016",
"2102350BRY10G2000008",
"2102350BRY10G1000014",
"2102350BRY10G1000013",
"2102350BRY10G1000012",
"2102350BRY10G1000011",
"2102350BRY10G1000010",
"2102350BRY10G1000008",
"2102350BRY10FC000020",
"2102350BRY10FC000019",
"2102350BRY10FC000005",
"2102350BRY10F9000002",
"2102350BRY10F4000002",
"2102351XQC10J6000010",
"2102351XQC10J6000009",
"2102351XQC10J6000008",
"2102351XQC10J6000007",
"2102351XQC10J6000006",
"2102351XQC10J6000005",
"2102351XQC10J6000004",
"2102351XQC10J6000003",
"2102351XQC10J6000002",
"2102351XQC10J6000001",
"2102351PLX10JA000002",
"2102351PLX10JA000001",
"2102351PLU10JB000002",
"2102351PLU10JB000001",
"2102351PLS4YJ9900001",
"2102351PLS10JC000027",
"2102351PLS10JC000026",
"2102351PLS10JC000025",
"2102351PLS10JB000012",
"2102351PLS10JB000011",
"2102351PLS10JA000005",
"2102351PLS10JA000004",
"2102351PLS10JA000003",
"2102351PLS10JA000002",
"2102351PLS10J9000022",
"2102351PLS10J9000019",
"2102351PLS10J9000018",
"2102351PLS10J9000002",
"2102351PLS10J9000001",
"2102351PLS10J8000006",
"2102351PLS10J8000003",
"2102351PLS10J8000002",
"2102351PLS10J8000001",
"2102351PLS10J6000005",
"2102351PLR10J7000003",
"2102351PLQ9WJ9800007",
"2102351PLQ9WJ9800006",
"2102351PLQ9WJ9800005",
"2102351PLQ9WJ9800002",
"2102351PLQ9WJ9800001",
"2102351PLQ10JC000061",
"2102351PLQ10JC000059",
"2102351PLQ10JC000058",
"2102351PLQ10JC000056",
"2102351PLQ10JC000055",
"2102351PLQ10JC000054",
"2102351PLQ10JC000039",
"2102351PLQ10JC000037",
"2102351PLQ10JC000036",
"2102351PLQ10JC000035",
"2102351PLQ10JC000002",
"2102351PLQ10JB000011",
"2102351PLQ10JB000010",
"2102351PLQ10JB000004",
"2102351PLQ10JA000017",
"2102351PLQ10JA000016",
"2102351PLQ10JA000012",
"2102351PLQ10JA000009",
"2102351PLQ10JA000008",
"2102351PLQ10JA000007",
"2102351PLQ10JA000006",
"2102351PLQ10JA000001",
"2102351PLQ10J9000016",
"2102351PLQ10J9000015",
"2102351PLQ10J9000010",
"2102351PLQ10J8000012",
"2102351PLQ10J8000011",
"2102351PLQ10J8000007",
"2102351PLQ10J8000006",
"2102351PLQ10J8000004",
"2102351PLQ10J7000015",
"2102351PLQ10J7000006",
"2102351PLQ10J7000005",
"2102351PLQ10J6000001",
"2102351PLQ10J5000001",
"2102351PLP10JB000001",
"2102351PDW10J8000001",
"2102351NYK10J9000002",
"2102351NYK10J9000001",
"2102351NYH10JC000020",
"2102351NYH10JC000019",
"2102351NYH10JC000018",
"2102351NYH10JC000017",
"2102351NYH10JC000016",
"2102351NYH10JC000015",
"2102351NYH10JC000014",
"2102351NYH10JC000013",
"2102351NYH10J9000017",
"2102351NYH10J9000016",
"2102351NYH10J6000004",
"2102351NBD10J9000001",
"2102351NBD10J6000001",
"2102351NBD10J4000014",
"2102351NBD10J4000013",
"2102351NBD10J4000010",
"2102351NBD10J4000009",
"2102351NBD10J3000012",
"2102351NBD10J3000011",
"2102351NBD10J3000010",
"2102351NBD10J3000009",
"2102351NBD10J1000003",
"2102351NBD10J1000002",
"2102351LWG4YJA900014",
"2102351LWG4YJA900013",
"2102351LWG4YJA900009",
"2102351LWG4YJA900006",
"2102351LWG4YJA900005",
"2102351LWG10JC000009",
"2102351LWG10JC000008",
"2102351LWG10JC000003",
"2102351LWG10JC000002",
"2102351LWG10JC000001",
"2102351LWG10JB000024",
"2102351LWG10JB000014",
"2102351LWG10JB000011",
"2102351LWG10JB000010",
"2102351LWG10JB000009",
"2102351LWG10JB000008",
"2102351LWG10JB000007",
"2102351LWG10JB000006",
"2102351LWG10JB000005",
"2102351LWG10JB000004",
"2102351LWG10JB000003",
"2102351LWG10JB000002",
"2102351LWG10JB000001",
"2102351LWG10J9000032",
"2102351LWG10J9000022",
"2102351LWG10J9000021",
"2102351LWG10J9000020",
"2102351LWG10J9000017",
"2102351LWG10J9000016",
"2102351LWG10J9000007",
"2102351LWG10J8000021",
"2102351LWG10J8000020",
"2102351LWG10J8000017",
"2102351LWG10J8000016",
"2102351LWG10J8000015",
"2102351LWG10J8000014",
"2102351LWG10J8000013",
"2102351LWG10J8000012",
"2102351LWG10J8000011",
"2102351LWG10J8000010",
"2102351LWG10J8000009",
"2102351LWG10J8000008",
"2102351LWG10J8000007",
"2102351LWG10J8000006",
"2102351LWG10J7000005",
"2102351LWG10J5000005",
"2102351LWG10J5000004",
"2102351LWG10J1000003",
"2102351LWG10J1000002",
"2102351LVDTUJC900003",
"2102351LVDTUJC900001",
"2102351LVD4YJB900034",
"2102351LVD4YJB900029",
"2102351LVD4YJB900027",
"2102351LVD4YJB900019",
"2102351LVD4YJA900012",
"2102351LVD4YJA900010",
"2102351LVD4YJA900007",
"2102351LVD4YJA900005",
"2102351LVD4YJA900003",
"2102351LVD4YJA900001",
"2102351LVD4YJ9900020",
"2102351LVD4YJ9900018",
"2102351LVD4YJ9900012",
"2102351LVD4YJ9900010",
"2102351LVD4YJ9900008",
"2102351LVD4YJ9900006",
"2102351LVD4YJ8900008",
"2102351LVD4YJ8900005",
"2102351LVD4YJ8900004",
"2102351LVD10JC000041",
"2102351LVD10JC000034",
"2102351LVD10JC000033",
"2102351LVD10JC000031",
"2102351LVD10JC000030",
"2102351LVD10JC000029",
"2102351LVD10JC000028",
"2102351LVD10JC000027",
"2102351LVD10JC000026",
"2102351LVD10JC000025",
"2102351LVD10JC000022",
"2102351LVD10JC000014",
"2102351LVD10JC000013",
"2102351LVD10JB000021",
"2102351LVD10JB000020",
"2102351LVD10JB000019",
"2102351LVD10JB000018",
"2102351LVD10JA000001",
"2102351LVD10J9000031",
"2102351LVD10J9000027",
"2102351LVD10J9000026",
"2102351LVD10J9000025",
"2102351LVD10J9000001",
"2102351LVD10J8000018",
"2102351LVD10J8000006",
"2102351LVD10J8000002",
"2102351LVD10J7000001",
"2102351LVD10J5000003",
"2102351LVD10J5000002",
"2102351JLP10J8000001",
"2102351JLN10J3000002",
"2102351JLN10J3000001",
"2102351GSA10J7000003",
"2102351GSA10J7000002",
"2102351GSA10J1000002",
"2102351GSA10HB000006",
"2102351CMATUJC900032",
"2102351CMATUJC900029",
"2102351CMATUJC900025",
"2102351CMA4YJC900005",
"2102351CMA4YJC900003",
"2102351CMA4YJC900001",
"2102351CMA4YJB900031",
"2102351CMA4YJB900028",
"2102351CMA4YJB900018",
"2102351CMA4YJB900011",
"2102351CMA4YJB900010",
"2102351CMA4YJB900005",
"2102351CMA4YJB900002",
"2102351CMA4YJB900001",
"2102351CMA4YJ9900012",
"2102351CMA4YJ9900006",
"2102351CMA10JC000039",
"2102351CMA10JC000038",
"2102351CMA10JC000037",
"2102351CMA10JC000036",
"2102351CMA10J3000027",
"2102351CMA10HB000004",
"2102351CMA10HB000003",
"2102351CMA10HA000001",
"2102350RSM10J5000006",
"2102350RSM10J5000005",
"2102350RSM10HC000002",
"2102350RSM10HC000001",
"2102350RSL10JC000002",
"2102350RSL10J9000001",
"2102350RSL10J7000002",
"2102350RSL10J7000001",
"2102350RSL10J4000012",
"2102350RSL10J2000007",
"2102350RSL10J1000001",
"2102350RMG10J8000001",
"2102350RMG10J7000004",
"2102350RMG10J7000003",
"2102350RMG10J7000002",
"2102350RMG10J7000001",
"2102350RMG10J3000002",
"2102350RMG10J2000002",
"2102350RMG10J2000001",
"2102350RMG10J1000027",
"2102350RMG10J1000026",
"2102350RMG10J1000025",
"2102350RMG10J1000020",
"2102350RMG10J1000004",
"2102350RMG10J1000003",
"2102350RMG10J1000002",
"2102350RMG10J1000001",
"2102350RMG10HC000046",
"2102350RMG10HC000045",
"2102350RMG10HC000025",
"2102350RMG10HC000024",
"2102350RMG10HC000023",
"2102350RMG10HC000022",
"2102350RMG10HC000013",
"2102350RMG10HC000010",
"2102350RMG10HC000009",
"2102350RMG10HC000008",
"2102350RMG10HC000007",
"2102350RMG10HC000001",
"2102350RMG10HB000040",
"2102350RMG10HB000039",
"2102350RMG10HB000038",
"2102350RMG10HB000037",
"2102350RMG10HB000036",
"2102350RMG10HB000035",
"2102350RMG10HB000033",
"2102350RMG10HB000030",
"2102350RMG10HB000029",
"2102350RMG10HB000012",
"2102350RMG10HB000011",
"2102350RMG10HB000010",
"2102350RMG10HB000009",
"2102350RMG10HB000004",
"2102350RMG10HB000003",
"2102350RMG10HB000002",
"2102350RMG10HA000043",
"2102350RMG10HA000040",
"2102350RMG10HA000039",
"2102350RMG10HA000038",
"2102350RMG10HA000037",
"2102350RMG10HA000036",
"2102350RMG10HA000003",
"2102350RMG10H9000015",
"2102350RMG10H9000012",
"2102350RMG10H9000010",
"2102350RMG10H9000007",
"2102350RMG10H9000005",
"2102350RMG10H9000003",
"2102350RMG10H9000002",
"2102350RMG10H8000039",
"2102350RMG10H8000038",
"2102350RMG10H8000035",
"2102350RMG10H8000034",
"2102350RMG10H8000033",
"2102350RMG10H8000032",
"2102350RMG10H8000031",
"2102350RMG10H8000030",
"2102350RMG10H8000029",
"2102350RMG10H8000028",
"2102350RMG10H8000027",
"2102350RMG10H8000026",
"2102350RMG10H8000025",
"2102350RMG10H8000024",
"2102350RMG10H8000023",
"2102350RMG10H8000022",
"2102350RMG10H8000021",
"2102350RMG10H8000020",
"2102350RMG10H8000019",
"2102350RMG10H8000015",
"2102350RMG10H8000014",
"2102350RMG10H8000013",
"2102350RMG10H8000012",
"2102350RMG10H8000011",
"2102350RMG10H8000010",
"2102350RMG10H8000008",
"2102350RMG10H8000007",
"2102350RMG10H8000006",
"2102350RMG10H8000005",
"2102350RMG10H8000004",
"2102350RMG10H8000002",
"2102350RMG10H8000001",
"2102350RMG10H7000036",
"2102350RMG10H7000027",
"2102350RMG10H7000026",
"2102350RMG10H7000020",
"2102350RMG10H7000019",
"2102350RMG10H7000018",
"2102350RMG10H7000017",
"2102350RMG10H7000016",
"2102350RMG10H7000015",
"2102350RMG10H7000014",
"2102350RMG10H7000012",
"2102350RMG10H7000011",
"2102350RMG10H7000009",
"2102350RMG10H7000007",
"2102350RMG10H6000031",
"2102350RMG10H6000030",
"2102350RMG10H6000029",
"2102350RMG10H6000028",
"2102350RMG10H6000027",
"2102350RMG10H6000024",
"2102350RMG10H6000023",
"2102350RMG10H6000022",
"2102350RMG10H6000020",
"2102350RMG10H6000019",
"2102350RMG10H6000018",
"2102350RMG10H6000016",
"2102350RMG10H6000015",
"2102350RMG10H6000014",
"2102350RMG10H6000012",
"2102350RMG10H6000011",
"2102350RMG10H6000008",
"2102350RMG10H6000003",
"2102350RMG10H6000002",
"2102350RMG10H6000001",
"2102350RMG10H5000038",
"2102350RMG10H5000035",
"2102350RMG10H5000034",
"2102350RMG10H5000025",
"2102350RMG10H5000024",
"2102350RMG10H5000015",
"2102350RMG10H5000003",
"2102350RMG10H4000026",
"2102350RMG10H4000023",
"2102350RMG10H4000022",
"2102350RMG10H4000004",
"2102350RMG10H4000002",
"2102350RMG10H4000001",
"2102350RMG10H2000036",
"2102350RMG10H2000034",
"2102350RMF10J2000007",
"2102350RMF10J2000006",
"2102351VMR9WJB800005",
"2102351VMR9WJB800004",
"2102351VMR9WJB800003",
"2102351VMR9WJB800002",
"2102351VMR9WJB800001",
"2102351VMR9WJ9800002",
"2102351VMR9WJ9800001",
"2102351QHD10JB000001",
"2102351QCH10J7000004",
"2102351QCH10J7000003",
"2102351QCH10J7000002",
"2102351QCH10J7000001",
"2102351NPT10J8000007",
"2102351NPT10J8000006",
"2102351NLK9WJA800007",
"2102351NLK9WJA800006",
"2102351NLK9WJA800005",
"2102351NLK9WJA800004",
"2102351NLK10J4000016",
"2102351NLK10J4000015",
"2102351NLK10J4000014",
"2102351NLK10J4000013",
"2102351LWK9WJC800032",
"2102351LWK9WJC800031",
"2102351LWK9WJC800030",
"2102351LWK9WJC800029",
"2102351LWK9WJB800012",
"2102351LWK9WJB800011",
"2102351LWK9WJB800010",
"2102351LWK9WJB800008",
"2102351LWK9WJB800007",
"2102351LWK9WJB800006",
"2102351LWK9WJB800004",
"2102351LWK9WJ9800014",
"2102351LWK9WJ9800013",
"2102351LWK9WJ9800012",
"2102351LWK9WJ9800011",
"2102351LWK9WJ9800010",
"2102351LWK9WJ9800009",
"2102351LWK9WJ9800008",
"2102351LWK9WJ9800007",
"2102351LWK9WJ9800006",
"2102351LWK10J8000019",
"2102351LWK10J8000018",
"2102351LWK10J8000017",
"2102351LWK10J8000016",
"2102351LWH10J6000002",
"2102351LWH10J6000001",
"210235982610J5000007",
"210235982610J5000002",
"210235982610J5000001",
"210235982610J4000011",
"210235982610J1000020",
"210235982610J1000019",
"210235982610H9000016",
"210235982610H9000013",
"210235982610H9000012",
"210235982610H8000018",
"210235982610H8000017",
"210235982610H8000002",
"210235982610H8000001",
"210235982610H7000014",
"210235982610H7000007",
"210235982610H7000001",
"210235982610H6000005",
"210235982610H6000001",
"210235982610H4000006",
"210235982610H4000003",
"210235982610H3000028",
"210235982610H3000017",
"210235982610H3000016",
"210235982610H3000015",
"210235982610H3000008",
"210235982610H2000013",
"210235982610H2000011",
"210235982610H2000010",
"210235982610H2000005",
"210235982610H1000034",
"210235982610H1000033",
"210235982610H1000032",
"210235982610H1000031",
"210235982610H1000030",
"210235982610H1000029",
"210235982610H1000005",
"210235982610H1000001",
"210235982610GC000031",
"210235982610GC000025",
"210235982610GC000024",
"210235982610GC000022",
"210235982610GC000021",
"210235982610GC000020",
"210235982610GC000017",
"210235982610GC000012",
"210235982610GC000011",
"210235982610GC000010",
"210235982610GC000009",
"210235982610GB000038",
"210235982610GB000035",
"210235982610GB000034",
"210235982610GB000016",
"210235982610GB000013",
"210235982610GB000010",
"210235982610GA000050",
"210235982610GA000048",
"210235982610GA000030",
"210235982610GA000029",
"210235982610GA000017",
"210235982610GA000016",
"210235982610GA000010",
"210235982610GA000009",
"210235982610GA000008",
"210235982610GA000007",
"210235982610G9000014",
"210235982610G9000003",
"210235982610G9000002",
"210235982610G8000020",
"210235982610G8000019",
"210235982610G8000017",
"210235982610G8000014",
"210235982610G8000013",
"210235982610G8000009",
"210235982610G8000008",
"210235982610G8000006",
"210235982610G8000005",
"210235982610G7000045",
"210235982610G7000043",
"210235982610G7000041",
"210235982610G7000039",
"210235982610G7000038",
"210235982610G7000036",
"210235982610G7000034",
"210235982610G7000033",
"210235982610G7000032",
"210235982610G7000031",
"210235982610G7000027",
"210235982610G7000026",
"210235982610G7000024",
"210235982610G7000023",
"210235982610G7000022",
"210235982610G7000021",
"210235982610G7000020",
"210235982610G7000019",
"210235982610G7000018",
"210235982610G7000017",
"210235982610G7000016",
"210235982610G7000015",
"210235982610G7000014",
"210235982610G7000013",
"210235982610G7000008",
"210235982610G7000006",
"210235982610G6000026",
"210235982610G6000011",
"210235982610G6000010",
"210235982610G6000007",
"210235982610G5000017",
"210235982610G5000016",
"210235982610G5000014",
"210235982610G5000013",
"210235982610G4000016",
"210235982610G4000015",
"210235982610G4000014",
"210235982610G4000012",
"210235982610G4000003",
"210235982610G3000013",
"210235982610G3000004",
"210235982610G3000003",
"210235982610G2000003",
"210235982610FB000007",
"210235982610FB000006",
"210235982610FB000001",
"210235982610F7000006",
"210235982510H4000029",
"210235982510H4000028",
"210235982510H4000005",
"210235982510H4000004",
"210235982510H2000004",
"210235982510G8000010",
"210235982510G8000009",
"210235982510G5000002",
"210235982510G5000001",
"210235982510G3000020",
"210235982510G3000019",
"210235982510G3000012",
"210235982510G3000011",
"210235982510G3000010",
"210235982510G3000009",
"210235982510G2000006",
"210235982510G2000005",
"210235982510G1000031",
"210235982510G1000013",
"210235982510G1000012",
"210235982510G1000011",
"210235982510G1000010",
"210235982510G1000009",
"210235982510G1000008",
"210235982510FB000024",
"210235982510FB000023",
"210235982510F8000001",
"210235980510G8000025",
"210235980510G8000024",
"210235980510G6000007",
"210235980510G3000011",
"210235980510G3000010",
"210235980510G1000011",
"210235980510G1000007",
"2102351NAW10H7000002",
"2102351NAW10H7000001",
"2102351FEC10J3000004",
"2102351FEC10J3000003",
"2102351FCF10HA000002",
"2102351FCF10HA000001",
"2102351AAN10HA000004",
"2102351AAN10H9000003",
"2102351AAJ10J2000002",
"2102351AAJ10HA000003",
"2102351AAJ10H9000001",
"2102351AAH10H7000002",
"2102351AAH10H7000001",
"2102351AAH10H4000007",
"2102351AAF10H7000002",
"2102351AAF10H7000001",
"2102350YEM10HB000002",
"2102350YEM10HA000001",
"2102350YEM10H9000001",
"2102350XCS10J4000002",
"2102350XCS10J2000003",
"2102350XCS10HC000007",
"2102350XCS10HB000006",
"2102350XCS10HB000005",
"2102350XCS10HB000004",
"2102350XCS10HB000002",
"2102350XCS10HA000004",
"2102350XCS10HA000003",
"2102350XCS10HA000002",
"2102350XCS10H9000011",
"2102350XCS10H9000010",
"2102350XCS10H9000009",
"2102350XCS10H9000008",
"2102350XCS10H9000003",
"2102350XCS10H9000002",
"2102350XCS10H8000004",
"2102350XCS10H8000002",
"2102350XCS10H7000009",
"2102350XCS10H7000006",
"2102350XCS10H7000005",
"2102350XCS10H7000004",
"2102350XCS10H7000003",
"2102350XCS10H7000002",
"2102350XCS10H6000006",
"2102350XCS10H5000003",
"2102350XCS10H5000002",
"2102350XCS10H5000001",
"2102350XCS10H4000014",
"2102350XCS10H4000003",
"2102350XCS10H4000002",
"2102350XCS10H4000001",
"2102350XCS10H3000001",
"2102350XCS10H1000003",
"2102350XCS10H1000001",
"2102350XCS10GC000012",
"2102350XCS10GC000010",
"2102350XCS10GC000009",
"2102350XCS10GC000008",
"2102350XCS10GC000003",
"2102350XCS10GB000034",
"2102350XCS10GB000032",
"2102350XCS10GB000025",
"2102350XCS10GB000024",
"2102350XCS10GB000023",
"2102350XCS10GB000019",
"2102350XCS10GB000017",
"2102350XCS10GB000013",
"2102350XCS10GB000011",
"2102350XCS10GB000007",
"2102350XCS10GB000006",
"2102350XCS10GB000005",
"2102350XCS10GB000004",
"2102350XCS10GB000003",
"2102350XCS10GB000002",
"2102350UHP10HB000006",
"2102350UHP10HA000002",
"2102350UHP10HA000001",
"2102350UHP10H9000005",
"2102350UHP10H9000004",
"2102350UHP10H9000003",
"2102350UHP10H9000002",
"2102350UHP10H8000002",
"2102350UHP10H8000001",
"2102350UHP10H7000005",
"2102350UHP10H7000003",
"2102350UHP10H7000001",
"2102350UHP10H5000008",
"2102350UHP10H5000007",
"2102350UHP10H5000006",
"2102350UHP10H5000005",
"2102350UHP10H5000004",
"2102350UHP10H5000003",
"2102350UHP10H2000002",
"2102350UHP10GC000005",
"2102350UHP10GC000004",
"2102350UHP10GC000003",
"2102350UHP10GC000002",
"2102350UHP10GC000001",
"2102350UHP10GB000001",
"2102350UHJ10J1000004",
"2102350UHJ10J1000003",
"2102350UHJ10J1000002",
"2102350UHJ10J1000001",
"2102350UHJ10HB000011",
"2102350UHJ10HB000010",
"2102350UHJ10HB000008",
"2102350UHJ10H9000002",
"2102350UHJ10H9000001",
"2102350UHJ10H7000020",
"2102350UHJ10H7000001",
"2102350UHJ10H6000007",
"2102350UHJ10H2000032",
"2102350UHJ10H2000031",
"2102350UHJ10H1000011",
"2102350UHJ10H1000008",
"2102350UHJ10GB000015",
"2102350UHJ10GB000002",
"2102350UHJ10GB000001",
"2102350UHJ10G9000002",
"2102350UHJ10G9000001",
"2102350UHG10J5000003",
"2102350UHG10J2000007",
"2102350UHG10HB000002",
"2102350UHG10HB000001",
"2102350UHG10HA000004",
"2102350UHG10HA000003",
"2102350UHG10H7000003",
"2102350UHG10H3000002",
"2102350UHG10GB000003",
"2102350GFF10G8000002",
"2102350GFF10G8000001",
"2102350GFF10G1000009",
"2102350GFF10G1000008",
"2102350GFF10G1000007",
"2102350GFF10FB000001",
"2102350FJQ10H9000007",
"2102350FJQ10H9000005",
"2102350FJQ10GA000012",
"2102350FJQ10GA000007",
"2102350FJP10G7000002",
"2102350FJN10H8000003",
"2102350FJN10H8000002",
"2102350FJN10H8000001",
"2102350FJN10H7000001",
"2102350FJN10GC000007",
"2102350FJN10GC000006",
"2102350FJN10GA000003",
"2102350FJN10G9000005",
"2102350FJN10G9000004",
"2102350FJN10G9000002",
"2102350FJN10G9000001",
"2102350FJN10G8000005",
"2102350FJN10G8000004",
"2102350FJN10G4000001",
"2102350FJN10G3000001",
"2102350FJN10FC000001",
"2102350FJM10G9000003",
"2102350FJM10G8000001",
"2102350FJM10G7000002",
"2102350FJM10G2000001",
"2102350FJH10H3000003",
"2102350FJH10GC000008",
"2102350FJG10J4000008",
"2102350FJG10J4000007",
"2102350FJG10J4000005",
"2102350FJG10H1000001",
"2102350FJF10G9000017",
"2102350FJF10G9000005",
"2102350FJF10G8000002",
"2102350FJF10G7000001",
"2102350FJF10G2000001",
"2102350FHK10H7000007",
"2102350FHK10GB000009",
"2102350FHK10G9000024",
"2102350FHK10G6000034",
"2102350FHK10G1000027",
"2102350FHK10FC000006",
"2102350FHJ10H1000001",
"2102350FDJ10G4000003",
"2102350FDJ10G4000001",
"2102350FDJ10G3000004",
"2102350FDJ10G2000004",
"2102350FDG10G4000031",
"2102350BSB10GC000031",
"2102350BSB10GC000030",
"2102350BSB10G1000015",
"2102350BSB10FC000029",
"2102350BSB10FB000002",
"2102350BSB10F8000001",
"2102350BSA10J1000003",
"2102350BSA10J1000002",
"2102350BSA10G7000016",
"2102350BSA10G7000015",
"2102350BSA10G6000010",
"2102350BSA10G6000009",
"2102350BSA10G6000008",
"2102350BSA10G5000007",
"2102350BSA10G5000005",
"2102350BSA10G5000003",
"2102350BSA10G5000002",
"2102350BSA10FC000022",
"2102350BSA10FC000020",
"2102350BSA10FC000019",
"2102350BSA10FA000001",
"2102350BSA10F8000004",
"2102350BSA10F6000004",
"2102350BSA10F5000003",
"2102350BRY10GC000019",
"2102350BRY10G8000012",
"2102350BRY10G8000011",
"2102350BRY10G7000019",
"2102350BRY10G7000010",
"2102350BRY10G6000022",
"2102350BRY10G6000020",
"2102350BRY10G6000019",
"2102350BRY10G5000017",
"2102350BRY10G4000009",
"2102350BRY10G2000009",
"2102350BRY10G2000004",
"2102350BRY10G1000023",
"2102350BRY10G1000005",
"2102350BRY10G1000004",
"2102350BRY10FC000006",
"2102350BRY10FB000007",
"2102350BRY10FB000006",
"2102350BRY10FB000005",
"2102350BRY10FB000004",
"2102350BRY10FB000003",
"2102350BRY10FA000007",
"2102350BRY10FA000005",
"2102350BRY10FA000004",
"2102350BRY10F9000001",
"2102350BRY10F8000002",
"2102350BRY10F8000001",
"2102350BRY10F7000010", ]

# 存储产品接入的AD域服务器安装Windows补丁导致AD域用户无法
RISK_AD_DOMAIN_ACCESS_CIFS_VERSION_AND_PATCH = {
    "V300R006C00SPC100": "V300R006C00SPH116",
    "V300R006C10SPC100": "V300R006C10SPH107",
    "V300R006C20": "V300R006C20SPH023",
    "V300R006C50SPC100": "V300R006C50SPH115",
    "V300R006C61": "V300R006C61SPH007",
    "V500R007C00SPC100": "V500R007C00SPH107",
    "V500R007C10": "V500R007C10SPH023",
    "V500R007C30SPC100": "V500R007C30SPH115",
    "V500R007C61": "V500R007C61SPH007",
    "V500R007C60SPC100 Kunpeng": "V500R007C60SPH102",
    "V500R007C60SPC300 Kunpeng": "V500R007C60SPH307",
}
