# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(devObj):
    '''
        预警检查前置脚本
    '''
    try:
        #检查用户名称是否非法（部分关键字作为用户名将影响CLI执行结果判断）
        loginUserName = py_java_env.get("devInfoMap").get("userName")
        LOGGER.logInfo("loginUserName is %s" % str(loginUserName))
        isPass = checkLoginUserName(loginUserName)
        if not isPass:
            return ('', dict(flag=False, des=common.getMsg(LANG, "loginUser.name.check.failure")))
        
        return ('', dict(flag=True, des=common.getMsg(LANG, "check.pass")))
     
     
    except Exception, exception:
        LOGGER.logException(exception)
        return ('', dict(flag=False, des=common.getMsg(LANG, "query.result.abnormal")))

USER_NAME_BLACK_LIST = ["developer", "diagnose", "error", "password", "upgrade", "minisystem", "storage"]
def checkLoginUserName(loginUserName):
    '''
    @summary: 检查工具登录用户名称是否为特殊用户名
    '''
    
    loginUserName = loginUserName.lower()
    
    for keyWords in USER_NAME_BLACK_LIST:
        if loginUserName.endswith(keyWords):
            return False
    
    return True