# -*- coding: UTF-8 -*-
import commons
from com.huawei.ism.tool.obase.exception import ToolException
from cbb.frame.context import contextUtil

PY_JAVA_ENV = py_java_env
LANG = PY_JAVA_ENV.get("lang")
LOGGER = PY_LOGGER
resource = commons.getResource(PY_JAVA_ENV)


# *************************************************************************** #
# 函数名称: execute
# 功能说明: A&S285-20180130-关于HUAWEI OceanStor Sx900存储硬盘可靠性优化等若干
# 重大问题的整改通知
# 输入参数: ssh连接
# *************************************************************************** #


def execute(cli):
    all_cli_ret = ''
    try:
        # 1 查询当前设备型号是否为风险型号
        bug_model_list = ['S3900-M200', 'S3900-M300', 'S5900-M100',
                          'S5900-M200', 'S6900-M100']
        context = contextUtil.getContext(PY_JAVA_ENV)
        product_model = contextUtil.getDevType(context)
        LOGGER.info("this product model is:{}.".format(product_model))
        if product_model == "":
            err_msg = resource.getString('can.not.get.device.model')
            return False, all_cli_ret, err_msg

        if product_model not in bug_model_list:
            err_msg = resource.getString('no.support.model') % product_model
            return 'NOSUPPORT', all_cli_ret, err_msg

        # 2 发送命令showupgradepkginfo -t 1查看系统当前版本是否为V100R005C30SPC800及之前的版本

        cli_ret4_ver, flag4_ver, err_msg, product_version = \
            commons.getCurSysVer(cli, resource)
        all_cli_ret += cli_ret4_ver
        if not flag4_ver:
            return False, all_cli_ret, err_msg
        LOGGER.info("this product version is:{}.".format(product_version))

        if product_version < "V100R005C30SPC800":
            err_msg = resource.getString('current.version') % (
                product_model, "\n", product_version)
            return False, all_cli_ret, err_msg

        hot_patch_ver_info, flag, err_msg, cur_hot_patch_ver = \
            commons.getCurHotPatchVersion(cli, resource)
        all_cli_ret += '\n' + hot_patch_ver_info
        if not flag:
            return False, all_cli_ret, err_msg

        if cur_hot_patch_ver != 'V100R005C30SPH801':
            err_msg = resource.getString('current.version') % (
                product_model, "\n", product_version)
            return 'WARNING', all_cli_ret, err_msg
        return True, all_cli_ret, ""
    except (ToolException, Exception) as e:
        LOGGER.error(str(e))
        return False, all_cli_ret, resource.getString(
            "can.not.get.info")
