# -*- coding: UTF-8 -*-
import commons
def execute(cli):
    '''
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd('showctrlinfo')
    Return             : flag, cliRet, errMsg
    '''

    flag = True
    errMsg = ''
    resource = commons.getResource(py_java_env)
    
    lowestVersionList = {
                         ('S2100' , 'V100R001'):'1.02.01.226.T06',
                         ('S2300' , 'V100R001'):'1.02.01.226.T06',
                         ('S2300E', 'V100R001'):'1.02.01.226.T06',
                         ('S5300' , 'V100R001'):'1.03.01.123.T07',
                         ('S5500' , 'V100R001'):'1.03.01.123.T07',
                         ('S5600' , 'V100R001'):'1.03.01.123.T07',
                         ('S5300' , 'V100R002'):'1.03.03.111.T06',
                         ('S5500' , 'V100R002'):'1.03.03.111.T06',
                         ('S5600' , 'V100R002'):'1.03.03.111.T06',
                         ('S6800E', 'V100R002'):'1.03.03.214.T06',
                        }
    
    deviceModel = str(py_java_env.get('devInfo').getDeviceType())
    productVersion = str(py_java_env.get('devInfo').getProductVersion())[0:8]
            
    lowestVersion = lowestVersionList.get((deviceModel , productVersion))
    
    if not lowestVersion:
        flag = 'NOSUPPORT'
        errMsg = resource.getString('no.support.model.or.version')
        return (flag, '', errMsg)  
   
    cliRet, softwareVersion = commons.getSysVer(cli)
    
    if not softwareVersion:
        flag = False
        errMsg = resource.getString('invalid.cli.msg')
    elif ((productVersion == 'V100R001' and softwareVersion < lowestVersion) 
        or(productVersion == 'V100R002' and softwareVersion <= lowestVersion)):
        flag = False
        errMsg = resource.getString('prewarning.no.implement')
    else:
        flag = 'NOSUPPORT'
        errMsg = resource.getString('no.support.model.or.version')
        
    return (flag, cliRet, errMsg)
