# -*- coding: UTF-8 -*-
import commons

def execute(cli):
    '''
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd('showctrlinfo')
    Return             : flag, cliRet, errMsg
    '''
    
    flag = True
    errMsg = ''
    resource = commons.getResource(py_java_env)

    supportDeviceModels = ['V1800', 'S2100', 'S2300', 'S2300E', 'S5300', 'S5500', 'S5600']
    riskDiskModelList = ['ST31000340NS', 'ST3500320NS', 'ST3750330NS', 'ST3250310NS']
    
    deviceModel = str(py_java_env.get('devInfo').getDeviceType())

    if deviceModel not in supportDeviceModels:
        flag = 'NOSUPPORT'
        errMsg = resource.getString('no.support.model.or.version')
        return (flag, '', errMsg)  
    
    cliRet = cli.execCmd('showdisk -p')
    
    lines = cliRet.splitlines()
    
    for i in range(len(lines) - 1):
        if lines[i].find('Disk Location') != -1:
            index = i + 1
            keyLine = lines[i]
            break
    else:
        errMsg = resource.getString('invalid.cli.msg')
        return (False, cliRet, errMsg)
    
    lastModel = ''
    lastDiskLocation = ''
    riskDiskLocation = []
    for field in lines[index:-1]:
        #当遍历的此行信息为空时，不进行后续操作
        if len(field.strip()) == 0:
            continue
   
        diskLocation = commons.getValByKey('Disk Location', keyLine, field)
        model = commons.getValByKey('Model', keyLine, field)
        
        #校正某些产品在字条中过长时会出现换行的问题
        if not diskLocation:
            model = lastModel + model
            diskLocation = lastDiskLocation

        lastModel = model
        lastDiskLocation = diskLocation
            
        if model in riskDiskModelList:
            riskDiskLocation.append(diskLocation)
    
    if riskDiskLocation:
        flag = False
        errMsg = resource.getString('exist.risk.disk') % ', '.join(riskDiskLocation)
    
    return (flag, cliRet, errMsg)
