# -*- coding: UTF-8 -*-
import commons
import re

def execute(cli):
    '''
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd('showctrlinfo')
    Return             : flag, cliRet, errMsg
    '''
    
    checkPass = False
    errMsg = ''
    resource = commons.getResource(py_java_env)
    debugPwd = str(py_java_env.get('devInfo').getDeveloperPwd())

    supportVersionList = {
                          'S2300' :['1.02.01.226.T06', '1.02.01.228.T02'],
                          'S2300E':['1.02.01.226.T06', '1.02.01.228.T02'],
                          'S5300' :['1.03.01.123.T07'],
                          'S5500' :['1.03.01.123.T07'],
                          'S5600' :['1.03.01.123.T07'],
                         }

    deviceModel = str(py_java_env.get('devInfo').getDeviceType())
            
    supportVersions = supportVersionList.get(deviceModel)
    
    if not supportVersions:
        checkPass = 'NOSUPPORT'
        errMsg = resource.getString('no.support.model.or.version')
        return (checkPass, '', errMsg) 
    
    cliRet, softwareVersion = commons.getSysVer(cli)
    
    if not softwareVersion:
        errMsg = resource.getString('invalid.cli.msg')
    elif softwareVersion in supportVersions:#控制器版本支持慢盘补丁 
        if debugPwd:            
            installedPatch, qryPatchRet, errMsg = qrySlowDiskPatch(cli, debugPwd)
            cliRet += '\n' + qryPatchRet
            if installedPatch:#双控已安装补丁
                checkPass = True
                cliRet1 = cli.execCmd('showslowdiskisolation')
                cliRet += '\n' + cliRet1
            else:#两端都未安装补丁
                pass
        else:
            errMsg = resource.getString('empty.debug.pwd')
    elif softwareVersion < max(supportVersions):#控制器版本小于支持慢盘补丁的最大版本，不支持慢盘补丁（隐藏条件，上一个elif过滤）
        errMsg = resource.getString('lower.product.version')
    else:#高于临界版本（不涉及的版本）
        checkPass = 'NOSUPPORT'
        errMsg = resource.getString('no.support.model.or.version')
               
    return (checkPass, cliRet , errMsg)

def qrySlowDiskPatch(cli, debugPwd):
    '''
    Function name      : qrySlowDiskPatch(cli, debugPwd)
    Function describe  : Query whether the disk array is installed disk slow cold patch or hot patch.
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd('showctrlinfo')
    Return             : isInstalled, cliRet, errMsg
    '''
    
    resource = commons.getResource(py_java_env)
    peerBondIP = getPeerBondIP(cli, debugPwd)
    if not peerBondIP:
        return (False, '', resource.getString('get.peer.bondIP.failed'))
    
    (localInstalled, peerInstalled, cliRet) = qrySlowDiskColdPatch(cli, debugPwd, peerBondIP)
    if localInstalled and peerInstalled:#两端都已安装冷补丁
        return (True, cliRet, '')
    elif not localInstalled and not peerInstalled:#两端都未安装冷补丁
        (localInstalled, peerInstalled, cliRet1) = qrySlowDiskHotPatch(cli, debugPwd, peerBondIP)
        if localInstalled and peerInstalled:#两端都已安装热补丁
            return (True, cliRet1, '')
        elif not localInstalled and not peerInstalled:#两端都未安装热补丁
            return (False, cliRet + '\n' + cliRet1, resource.getString('no.slowdisk.patch')) 
        else:
            return (False, cliRet + '\n' + cliRet1, resource.getString('only.one.slowdisk.hotPatch'))
    else:#只有一端安装冷补丁
        return (False, cliRet, resource.getString('only.one.slowdisk.coldPatch'))


def qrySlowDiskColdPatch(cli, debugPwd, peerBondIP):
    '''
    Function name      : qrySlowDiskColdPatch(cli, debugPwd, peerBondIP)
    Function describe  : Query whether the disk array is installed disk slow cold patch.
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd('showctrlinfo')
    Return             : isInstalled, cliRet, errMsg
    '''   
     
    cliRet = cli.execCmd('debug')
    if cliRet.find('Password') != -1:
        ret = cli.execCmdNoLog(debugPwd)
        if ret.find('Error') != -1:
            return (False, False, '')
    
    usrName = str(py_java_env.get('devInfoMap').get('userName'))
    userPwd = str(py_java_env.get('devInfoMap').get('password'))
    qryLocalColdPatchCmd = 'cat /cf_data/image/boot/slowdisk_version'
    qryPeerColdPatchCmd = 'ssh ' + usrName + '@' + peerBondIP + ' ' + qryLocalColdPatchCmd
        
    localCliRet, peerCliRet = '', '' 
    localInstalled, peerInstalled = False, False
    except_counter = 0
    try: 
        localCliRet = cli.execCmd(qryLocalColdPatchCmd)
        if localCliRet.find('slowdisk patch 1.2') != -1:
            localInstalled = True
            
        peerCliRet =  cli.execCmd(qryPeerColdPatchCmd)
        if peerCliRet.find('(yes/no)?') != -1:
            peerCliRet = cli.execCmd('yes')
            
        if peerCliRet.find('Password') != -1:
            peerCliRet = cli.execCmdNoLog(userPwd)        
        
        if peerCliRet.find('slowdisk patch 1.2') != -1:
            peerInstalled = True
    except:
        except_counter += 1
    finally:
        cli.execCmd('exit') #退出Debug    
        return (localInstalled, peerInstalled, localCliRet + '\n' + peerCliRet)

            
def qrySlowDiskHotPatch(cli, debugPwd, peerBondIP):
    '''
    Function name      : qrySlowDiskHotPatch(cli, debugPwd, peerBondIP)
    Function describe  : Query whether the disk array is installed disk slow hot patch.
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd('showctrlinfo')
    Return             : isInstalled, cliRet, errMsg
    '''
           
    cliRet = cli.execCmd('debug')
    if cliRet.find('Password') != -1:
        ret = cli.execCmdNoLog(debugPwd)
        if ret.find('Error') != -1:
            return (False, False, '')
    
    usrName = str(py_java_env.get('devInfoMap').get('userName'))
    userPwd = str(py_java_env.get('devInfoMap').get('password'))
    qryLocalHotPatchCmd = 'cat /cf_data/image/boot/patch_list'
    qryPeerHotPatchCmd = 'ssh ' + usrName + '@' + peerBondIP + ' ' + qryLocalHotPatchCmd
        
    localCliRet, peerCliRet = '', '' 
    localInstalled, peerInstalled = False, False
    except_counter = 0
    try: 
        localCliRet = cli.execCmd(qryLocalHotPatchCmd)
        
        peerCliRet =  cli.execCmd(qryPeerHotPatchCmd)
        if peerCliRet.find('(yes/no)?') != -1:
            peerCliRet = cli.execCmd('yes')
            
        if peerCliRet.find('Password') != -1:
            peerCliRet = cli.execCmdNoLog(userPwd)        
        
        if localCliRet.find('slow_disk_latency') != -1:
            localInstalled = True
        if peerCliRet.find('slow_disk_latency') != -1:
            peerInstalled = True
    except:
        except_counter += 1
    finally:
        cli.execCmd('exit') #退出Debug    
        return (localInstalled, peerInstalled, localCliRet + '\n' + peerCliRet)

def getPeerBondIP(cli, debugPwd):
    '''
    Function name      : getPeerBondIP(cli, debugPwd)
    Function describe  : Get peer bond0 IP.
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd('showctrlinfo')
    Return             : peer Bond0 IP
    ''' 
     
    cliRet = cli.execCmd('debug')
    if cliRet.find('Password') != -1:
        ret = cli.execCmdNoLog(debugPwd)
        if ret.find('Error') != -1:
            return ''
        
    try:
        cliRet = cli.execCmd('ifconfig bond0')
        for line in cliRet.splitlines():
            if line.find('inet addr') != -1:
                localBondIP = line.split()[1].split(':')[1].strip()
                peerBondIP = ''
                if localBondIP.endswith('.10'):
                    peerBondIP =  re.sub('10$', '11', localBondIP)
                elif localBondIP.endswith('.11'):
                    peerBondIP =  re.sub('11$', '10', localBondIP)
                else:
                    return ''
                return peerBondIP
        else:
            return ''
    except:
        return ''
    finally:
        cli.execCmd('exit') #退出Debug