# -*- coding: UTF-8 -*-
import re 
import commons
import xlrd
import os

'''由于Python库xlrd的局限性，目前只支持解析Excel_2003的文件'''
COMPASS_DISK_FILE_NAME = r'compass_Huawei.xls'

def execute(cli):
    '''
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd('showctrlinfo')
    Return             : flag, cliRet, errMsg
    '''
    
    flag = True
    errMsg = ''
    
    compassCheckPass, compassCliRet, compassErrMsg = checkCompassDisk(cli)
    I2CRestoreCheckPass, I2CRestoreCliRet, I2CRestoreErrMsg = checkI2CRestore(cli)
    
    CliRet = compassCliRet + '\n' + I2CRestoreCliRet
    
    if not compassCheckPass or not I2CRestoreCheckPass:
        errMsgList = []
        if not compassCheckPass:
            errMsgList.append(compassErrMsg)
            
        if not I2CRestoreCheckPass:
            errMsgList.append(I2CRestoreErrMsg)
            
        flag = False
        errMsg = '\n'.join(errMsgList)
    
    return (flag, CliRet, errMsg)

def checkCompassDisk(cli):
    '''
    Function name      : checkCompassDisk(cliConnection)
    Function describe  : check Compass Disk
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd('showctrlinfo')
    Return             : flag, cliRet, errMsg
    '''
    
    flag = True
    errMsg = ''
    resource = commons.getResource(py_java_env)
    
    '''工具取得风险盘的序列号list'''
    seriesNumList = getDiskList()
    
    cli.execCmd('chgpagination off')
    
    '''查询硬盘的逻辑信息+物理信息'''
    allDiskPhyInfo = cli.execCmd('showdisk -physic')

    cliRet = allDiskPhyInfo

    '''检查回文是否正确        BEGIN'''
    allDiskPhyInfoList = allDiskPhyInfo.splitlines()
    for i in range(len(allDiskPhyInfoList) - 2):
        if allDiskPhyInfoList[i].find('Disk Location') != -1:
            indexPhyInfo = i + 2
            keyLinePhyInfo = allDiskPhyInfoList[i]
            break
    else:
        errMsg = resource.getString('invalid.cli.msg')
        return (False, cliRet, errMsg)
    '''检查回文是否正确        END'''
    
    '''检查指定盘是否在Compass风险盘列表中     BEGIN'''
    compassDiskList = []
    for diskPhyInfo in allDiskPhyInfoList[indexPhyInfo:]:
        if re.match('^=+$', diskPhyInfo):
            break
        
        diskLocation = commons.getValByKey('Disk Location', keyLinePhyInfo, diskPhyInfo) 
        searchSerialNum = commons.getValByKey('Serial Number', keyLinePhyInfo, diskPhyInfo)[0:8]
            
        if searchSerialNum in seriesNumList:            
            compassDiskList.append(diskLocation)
    
    if compassDiskList:
        flag = False
        errMsg = resource.getString('exist.compass.phydisk') % ', '.join(compassDiskList)
    '''检查指定盘是否在Compass风险盘列表中     END'''
    
    return flag, cliRet, errMsg

def checkI2CRestore(cli):
    '''
    Function name      : checkI2CRestore(cliConnection)
    Function describe  : check check I2C Restore
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd('showctrlinfo')
    Return             : flag, cliRet, errMsg
    '''
    
    flag = True
    errMsg = ''
    resource = commons.getResource(py_java_env)
    supportModel = ['S3900-M200','S3900-M300']
    deviceModel = str(py_java_env.get('devInfo').getDeviceType())
    #只有S3900与S5900可能存在I2C自修复问题，不涉及,最终不会上报，因compass巡检只有"通过"与"不通过"两种结果
    if deviceModel not in supportModel:
        flag = 'NOSUPORT'
        errMsg = resource.getString('no.support.model.or.version')
        return (flag, '', errMsg)
    
    supportVersion = {
                      'V100R002C00SPC011':['V100R002C00SPC011SPHB01', 'V100R002C00SPC011SPHB02', 'V100R002C00SPC011SPHB03', 'V100R002C00SPC011SPHB04'],
                      'V100R002C00SPC012':['V100R002C00SPC012SPHC01', 'V100R002C00SPC012SPHC02', 'V100R002C00SPC012SPHC03', 'V100R002C00SPC012SPHC04'],
                     }

    cli.execCmd('chgpagination off')
    
    '''查询控制器软件版本信息+补丁版本信息'''
    ctrlPkgInfo = cli.execCmd('showupgradepkginfo -t 1')

    cliRet = ctrlPkgInfo

    '''检查回文是否正确        BEGIN'''
    ctrlPkgInfoList = ctrlPkgInfo.splitlines()
    for i in range(len(ctrlPkgInfoList) - 2):
        if ctrlPkgInfoList[i].find('Package Version') != -1:
            keyLine = ctrlPkgInfoList[i]
            ctrlPkgVersion = commons.getValByKey('Package Version', keyLine, ctrlPkgInfoList[i + 2]) 
            break
    else:
        errMsg = resource.getString('invalid.cli.msg')
        return (False, cliRet, errMsg)
    '''检查回文是否正确        END'''
    
    patchVerList = supportVersion.get(ctrlPkgVersion)
    
    #不涉及，最终不会上报，因compass巡检只有"通过"与"不通过"两种结果
    if not patchVerList:
        flag = 'NOSUPORT'
        return (flag, cliRet, errMsg)
    
    patchPkgInfo = cli.execCmd('showupgradepkginfo -t 3')
    
    cliRet = ctrlPkgInfo + '\n' + patchPkgInfo
    patchPkgInfoList = patchPkgInfo.splitlines()
    #未安装补丁
    if patchPkgInfo.find('succ') != -1:
        errMsg = resource.getString('no.I2C.restore.patch')
        return (False, cliRet, errMsg)
    
    for i in range(len(patchPkgInfoList) - 2):
        if patchPkgInfoList[i].find('Package Version') != -1:
            keyLine = patchPkgInfoList[i]
            index = i + 2
            break
    else:
        errMsg = resource.getString('invalid.cli.msg')
        return (False, cliRet, errMsg)
    
    patchedCtrl = []
    for patchInfo in patchPkgInfoList[index:]:
        patchPckVersion = commons.getValByKey('Package Version', keyLine, patchInfo).upper()
        ctrlID = commons.getValByKey('Controller ID', keyLine, patchInfo)
        if patchPckVersion in patchVerList:
            patchedCtrl.append(ctrlID)
    
    if len(set(patchedCtrl)) == 0:
        errMsg = resource.getString('no.I2C.restore.patch')
        return (False, cliRet, errMsg)
    elif len(set(patchedCtrl)) == 1:
        errMsg = resource.getString('onlyone.I2C.restore.patch')
        return (False, cliRet, errMsg)
    else:
        return (True, cliRet, errMsg)
    
def getDiskList():
    '''
    Function name      : getDiskList()
    Function describe  : get compass Disk List.
    Return             : compass Disk series Number List
    '''
    
    excel = Excel()
    excel.open()
    seriesNoList = excel.creatCompassDiskList('Affected SN', 0)

    return(seriesNoList)

class Excel(object):
    '''
    Class name          : Excel
    Class describe      : interface to read Excel file
    '''
    
    def __init__(self, filename=COMPASS_DISK_FILE_NAME):
        '''
        Function name      : __init__(filename)
        Function describe  : initialize Class 
        '''
        
        '''将当前路径插入到文件名前'''
        filepath = py_java_env.get('path')
        filename = filepath + os.sep + filename
        self.filename = filename

    def open(self):
        '''
        Function name      : open()
        Function describe  : Open excel file and active sheet
        '''
        
        self.dada = xlrd.open_workbook(self.filename)

    def creatCompassDiskList(self, sheet_name, start_row):
        '''
        Function name      : creatCompassDiskList(sheet_name, start_row)
        Function describe  : get compass disk list from excel file
        Input              : sheet_name--sheet name 
                             start_row --the row number that start to read
        Return             : compass disk list
        '''
        
        self.table = self.dada.sheet_by_name(sheet_name)
        nrows = self.table.nrows
        seriesNoList = []

        for rownum in range(start_row, nrows, 1):
            cell = str(self.table.cell(rownum, 0))

            if bool(re.search('empty', cell, re.IGNORECASE)):
                continue
            elif bool(re.search('DRIVE_SERIAL_NUM', cell, re.IGNORECASE)):
                continue
            else:
                driveSeriesNo = cell.replace('text:u', '').replace('\'', '')
                seriesNoList.append(driveSeriesNo)

        return seriesNoList