# -*- coding: UTF-8 -*-
import commons
import re
def execute(cli):
    '''
    Function name      : execute(cli)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : flag, cliRet, errMsg
    '''
    
    #初始化变量
    flag = True
    errMsg = ''
    resource = commons.getResource(py_java_env)
    
    #支持的产品型号
    supportDeviceList = ['S3900-M200', 'S3900-M300', 'S5900-M100', 'S5900-M200', 'S6900-M100']
    
    #测试产品版本
    testProductVersion = 'V100R005C02SPC300'
    
    #测试补丁版本
    testPatchVersion = 'V100R005C02SPH301'
    
    #获取回文和设备型号
    modelCliRet, deviceModel = getCurDeviceType(cli)
    if not deviceModel:
        errMsg = resource.getString('invalid.cli.msg')
        return (False, modelCliRet, errMsg)
    
    #当前产品型号不在该预警检查项中
    if  deviceModel not in supportDeviceList:
        flag = 'NOSUPPORT'
        errMsg = resource.getString('no.support.model.or.version')
        return (flag, modelCliRet, errMsg)
    
    #获取回文和标志位、错误信息、当前产品版本：
    productCliRet, flag, errMsg, productVersion = getCurSystemVersion(cli, resource)
    
    #组合回文
    cliRet = modelCliRet + '\n' + productCliRet
    
    #无效信息
    if not flag:
        return (flag, cliRet, errMsg)
    
    #当前产品版本小于测试版本
    if productVersion < testProductVersion:
        flag = False
        errMsg = resource.getString('prewarning.no.implement')
    #当前产品版本等于测试版本
    elif productVersion == testProductVersion:
        
        #获取回文和标志位、错误信息、当前产品补丁版本
        patchCliRet, flag, errMsg, patchVersion = getCurHotPatchVersion(cli, resource)
        
        #组合回文
        cliRet += '\n' + patchCliRet
        
        if not flag:
            return (flag, cliRet, errMsg)
        
        #当前补丁版本小于测试版本
        if patchVersion < testPatchVersion:
            flag = False
            errMsg = resource.getString('prewarning.no.implement')
        #当前补丁版本大于等于测试版本
        else:
            flag = True
    #当前产品版本大于测试版本
    else:
        flag = 'NOSUPPORT'
        errMsg = resource.getString('no.support.model.or.version')
    return (flag, cliRet, errMsg)  

# *************************************************************#
# 函数名称: getCurSystemVersion
# 功能说明: 获取当前系统SPC版本号
# 其 他   :  无
# *************************************************************#
def getCurSystemVersion(cli, resource):
    
    #查询系统版本号
    sysSpcVersion = ""
    errMsg = ""
    systemVerInfo = cli.execCmd("showupgradepkginfo -t 1")
    lines = systemVerInfo.splitlines()
    
    # 命令执行结果小于7行，说明执行该命令后并没有输出有效信息
    if len(lines) < 7:
        errMsg = resource.getString('invalid.cli.msg')
        return (systemVerInfo, False, errMsg, sysSpcVersion)
    
    # 从第7行开始，取出有效信息
    sysSpcVersion = lines[6].split()[1]
    return (systemVerInfo, True, errMsg, sysSpcVersion)

# *************************************************************#
# 函数名称: getCurDeviceType
# 功能说明: 获取当前系统型号
# 其 他   :  无
# *************************************************************#
def getCurDeviceType(cli):
    
    #查询设备类型
    DeviceType = ""
    
    sysInfo = cli.execCmd("showsys")
    lineList = sysInfo.splitlines()
    if re.search("System Information", sysInfo, re.IGNORECASE):
        for line in lineList:
            if line.find("Device Type") != -1:
                field = line.split()
                if len(field) == 5:
                    DeviceType = field[-1]
                break

    return sysInfo, DeviceType

# *************************************************************#
# 函数名称: getCurHotPatchVersion
# 功能说明: 获取当前系统补丁版本号
# 其 他   :  无
# *************************************************************#
def getCurHotPatchVersion(cli, resource):
    
    #查询当前设备已安装热补丁
    curHotPatchVer = ""
    errMsg = ""
    hotPatchVerInfo = cli.execCmd("showupgradepkginfo -t 3")
    
    #没有安装任何热补丁，返回空
    if re.search("command operates successfully", hotPatchVerInfo, re.IGNORECASE):
        return (hotPatchVerInfo, True, errMsg, curHotPatchVer)
    
    #导入了热补丁包但是没有激活
    if not re.search("Running", hotPatchVerInfo, re.IGNORECASE):
        return (hotPatchVerInfo, True, errMsg, curHotPatchVer)
    lineList = hotPatchVerInfo.splitlines()
    
    #信息少于7行，查询信息失败
    if len(lineList) < 7:
        errMsg = resource.getString('invalid.cli.msg')
        return (hotPatchVerInfo, False, errMsg, curHotPatchVer)
    
    #正常情况下获取Running的热补丁版本
    for line in lineList:
        if re.search("A|B", line) and re.search("Running", line, re.IGNORECASE):
            field = line.split()
            if len(field) >= 3:
                curHotPatchVer = field[1]
                break
        else:
            continue 
    return (hotPatchVerInfo, True, errMsg, curHotPatchVer)
