# -*- coding: UTF-8 -*-
import commons
import re

def execute(cli):
    '''
    @summary    : 关于存储产品Bash安全风险问题的预警公告
    @param cli  : CLI连接
    @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
    '''

    #初始化变量
    flag = True
    errMsg = ""
    cliRet = ""
    resource = commons.getResource(py_java_env)

    bugModelList = ['S2200T', 'S2600T', 'S5500T', 'S5600T', 'S5800T', 'S6800T', 'S2900' ,'S3900-M200', 'S3900-M300' ,'S5900-M100','S5900-M200' ,'S6900-M100']
    cliRet, deviceModel = commons.getCurDeviceType(cli)
    if deviceModel == "":
        errMsg = resource.getString('can.not.get.device.model')
        return (False, cliRet, errMsg)

    if not deviceModel in bugModelList:
        errMsg = resource.getString('no.support.model') % deviceModel
        return ('NOSUPPORT', cliRet, errMsg)
    
    #获取回文和标志位、错误信息、当前产品版本：
    productCliRet, flag, CurSysVerErrMsg, productVersion = commons.getCurSysVer(cli, resource)
    cliRet += productCliRet

    if not flag or productVersion == "":
        errMsg = CurSysVerErrMsg
        return (False, cliRet, errMsg)
    errMsg +=resource.getString('current.version') % (deviceModel, "\n", productVersion) + "\n"
    bugVersion = "V100R005C30SPC300"
    if productVersion <= bugVersion:
        coldPatchVerInfo, flag, coldPatchErrMsg, curColdPatchVer = commons.getCurColdPatchVersion(cli, resource)
        cliRet += coldPatchVerInfo
        errMsg += coldPatchErrMsg + "\n"

        if not flag or curColdPatchVer == "":
            return (False, cliRet, errMsg)

        if curColdPatchVer >= "V100R005C30SPC991":
            return (True, cliRet, "")
        else:
            return (False, cliRet, errMsg)

    return (True, cliRet, errMsg)

