# -*- coding: UTF-8 -*-
import commons

def execute(cli):
    '''
    @summary: 关于OceanStor S2600T/S2900产品BBU混插告警及充电超时告警潜在失效的预警公告
    @param cli: CLI连接
    @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
    '''
    
    resource = commons.getResource(py_java_env)
    
    #1 查询当前设备型号是否为风险型号
    bugModelList = ['S2600T', 'S2900']
    cliRet, deviceModel = commons.getCurDeviceType(cli)
    if not deviceModel:
        return (False, cliRet, resource.getString('can.not.get.device.model'))

    if deviceModel not in bugModelList:
        return ('NOSUPPORT', cliRet, resource.getString('no.support.model') % deviceModel)

    #2 发送命令showupgradepkginfo -t 1查看系统当前版本
    cliRet4Ver, flag4Ver, errMsg, productVersion = commons.getCurSysVer(cli, resource)
    cliRet += '\n' + cliRet4Ver
    if not flag4Ver:
        return (False, cliRet, errMsg)
    
    errMsg += resource.getString('current.version') % (deviceModel, "\n", productVersion) + "\n"    
    
    bugVersion4T = 'V100R005C30SPC500'

    if productVersion < bugVersion4T:
        return (False, cliRet, errMsg)
    else:
        return (True, cliRet, "")
   
        
