# -*- coding: UTF-8 -*-
import commons
import re
WARNING = 'WARNING'

def execute(cli):
    errMsg = ''
    resource = commons.getResource(py_java_env)
    normalInfo = "command operates successfully|license|not exist|not support"
    #查询当前设备型号是否为风险型号
    bugModelList = ['S2200T', 'S2600T', 'S5500T', 'S5600T', 'S5800T', 'S6800T', 'S2900' , 'S3900-M200', 'S3900-M300' , 'S5900-M100', 'S5900-M200' , 'S6900-M100']
    cliRet, deviceModel = commons.getCurDeviceType(cli)
    if not deviceModel :
        errMsg = resource.getString('can.not.get.device.model')
        return (False, cliRet, errMsg)

    if deviceModel not in bugModelList:
        errMsg = resource.getString('no.support.model') % deviceModel
        return ('NOSUPPORT', cliRet, errMsg)

    #判断系统是否配置存在Thin LUN
    isThinLunExist = False
    iRet = cli.execCmd("showlun")
    cliRet += '\n' + iRet
    cliList = iRet.splitlines()
    if len(cliList) < 7:
        #判断cli信息是否有效
        if len(iRet.splitlines()) < 7:
            if not re.search(normalInfo, iRet, re.IGNORECASE):
                #showlun命令执行失败
                errMsg = resource.getString('invalid.cli.msg')
                return (False, cliRet, errMsg)
            else:
                return (True, cliRet, '')

    for line in cliList[6:]:
        cliResults = line.strip().split()
        if len(cliResults) >= 8 and cliResults[-1] == "THIN":
            isThinLunExist = True
            break

    if isThinLunExist:
        errMsg += resource.getString('current.sys.exist.thinLUN')
    else:
        return (True, cliRet, '')
    
    #检查系统版本是否满足要求
    cliRetSys, sysQryFlag, errMsgSys, sysSpcVersion = commons.getCurSysVer(cli, resource)
    cliRet += '\n' + cliRetSys
    if not sysQryFlag:
        #查询系统版本失败
        return (False, cliRet, errMsgSys)

    cliRetPatch, patchQryFlag, errMsgPatch, curHotPatchVer = commons.getCurHotPatchVersion(cli, resource)
    cliRet += "\n" + cliRetPatch
    if not patchQryFlag:
        #获取热补丁信息失败
        return (False, cliRet, errMsgPatch)
           
    if isRiskVer(sysSpcVersion, curHotPatchVer):
        errMsg += ('\n' + resource.getString('current.version') % (deviceModel, "\n", sysSpcVersion))
        if curHotPatchVer:
            errMsg += ('\n' + resource.getString('current.hot.patch.version') % curHotPatchVer)
        return (False, cliRet, errMsg)
    else:
        return (True, cliRet, '')

    
def isRiskVer(sysSpcVersion, hotPatchVer):
    if "V100R002" in sysSpcVersion:
        return True
    elif "V100R005C00" in sysSpcVersion:
        if sysSpcVersion < 'V100R005C00SPC900':
            return True
        elif sysSpcVersion == 'V100R005C00SPC900':
            if hotPatchVer < 'V100R005C00SPH903':
                return True
        return False
    elif "V100R005C01" in sysSpcVersion:
        if sysSpcVersion < 'V100R005C01SPC900':
            return True
        elif sysSpcVersion == 'V100R005C01SPC900':
            if hotPatchVer < 'V100R005C01SPH903':
                return True
        return False
    elif "V100R005C02" in sysSpcVersion:
        return True
    elif "V100R005C30" in sysSpcVersion:
        if sysSpcVersion < "V100R005C30SPC500":
            return True
        else:
            return False
    elif "V100R001" in sysSpcVersion:
        return False
    else:
        return False

    
    

