# -*- coding: UTF-8 -*-
import os
import commons
import re


def execute(cli):
    '''
    @summary: 关于存储产品SSLv3 POODLE安全漏洞问题的预警公告
    @param cli: CLI连接
    @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
    '''
    flag = True
    cliRet = ''
    errMsg = ''
    resource = commons.getResource(py_java_env)

    
    #1 查询当前设备型号是否为风险型号
    bugModelList = ['S2200T', 'S2600T', 'S5500T', 'S5600T', 'S5800T', 'S6800T', 'S2900' ,'S3900-M200', 'S3900-M300' ,'S5900-M100','S5900-M200' ,'S6900-M100']
    cliRet, deviceModel = commons.getCurDeviceType(cli)
    if deviceModel == "":
        errMsg = resource.getString('can.not.get.device.model')
        return (False, cliRet, errMsg)

    if deviceModel not in bugModelList:
        errMsg = resource.getString('no.support.model') % deviceModel
        return ('NOSUPPORT', cliRet, errMsg)
    
    #2 发送命令showupgradepkginfo -t 1查看系统当前版本是否为V100R005C30SPC300及之前的版本
    bugVersion = "V100R005C30SPC300"
    cliRet4Ver, flag4Ver, errMsg, productVersion = commons.getCurSysVer(cli, resource)
    cliRet += '\n' + cliRet4Ver
    if not flag4Ver:
        return (False, cliRet, errMsg)
    
    if productVersion <= bugVersion:
        errMsg = resource.getString('current.version') % (deviceModel, '\n', productVersion)
        return (False, cliRet, errMsg)
    
    return (True, cliRet, "")
