# -*- coding: UTF-8 -*-
import commons

def execute(cli):
    '''
    @summary: 关于OceanStor T系列&Sx900产品硬盘重构进度卡住问题的预警公告
    @param cli: CLI连接
    @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
    '''
    errMsg = ""
    resource = commons.getResource(py_java_env)

    #配置风险设备型号和风险控制器版本
    bugDeviceTypeList = ['S2200T', 'S2600T', 'S5500T', 'S5600T', 'S5800T', 'S6800T', 'S2900', 'S3900-M200', 'S3900-M300', 'S5900-M100', 'S5900-M200', 'S6900-M100']
    #查询当前控制器的设备类型
    cliRet, deviceType = commons.getCurDeviceType(cli)
    #若没有获取到设备类型
    if not deviceType:
        return (False, cliRet, resource.getString("can.not.get.device.model"))
    #若当前控制器设备类型不在风险设备型号中
    if deviceType not in bugDeviceTypeList:
        return ('NOSUPPORT', cliRet, (resource.getString("no.support.model") % deviceType))

    #查询当前控制器的版本号
    curCtrlCliRet, flag, curCtrlVerErrmsg, curCtrlVersion = commons.getCurSysVer(cli, resource)
    cliRet += '\n' + curCtrlCliRet
    errMsg += '\n' + resource.getString("current.version") % (deviceType, '\n', curCtrlVersion)

    #若没有查到当前控制器版本或当前回显错误
    if (not flag) or (not curCtrlVersion):
        return (False, cliRet, curCtrlVerErrmsg)

    #若当前控制器版本不在风险版本列表中
    if curCtrlVersion.startswith("V100R005C02") and curCtrlVersion <= "V100R005C02SPC300":
        #若当前控制器版本为V100R005C02，获取控制器中的热补丁版本号
        if curCtrlVersion == 'V100R005C02SPC300':
            #获取热补丁
            hotPatchVerInfo, flag, curHotPatchErrmsg, curHotPatchVer = commons.getCurHotPatchVersion(cli, resource)
            cliRet += '\n' + hotPatchVerInfo
            if not flag:
                return (False, cliRet, curHotPatchErrmsg)
            
            if not curHotPatchVer:
                return ("WARNING", cliRet, errMsg)
            
            #判断热补丁版本号
            if curHotPatchVer >= 'V100R005C02SPH304':
                return (True, cliRet, "")
            else:
                errMsg += '\n' + resource.getString("current.hot.patch.version") % curHotPatchVer
                return ("WARNING", cliRet, errMsg)
        else:
            return ("WARNING", cliRet, errMsg)
    #若当前控制器版本为V100R005C30，进行判断
    elif curCtrlVersion.startswith("V100R005C30") and curCtrlVersion <= "V100R005C30SPC500":
        return ("WARNING", cliRet, errMsg)
    #若控制器版本不为风险版本，则通过
    else:
        return (True, cliRet, errMsg)