# -*- coding: UTF-8 -*-
import commons
import re

def execute(cli):
    '''
    @summary: TV1产品RAID6问题导致业务中断问题
    @param cli: CLI连接
    @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
    '''
    resource = commons.getResource(py_java_env)
    errMsg = ''
    
    bugModelList = ['S2200T', 'S2600T', 'S5500T', 'S5600T', 'S5800T', 'S6800T', 'S2900' ,'S3900-M200', 'S3900-M300' ,'S5900-M100','S5900-M200' ,'S6900-M100']
    cliRet, deviceModel = commons.getCurDeviceType(cli)
    if deviceModel == "":
        errMsg = resource.getString('can.not.get.device.model')
        return (False, cliRet, errMsg)

    if not deviceModel in bugModelList:
        errMsg = resource.getString('no.support.model') % deviceModel
        return ('NOSUPPORT', cliRet, errMsg)

    normalInfo = "command operates successfully|license|not exist|not support"       
    #发送命令showrg确认是否存在RAID6配置的RAID
    isRaid6RgExist = False
    cliRet4Rg = cli.execCmd('showrg')
    cliRet += cliRet4Rg
    # 命令执行结果小于7行，说明执行该命令后并没有输出有效信息
    if len(cliRet4Rg.splitlines()) < 7:
        if not re.search(normalInfo, cliRet4Rg, re.IGNORECASE):
            errMsg = resource.getString('invalid.cli.msg')
            return (False, cliRet, errMsg)
    elif _isRaid6ExistentInRg(cliRet4Rg):
        errMsg = resource.getString('current.sys.exist.raid6.rg')
        isRaid6RgExist = True
    
    #发送命令showpool确认是否存在RAID6配置的RAID
    isRaid6PoolExist = False
    cliRet4Pool = cli.execCmd('showpool')
    cliRet += cliRet4Pool
    # 命令执行结果小于7行，说明执行该命令后并没有输出有效信息
    if len(cliRet4Pool.splitlines()) < 7:
        if not re.search(normalInfo, cliRet4Pool, re.IGNORECASE):
            errMsg = resource.getString('invalid.cli.msg')
            return (False, cliRet, errMsg)
    elif _isRaid6ExistentInPool(cliRet4Pool):
        errMsg += ('\n' + resource.getString('current.sys.exist.raid6.pool'))
        isRaid6PoolExist = True
    
    if not isRaid6RgExist and not isRaid6PoolExist:
        return (True, cliRet, errMsg)
    
    cliRet4Ver, flag4Ver, verErrMsg, productVersion = commons.getCurSysVer(cli, resource)
    cliRet += cliRet4Ver
    if not flag4Ver:
        return (False, cliRet, verErrMsg)
    
    isRiskVer = False
    isRiskHotPatch = False
    if 'V100R002' in productVersion:
        if 'V100R002C00' in productVersion and productVersion >= 'V100R002C00SPC015':
            isRiskVer = True
        if 'V100R002C01' in productVersion and productVersion >= 'V100R002C01SPC015':
            isRiskVer = True
    elif 'V100R005C00' in productVersion or 'V100R005C01' in productVersion:
        isRiskVer = True
    elif 'V100R005C02' in productVersion:
        if productVersion < 'V100R005C02SPC300':
            isRiskVer = True
        elif productVersion == 'V100R005C02SPC300':
            cliRetPatch, patchQryFlag, errMsgPatch, curHotPatchVer = commons.getCurHotPatchVersion(cli, resource)
            cliRet += '\n' + cliRetPatch
            if not patchQryFlag:
                #获取热补丁信息失败
                return (False, cliRet, errMsgPatch)
            elif not curHotPatchVer:
                isRiskVer = True
            elif curHotPatchVer < 'V100R005C02SPH304':
                isRiskHotPatch = True
    elif 'V100R005C30' in productVersion and productVersion < 'V100R005C30SPC500':
        isRiskVer = True
    
    if isRiskVer or isRiskHotPatch: 
        errMsg += '\n' + resource.getString('current.version') % (deviceModel, "\n", productVersion)
    
    if isRiskHotPatch:
        errMsg += resource.getString('current.hot.patch.version') % curHotPatchVer
    
    if isRiskVer or isRiskHotPatch:
        return (False, cliRet, errMsg)
    else:
        return (True, cliRet, '')
    
def _isRaid6ExistentInRg(cliRet):
    '''
    @summary: judge whether raid6 is existent in RAID group
    @param cliRet: CLI info
    @return: exist or not
    '''
    cliRetLines = cliRet.splitlines()
    for line in cliRetLines[6:]:
        fields = line.split()
        if len(fields) < 2:
            break
        if 'RAID6' == fields[1]:
            return True
    return False


def _isRaid6ExistentInPool(cliRet):
    '''
    @summary: judge whether raid6 is existent in pool
    @param cliRet: CLI info
    @return: exist or not
    '''
    cliRetLines = cliRet.splitlines()
    for line in cliRetLines[6:]:
        fields = line.split()
        if len(fields) < 2:
            break
        if 'RAID6' == fields[2]:
            return True
    return False

