﻿# -*- coding: UTF-8 -*-
from common.resLeak import init, checkResLeak
from common.utils import getDevVer, isDevFileExsit

S26R1_PATH_CUR = "/OSM/log/cur_debug/"
S26R1_PATH_HIS = "/OSM/log_conf_local/log/his_debug/"
S26R1_PATH_CPR = "/OSM/log_conf_local/log/compresslog/message/"

#框架执行函数入口    
def execute(cli):
    
    lang = py_java_env.get("lang")
    PY_LOGGER.info("Inspect[1068EResLeak_S2600R1] starting......")
    
    #获取软件版本
    deviceVer, cliRet = getDevVer(cli)
    if not deviceVer:
        if "zh" == lang:
            errMsg = u"\n查询系统软件版本信息失败。"
        else:
            errMsg = u"\nFailed to query the system software version."
        return False, cliRet, errMsg
    deviceVer = str(deviceVer).strip()	
    
    #判断相应的软件版本（1.04.01.212.T08或1.04.01.215.T08）是否已打补丁
    if deviceVer in ["1.04.01.212.T08", "1.04.01.215.T08"] \
        and isDevFileExsit(py_java_env, "/OSM/config/", "patch_sasiniko.version"):
        return True, cliRet + "\n" + "The system(software version: " + deviceVer + ") has been installed the 1068E resource leakage patch", ""
    
    PY_LOGGER.info("Inspect[1068EResLeak_S2600R1] start to analyse log file.")
    
    init(S26R1_PATH_CUR, S26R1_PATH_HIS, S26R1_PATH_CPR)
    
    return checkResLeak(cli, py_java_env, PY_LOGGER) 
   
