﻿# -*- coding: UTF-8 -*-
from common.resLeak import init, checkResLeak

S26R2R5_PATH_CUR = "/OSM/log/cur_debug/"
S26R2R5_PATH_HIS = "/OSM/coffer_log/log/his_debug/"
S26R2R5_PATH_CPR = "/OSM/coffer_log/compresslog/message/"

#框架执行函数入口    
def execute(cli):
    
    lang = py_java_env.get("lang")
    PY_LOGGER.info("Inspect[1068EResLeak_S2600R5] starting......")

    #获取软件版本
    deviceVer, cliRet = getDevVer(cli)
    if not deviceVer:
        if "zh" == lang:
            errMsg = u"\n查询系统软件版本信息失败。"
        else:
            errMsg = u"\nFailed to query the system software version."
        return False, cliRet, errMsg
    deviceVer = str(deviceVer).strip()
    
    #软件版本大于1.04.05.131.T02，巡检通过
    if deviceVer >= "1.04.05.131.T02":
        return True, cliRet + "\n" + "The system(software version: " + deviceVer + ") has solved the 1068E resource leakage problem", ""

    PY_LOGGER.info("Inspect[1068EResLeak_S2600R5] start to analyse log file.")

    init(S26R2R5_PATH_CUR, S26R2R5_PATH_HIS, S26R2R5_PATH_CPR)

    return checkResLeak(cli, py_java_env, PY_LOGGER) 
    

    
