# -*- coding: UTF-8 -*-
import os
import traceback
from common.cTV1R1 import *
from common.utils import *

DEVICE_LOG_PATH = "/tmp/log_reset.txt"

def _isFileExist(cli, islocal=True):
    """
    # *****************************************************************************************#
    # 功能说明: 判断文件是否存在（debug模式下）
    # 输入参数: cli, islocal=True
    # 返 回 值: True（存在），False（不存在）
    # *****************************************************************************************#
    """
    cmd = "cat " + str(DEVICE_LOG_PATH)
    cliRet = ""
    
    if islocal:
        cliRet = cliMgt.execCmd(cli, cmd)
    else:    
        flag, cliRet, errMsg = sendDebugCmd2Peer(cli, cmd, py_java_env, PY_LOGGER)
    return not re.search("No such file or directory", cliRet, re.IGNORECASE)
        
def _getOccurTime(lineInfo):
    """
    # *****************************************************************************************#
    # 函数名称: _getOccurTime(lineInfo)
    # 功能说明: 根据当前行获取cmostime时间
    # 输入参数: lineInfo
    # 返 回 值: cmostime时间：即距离1970年7月1日的秒数
    # *****************************************************************************************#
    """
    lineInfo = lineInfo.replace(" ", "").split("cmostime=")[1]
    return lineInfo[0:lineInfo.find(",")]

def _getTimePrefix(seconds):
    """
    # *****************************************************************************************#
    # 函数名称: _getTimePrefix(seconds)
    # 功能说明: 根据距离1970年1月1日的秒数转换为当前时间
    # 输入参数: seconds
    # 返 回 值: 2014-11-11 19:24:16格式字符串
    # *****************************************************************************************#
    """
    try:
        tmpTime = time.localtime(int(seconds))
        return str(time.strftime("[%Y-%m-%d %H:%M:%S] ", tmpTime))
    except:
        return ""
    
def _getResetReason(lineInfo):
    """
    # *****************************************************************************************#
    # 函数名称: _getResetReason(lineInfo)
    # 功能说明: 根据当前行获取复位原因
    # 输入参数: lineInfo
    # 返 回 值: 复位原因，并转化为小写
    # *****************************************************************************************#
    """
    return lineInfo.split("reason=")[1].strip().lower()
    
def _checkLogReset(fileDir, ipAddr, curDevTimeSec, spanDays=180):
    """
    # *****************************************************************************************#
    # 函数名称: _checkLogReset(fileDir, ipAddr)
    # 功能说明: 根据传入的文件路径，分析文件是否有异常复位
    # 输入参数: fileDir, ipAddr
    # 返 回 值: flag, cliRet, errMsg （flag为False且cliRet不为空时表示有异常复位）
    # *****************************************************************************************#
    """
    flag = True
    cliRet = ""
    errMsg = ""
    
    f = open(fileDir, "rb")
    
    #检查不通过列表，注意最终匹配为小写模式
    notPassValList = ("watchdog reset",
                      "oops reset",
                      "out of memory reset",
                      "panic reset",
                      "kernel reset",
                      "mce reset",
                      "ecc reset",
                      "timer-1068e reset"
                      ) 
    for lineInfo in f:
        if lineInfo.startswith("The latest") and "reason=" in lineInfo:
            if isInTimeSpan(_getOccurTime(lineInfo), curDevTimeSec, spanDays)\
                and _getResetReason(lineInfo) in notPassValList:
                flag = False
                cliRet += _getTimePrefix(_getOccurTime(lineInfo)) + lineInfo
    
    if cliRet:
        cliRet = "\nController " + str(ipAddr) + ":\n" + cliRet
    
    f.close()   
    return flag, cliRet, errMsg 
    
def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        localIp = ""
        peerIp = ""
        curDevTimeSec = -1
        fileName = os.path.basename(DEVICE_LOG_PATH)
        
        #获取系统是否为单控还是双控
        sysMode, itemCliRet, itemErrMsg = getSysModeState(cli, py_java_env)
        if sysMode not in [MODE_SINGLE, MODE_DOUBLE]:
            PY_LOGGER.error("Inspect[AbormalReboot] not pass(Get unkown system mode)")
            return False, itemCliRet, itemErrMsg
        
        flag, cliRet, errMsg = changeAnyMode2Debug(cli, py_java_env)
        if not flag:
            PY_LOGGER.error("Inspect[AbormalReboot] not pass(change to debug mode failed)")
            return False, cliRet, errMsg
        
        #debug模式下获取阵列当前时间
        curDevTimeSec = formatTimeStamp2Sec(getCurDevTime(cli))
        PY_LOGGER.info("Inspect[AbormalReboot] The system current time is:" + str(curDevTimeSec))
        if -1 == curDevTimeSec:
            return False, "Failed to get system time.", getSysTimeFailedMsg(lang)
        
        #本端执行os_cli命令生成临时文件
        cliMgt.execCmd(cli, "os_cli " + LOCAL_DEVICE_TEMP_PATH)
        
        #创建本地临时存放文件
        localTmpPath = getLocaTmplFilePath(py_java_env)
        mkLocalTmpPath(localTmpPath)
        
        #拷贝阵列文件到本地
        cliRet = ""
        localIp = getLocalIpAddr(py_java_env)
        
        if _isFileExist(cli):
            mvSucc, fileDir = mvLocalDevFile2Local(cli, py_java_env, localIp , DEVICE_LOG_PATH)
            #本端文件获取成功开始分析
            if mvSucc:
                PY_LOGGER.info("Inspect[AbormalReboot] Starting to parse local file:)" + str(fileDir))
                lclFlag, lclCliRet, lclErrMsg = _checkLogReset(fileDir, localIp, curDevTimeSec, 180)
                cliRet += lclCliRet
                errMsg += lclErrMsg
                if not lclFlag:
                   flag = False
                   PY_LOGGER.error("Inspect[AbormalReboot] not pass(local exist abnormal reboot)")
            else:
                flag = False
                PY_LOGGER.error("Inspect[AbormalReboot] not pass(local file get failed)")
                errMsg += getFileFaildMsg(lang, True, fileName)
            
        #双控时获取对端文件到本地
        if MODE_DOUBLE == sysMode:
            sendDebugCmd2Peer(cli, "os_cli " + LOCAL_DEVICE_TEMP_PATH, py_java_env, PY_LOGGER)
            
            if _isFileExist(cli, False):
                peerIp = getPeerIpAddr(cli, py_java_env)
                mvSucc, fileDir = mvPeerDevFile2Local(cli, py_java_env, peerIp, DEVICE_LOG_PATH)
                #对端文件获取成功开始分析
                if mvSucc:
                    PY_LOGGER.info("Inspect[AbormalReboot] Starting to parse peer file:)" + str(fileDir))
                    peerFlag, peerCliRet, peerErrMsg = _checkLogReset(localTmpPath + peerIp + "_" + fileName, peerIp, curDevTimeSec, 180)
                    cliRet += peerCliRet
                    errMsg += peerErrMsg
                    if not peerFlag:
                       flag = False
                       PY_LOGGER.error("Inspect[AbormalReboot] not pass(peer exist abnormal reboot)")
                else:
                   flag = False
                   PY_LOGGER.error("Inspect[AbormalReboot] not pass(peer file get failed)")
                   errMsg += getFileFaildMsg(lang, False, fileName)

        if flag:
            PY_LOGGER.info("Inspect[AbormalReboot] pass!")
            cliRet = NO_INFO_MSG
        elif cliRet:
            PY_LOGGER.error("Inspect[AbormalReboot] not pass(exist abnormal reboot)")
            if "zh" == lang:
                errMsg += u"\n系统存在异常重启。"
            else:
                errMsg += u"\nThe system reboots abnormally."
        return flag, cliRet, errMsg

    except:
        PY_LOGGER.error("Inspect[AbormalReboot] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
    finally:
        delDevLocalFile(cli, py_java_env, DEVICE_LOG_PATH)
        if MODE_DOUBLE:
            delDevRemoteFile(cli, py_java_env, DEVICE_LOG_PATH, PY_LOGGER)
        changeAnyMode2Cli(cli)
        

        
        
        
        
