# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *


def ctrlIsDcPower(cli):
    """
    # *****************************************************************************************#
    # 类名称: ctrlIsDcPower(cli)
    # 功能说明: 判断当前电源是否为直流电源，直流电源不对电池进行巡检，巡检此项直接通过
    # 输入参数: cli
    # 输出参数: errMsg, flag , cliRet（flag值在errMsg为空时才有意义，errMsg不为空代表有失败的回显）
    # *****************************************************************************************#
    """
    
    flag = True
    ctrlId = ""
    lang = py_java_env.get("lang")
    
    cmd = "showsubrack"
    cliRet = cliMgt.execCmd(cli,cmd)
    
    #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
    preRet, errMsg = preCheckCliRet(cmd, cliRet, lang)
    if RET_FAIL == preRet:
        flag = False
        return errMsg, flag , cliRet
    
    #第二个参数传入[]表示获取所有key值对应的value
    formatFunction = cHandleTypeList(cliRet)
    listDict = formatFunction.handle()
    
    ctrlInfo = {}
    #获取正常状态下的控制框信息
    for dictInfo in listDict:
        if "Controller" == dictInfo.get("Type") and "Online" == dictInfo.get("Status"):
            ctrlInfo = dictInfo
            break
    
    #获取电源类型
    if ctrlInfo:
        ctrlId = ctrlInfo.get("Subrack ID")
        cmd = "showpowerinfo"
        itemCliRet = cliMgt.execCmd(cli,cmd)
        cliRet += itemCliRet
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, itemCliRet, lang)
        if RET_FAIL == preRet:
            flag = False
            return errMsg, flag, cliRet
              
        formatFunction = cHandleTypeList(itemCliRet.replace(", ", ","))
        listDict = formatFunction.handle()
        validPowrPattern = "\(\s*" + ctrlId + "\s*,\s*\d+\s*\)"
    
        powerList = []
        for dictinfo in listDict:
            powerLocation = dictinfo.get("Power Location")
            if re.match(validPowrPattern, str(powerLocation)):
                powerList.append(dictinfo)
        
        for powerInfo in powerList:
            if powerInfo.get("PowerType") == "alternate":
                flag = False
                break
                
    return errMsg, flag, cliRet
                 
def execute(cli):
    flag = PASS
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        
        #电池状态正常，Is Charge Full为yes的记数
        bbuOkNum = 0
        
        errMsg, isDcPower, cliRet = ctrlIsDcPower(cli)
        
        #errMsg不为空代表有执行失败的CLI命令，直接提示不通过
        if errMsg:
            flag = NOT_PASS
            PY_LOGGER.error("Inspect[BBUStatus] not pass!(cliRet1 invalid)")
            return flag, cliRet, errMsg
        
        #判断电源是否为直流，直流不巡检电池
        if isDcPower:
            flag = PASS
            PY_LOGGER.info("Inspect[BBUStatus] pass!(DC power)")
            return PASS, cliRet, errMsg
        
        #不同的版本，CLI命令可能不一样，挑选出当前版本支持的CLI命令并获得对应回显结果 
        cmd, itemCliRet = getSupportCliRet(cli, ["showbbu"])
        cliRet += itemCliRet
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, itemErrMsg = preCheckCliRet(cmd, itemCliRet, lang)
        if RET_FAIL == preRet:
            flag = NOT_PASS
            errMsg += itemErrMsg
            PY_LOGGER.error("Inspect[BBUStatus] not pass(cliRet2 invalid)")
            return flag, cliRet, errMsg
        
        #第二个参数传入[]表示获取所有key值对应的value
        #兼容BBU ID和Bbu ID，Begin
        formatFunction = cHandleTypeDict(itemCliRet)
        #兼容BBU ID和Bbu ID，Begin
        listDict = formatFunction.handle()
        
        #交流电时检查电池数量
        if len(listDict) < 2:
            flag = WARNING
            PY_LOGGER.error("Inspect[BBUStatus] not pass(powers number not enough)")
            if "zh" == lang:
                errMsg += u"\nBBU数量不足。"
            else: 
                errMsg += u"\nThe number of BBU is insufficient."   
            #若不存在BBU，直接返回  2014/11/21 Begin
            if not listDict:
                return flag, cliRet, errMsg
            #若不存在BBU，直接返回  2014/11/21 End
            
        #获取正常状态下的控制框及级联框信息
        for dictInfo in listDict:
            #兼容BBU ID和Bbu ID，Begin
            bbuID = dictInfo.get("BBU ID")
            if not bbuID:
                bbuID = dictInfo.get("Bbu ID")

            if "Normal" != dictInfo.get("BBU Status"):
                flag = NOT_PASS
                PY_LOGGER.error("Inspect[BBUStatus] not pass(status abnormal)") 
                if "zh" == lang:
                    errMsg += u"\nBBU（BBU ID：" + str(bbuID) + u"）状态不正常（" + str(dictInfo.get("BBU Status")) + u"）。"
                else: 
                    errMsg += u"\nThe BBU Status of the BBU(BBU ID: " + str(bbuID) + u") is abnormal(" + str(dictInfo.get("BBU Status")) + u")." 
            
            #电池状态正常，且满足写时间的电池个数记数
            elif "Yes" == dictInfo.get("Is Charge Full"):
                bbuOkNum += 1
                
            #电池状态正常，不满足写时间的电池个数提示
            elif "Yes" != dictInfo.get("Is Charge Full"):
                PY_LOGGER.error("Inspect[BBUStatus] warning(Is Charge Full not yes)") 
                if "zh" == lang:
                    errMsg += u"\nBBU（BBU ID：" + str(bbuID) + u"）Is Charge Full状态不正常（" + str(dictInfo.get("Is Charge Full")) + u"）。"
                else: 
                    errMsg += u"\nThe Is Charge Full status of the BBU(BBU ID：" + str(bbuID)+ u") is abnormal(" + str(dictInfo.get("Is Charge Full")) + u")." 
            #兼容BBU ID和Bbu ID，End

        #电池Is Charge Full沒有一个为yes，则巡检不通过
        if 0 == bbuOkNum:
            flag = NOT_PASS
            
        #电池都正常的情况下，若是不是所有的Is Charge Full都为Yes，则提示警告
        if NOT_PASS != flag and 1 == bbuOkNum and len(listDict) == 2:
            flag = WARNING
            PY_LOGGER.error("Inspect[BBUStatus] not pass(warning)") 
        elif PASS == flag:
            PY_LOGGER.info("Inspect[BBUStatus] pass!")
                  
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[BBUStatus] catch parse except of trace back:" + str(traceback.format_exc()))
        return NOT_PASS, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[BBUStatus] catch except of trace back:" + str(traceback.format_exc()))
        return NOT_PASS, cliRet, getExceptionMsg(lang)
