# -*- coding: UTF-8 -*-
import time
import traceback
from common.utils import *

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    try:
        errMsg = ""
        flag, cliRet, errMsg = changeAnyMode2Mml(cli, py_java_env)
        if not flag:
            PY_LOGGER.error("Inspect[BST] not pass(change to mml mode failed)")
            return False, cliRet, errMsg
        
        #BST开关状态检测
        cliRet = cliMgt.execCmd(cli, 'bst enable 3')
        bstStatus = "-1"
        for line in cliRet.splitlines():
            if line.strip().startswith("Status:"):
                bstStatus = line.strip().replace("Status:", "").split()[0].strip()
                if  "2" == bstStatus:
                    PY_LOGGER.error("Inspect[BST] not pass(BST closed)")
                    if "zh" == lang:
                        errMsg = u"\nBST功能未打开。"
                    else:
                        errMsg = u"\nThe function of BST is closed." 
                    return False, cliRet, errMsg
        #无BST功能版本
        if "-1" == bstStatus:
            PY_LOGGER.info("Inspect[BST] pass(no BST function)")
            return True, "No BST function", errMsg  
        
        #判定是否有BST记录         
        bstNum = -1
        cliRet2 = cliMgt.execCmd(cli, 'bst showbst')
        cliRet += cliRet2
        for line in cliRet2.splitlines():
            if line.strip().startswith('Total record'):
                bstNum = int(line.split(':')[1].strip())		
        PY_LOGGER.info("BST number:" + str(bstNum))
        if bstNum > 0:
            flag = False
            PY_LOGGER.error("Inspect[BST] not pass(exist BST)")
            if "zh" == lang:
                errMsg = u"\n系统存在BST标记。"
            else:
                errMsg = u"\nBST record exists in the system."
        #“bst showbst”命令执行失败 的情况
        elif bstNum == -1:
            flag = False
            PY_LOGGER.error("Inspect[BST] not pass(cliRet invalid)")
            if "zh" == lang:
                errMsg = u"\n\'bst showbst\'命令执行结果无效。"
            else:
                errMsg = u"The output of the \'bst showbst\' command is invalid."
        if flag:
            PY_LOGGER.info("Inspect[BST] pass!")
            
        return flag, cliRet, errMsg
          
    except:
        PY_LOGGER.error("Inspect[BST] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
    finally:
        changeAnyMode2Cli(cli)
        
