# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *


def ctrlIsDcPower(cli):
    """
    # *****************************************************************************************#
    # 类名称: ctrlIsDcPower(cli)
    # 功能说明: 判断当前电源是否为直流电源，直流电源不对电池进行巡检，巡检此项直接通过
    # 输入参数: cli
    # 输出参数: errMsg, flag , cliRet（flag值在errMsg为空时才有意义，errMsg不为空代表有失败的回显）
    # *****************************************************************************************#
    """
    
    flag = True
    ctrlId = ""
    lang = py_java_env.get("lang")
    
    cmd = "showsubrack"
    cliRet = cliMgt.execCmd(cli, cmd)
    
    #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
    preRet, errMsg = preCheckCliRet(cmd, cliRet, lang)
    if RET_FAIL == preRet:
        flag = False
        return errMsg, flag , cliRet
    
    #第二个参数传入[]表示获取所有key值对应的value
    formatFunction = cHandleTypeList(cliRet)
    listDict = formatFunction.handle()
    
    ctrlInfo = {}
    #获取正常状态下的控制框信息
    for dictInfo in listDict:
        if "Controller" == dictInfo.get("Type") and "Online" == dictInfo.get("Status"):
            ctrlInfo = dictInfo
            break
    
    #获取电源类型
    if ctrlInfo:
        ctrlId = ctrlInfo.get("Subrack ID")
        cmd = "showpower"
        itemCliRet = cliMgt.execCmd(cli, cmd)
        cliRet += itemCliRet
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, itemCliRet, lang)
        if RET_FAIL == preRet:
            flag = False
            return errMsg, flag, cliRet
              
        formatFunction = cHandleTypeList(itemCliRet)
        listDict = formatFunction.handle()

        powerList = []
        for dictinfo in listDict:
            subrackID = dictinfo.get("Subrack ID")
            if ctrlId == subrackID:
                powerList.append(dictinfo)
        
        for powerInfo in powerList:
            if powerInfo.get("Type").startswith("AC"):
                flag = False
                break
                
    return errMsg, flag, cliRet
                 
def execute(cli):
    flag = PASS
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        
        #电池状态正常，MeetWriteTime为yes的记数
        batteryOkNum = 0
        
        errMsg, isDcPower, cliRet = ctrlIsDcPower(cli)
        
        #errMsg不为空代表有执行失败的CLI命令，直接提示不通过
        if errMsg:
            flag = NOT_PASS
            PY_LOGGER.error("Inspect[BatteryStatus] not pass!(cliRet1 invalid)")
            return flag, cliRet, errMsg
        
        #判断电源是否为直流，直流不巡检电池
        if isDcPower:
            flag = PASS
            PY_LOGGER.info("Inspect[BatteryStatus] pass!(DC power)")
            return PASS, cliRet, errMsg
        
        cmd = "showbattery"
        itemCliRet = cliMgt.execCmd(cli, cmd)
        cliRet += itemCliRet
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, itemErrMsg = preCheckCliRet(cmd, itemCliRet, lang)
        if RET_FAIL == preRet:
            flag = NOT_PASS
            errMsg += itemErrMsg
            PY_LOGGER.error("Inspect[BatteryStatus] not pass(cliRet2 invalid)")
            return flag , cliRet, errMsg
        
        #第二个参数传入[]表示获取所有key值对应的value
        formatFunction = cHandleTypeList(itemCliRet)
        listDict = formatFunction.handle()
        
        #交流电时检查电池数量
        if len(listDict) < 2:
            flag = NOT_PASS
            PY_LOGGER.error("Inspect[BatteryStatus] not pass(powers number not enough)")
            if "zh" == lang:
                errMsg += u"\n电池数量不足。"
            else: 
                errMsg += u"\nThe number of batteries is insufficient."   

        #获取正常状态下的控制框及级联框信息
        for dictInfo in listDict:
            if "Normal" != dictInfo.get("Run Status"):
                flag = NOT_PASS
                PY_LOGGER.error("Inspect[BatteryStatus] not pass(status abnormal)") 
                if "zh" == lang:
                    errMsg += u"\n电池（Battery ID：" + str(dictInfo.get("Battery ID")) + u"）运行状态不正常（" + str(dictInfo.get("Run Status")) + u"）。"
                else: 
                    errMsg += u"\nThe Run Status of battery(Battery ID: " + str(dictInfo.get("Battery ID")) + u") is abnormal(" + str(dictInfo.get("Run Status")) + u")." 
            
            #电池状态正常，且满足写时间的电池个数记数
            elif "Yes" == dictInfo.get("MeetWriteTime"):
                batteryOkNum += 1
                
            #电池状态正常，不满足写时间的电池个数提示
            elif "Yes" != dictInfo.get("MeetWriteTime"):
                PY_LOGGER.error("Inspect[BatteryStatus] warning(MeetWriteTime not yes)") 
                if "zh" == lang:
                    errMsg += u"\n电池（Battery ID：" + str(dictInfo.get("Battery ID")) + u"）MeetWriteTime状态不正常（" + str(dictInfo.get("MeetWriteTime")) + u"）。"
                else: 
                    errMsg += u"\nThe MeetWriteTime of battery(Battery ID: " + str(dictInfo.get("Battery ID")) + u") is abnormal(" + str(dictInfo.get("MeetWriteTime")) + u")." 
        
        #电池MeetWriteTime沒有一个为yes，则巡检不通过
        if 0 == batteryOkNum:
            flag = NOT_PASS
            
        #电池都正常的情况下，若是不是所有的MeetWriteTime都为Yes，则提示警告
        if NOT_PASS != flag and 1 == batteryOkNum:
            flag = WARNING
            PY_LOGGER.error("Inspect[BatteryStatus] not pass(warning)") 
        elif PASS == flag:
            PY_LOGGER.info("Inspect[BatteryStatus] pass!")
                  
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[BatteryStatus] catch parse except of trace back:" + str(traceback.format_exc()))
        return NOT_PASS, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[BatteryStatus] catch except of trace back:" + str(traceback.format_exc()))
        return NOT_PASS, cliRet, getExceptionMsg(lang)
