# -*- coding: UTF-8 -*-
import time
import traceback
from common.cTV1R1 import *
from common.utils import *

QRY_CPU_UTILITY_INTERVAL = 5

QRY_CPU_UTILIY_TIMES = 5

def execute(cli):
    flag = True
    allCliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        cpuUtilityListOfCtrlA = []
        cpuUtilityListOfCtrlB = []
        cpuUtilityListOfCtrlDict = {"A":[], "B":[]}
        
        for i in range(QRY_CPU_UTILIY_TIMES):
            cliRet = cliMgt.execCmd(cli, "showctrlinfo")
            
            #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
            preRet, failMsg = preCheckCliRet('showctrlinfo', cliRet, lang, True)
            allCliRet += cliRet
            if RET_FAIL == preRet:
                errMsg += failMsg 
                PY_LOGGER.error("Inspect[CPUUtiliy] not pass(cliRet invalid)")
                return False, allCliRet, errMsg
        
            formatFunction = cHandleTypeDict(cliRet, ['Controller', 'CPU Utility(%)'])
            ctrlInfoList = formatFunction.handle()
            
            for ctrlInfo in ctrlInfoList:
                ctrlId = ctrlInfo.get('Controller')
                utility = ctrlInfo.get('CPU Utility(%)')
                
                if not utility or not utility.isdigit():
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n获取控制器CPU利用率无效。"
                    else:
                        errMsg += u"\nThe obtained CPU utility is invalid."
                    return False, allCliRet, errMsg
                       
                if ctrlId in ['A', 'a']:
                    cpuUtilityListOfCtrlA.append(int(utility))
                elif ctrlId in ['B', 'b']:
                    cpuUtilityListOfCtrlB.append(int(utility))  
                else:
                    PY_LOGGER.error("Inspect[CPUUtiliy] Unknown CTRL ID:" + str(ctrlId))
                 
                       
                time.sleep(QRY_CPU_UTILITY_INTERVAL)
        
        #将各控制器信息写入对应的列表
        cpuUtilityListOfCtrlDict["A"] = cpuUtilityListOfCtrlA
        cpuUtilityListOfCtrlDict["B"] = cpuUtilityListOfCtrlB
        failFlag = False
        warnFlag = False
        for ctrlID in cpuUtilityListOfCtrlDict:
            cpuUtilityList = cpuUtilityListOfCtrlDict[ctrlID]
            checkFlag, errInfo = checkCpuUsage(ctrlID, cpuUtilityList, lang)
            errMsg += errInfo
            if checkFlag == NOT_PASS:
                failFlag = True
            elif checkFlag == WARNING:
                warnFlag = True
        
        #给出检查结果
        if failFlag:
            flag = NOT_PASS
            PY_LOGGER.info("Inspect[CPUUtiliy] not pass!")
        elif warnFlag:
            flag = WARNING
            PY_LOGGER.info("Inspect[CPUUtiliy] optimizing advice!")
        else:
            flag = True
            PY_LOGGER.info("Inspect[CPUUtiliy] pass!")
             
                  
        return flag, allCliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[CPUUtiliy] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, allCliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[CPUUtiliy] catch except of trace back:" + str(traceback.format_exc()))
        return False, allCliRet, getExceptionMsg(lang)

def checkCpuUsage(ctrlID, cpuUtilityList, lang):
    """
    @summary: 检查利用率是否超过标准
    """
    errMsg = ""
    flag = ""
    countGe80 = 0
    countGe90 = 0
    cpuUsage = ""
    
    #计数超过80%和90%的利用率个数
    for value in cpuUtilityList:
        if value > 80:
            countGe80 += 1
        if value > 90:
            countGe90 += 1
      
    #利用率大于90%的大于等于3时，不通过      
    if countGe90 >= 3:
        cpuUsage = u"90%"
        flag = NOT_PASS
             
    #否则利用率大于80%的大于等于3时，建议优化
    elif countGe80 >=3:
        cpuUsage = u"80%"
        flag = WARNING
    
    #存在不通过或建议优化情况
    if flag != "":
        if "zh" == lang:
            errMsg += u"\n控制器：%s的CPU使用率为%s" % (ctrlID,cpuUtilityList)\
                    + u"，存在3次CPU利用率超过阈值%s，阵列处于工作繁忙状态。" % (cpuUsage)
        else:
            errMsg += "\nThe CPU Utility of controller: %s is %s. " %(ctrlID,cpuUtilityList)\
                    + "The value exceeds the threshold %s for three times, " % (cpuUsage)\
                    + "and the storage array is overloaded." 
    
    return flag, errMsg
