# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def execute(cli):
    flag = True
    allCliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        
        errMsg = ""
        cliRet = cliMgt.execCmd(cli, "showlun")
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet('showlun', cliRet, lang)
        if RET_FAIL == preRet:
            PY_LOGGER.error("Inspect[CacheWriteStrategy] not pass(cliRet1 invalid)")
            return False, cliRet, errMsg       
        elif RET_SUC == preRet:
            PY_LOGGER.info("Inspect[CacheWriteStrategy] pass(cmd execute success)!")
            return True, cliRet, errMsg  
        
        allCliRet += cliRet
        formatFunction = cHandleTypeList(cliRet, ['ID'])
        lunList = formatFunction.handle()
        
        lunIDList = []
        for lunInfo in lunList:
            lunID = lunInfo.get('ID')
            lunIDList.append(lunID)
        #LUN回显过多，存在风险。只显示检查不通过的LUN前10条 Begin
        errCounter = 0
        for lunID in lunIDList:
            qryLunDetailInfoCmd = 'showlun -i ' + lunID
            cliRet = cliMgt.execCmd(cli, qryLunDetailInfoCmd)
            
            preRet, failMsg = preCheckCliRet(qryLunDetailInfoCmd, cliRet, lang)
            if RET_FAIL == preRet:
                flag = False
                PY_LOGGER.error("Inspect[CacheWriteStrategy] not pass(cliRet2 invalid)")
                #错误回显次数叠加
                if errCounter < 10:
                    allCliRet += cliRet
                    errCounter += 1
                    
                if "zh" == lang:
                    errMsg += u'\n查询LUN（ID：' + str(lunID) + u'）结果异常。'
                else:
                    errMsg += u'\nThe LUN(ID: ' + str(lunID) + u') query result is abnormal.'
                continue
            
            formatFunction = cHandleTypeDict(cliRet)
            lunDictList = formatFunction.handle()
            for lunInfoDict in lunDictList:
                #私有LUN不检查Cache写策略，2014/09/04 modified Begin
                if "yes"  == str(lunInfoDict.get("Whether Private LUN")).lower():
                    continue
                #私有LUN不检查Cache写策略，2014/09/04 modified End
                
                #版本兼容，V100R002版本为Policy显示，2014/08/25 modified Begin
                cacheStrategy = str(lunInfoDict.get('Cache Write Strategy')) if lunInfoDict.get('Cache Write Strategy') else str(lunInfoDict.get('Cache Write Policy'))
                runingCacheStrategy = str(lunInfoDict.get('Running Cache Write Strategy')) if lunInfoDict.get('Running Cache Write Strategy') else str(lunInfoDict.get('Running Cache Write Policy'))
                #版本兼容，V100R002版本为Policy显示，2014/08/25 modified End
                
                if cacheStrategy == runingCacheStrategy:
                    pass
                #强制回写镜像实际运行情况为回写镜像
                elif "Write back mandatory; Mirroring" == cacheStrategy and "Write back; Mirroring" == runingCacheStrategy:
                    pass
                #强制回写不镜像实际运行情况为回写不镜像
                elif "Write back mandatory; No mirroring" == cacheStrategy and "Write back; No mirroring" == runingCacheStrategy:
                    pass
                elif lunInfoDict.get('Cache Write Strategy'):
                    flag = False
                    PY_LOGGER.error("Inspect[CacheWriteStrategy] not pass(Strategy not the same)")
                    #错误回显次数叠加
                    if errCounter < 10:
                        allCliRet += cliRet
                        errCounter += 1
                    
                    if "zh" == lang:
                        errMsg += (u'\nLUN（ID：' + str(lunID) + u'） Cache写策略不一致（Cache Write Strategy：' + cacheStrategy 
                                   + u'，Running Cache Write Strategy：' + runingCacheStrategy + u'）。')
                    else:
                        errMsg += (u'\nThe LUN(ID: ' + str(lunID) + u') Cache Write Strategy is not implemented as Running Cache Write Strategy(Cache Write Strategy: ' + cacheStrategy 
                                   + u', Running Cache Write Strategy: ' + runingCacheStrategy + u').')
                #版本兼容，V100R002版本为Policy显示，2014/08/25 modified Begin
                elif lunInfoDict.get('Cache Write Policy'):
                    flag = False
                    PY_LOGGER.error("Inspect[CacheWriteStrategy] not pass(Policy not the same)")
                    #错误回显次数叠加
                    if errCounter < 10:
                        allCliRet += cliRet
                        errCounter += 1
                        
                    if "zh" == lang:
                        errMsg += (u'\nLUN（ID：' + str(lunID) + u'） Cache写策略不一致（Cache Write Policy：' + cacheStrategy 
                                   + u'，Running Cache Write Policy：' + runingCacheStrategy + u'）。')
                    else:
                        errMsg += (u'\nThe LUN(ID: ' + str(lunID) + u') Cache Write Policy is not implemented as Running Cache Write Policy(Cache Write Policy: ' + cacheStrategy 
                                   + u', Running Cache Write Policy: ' + runingCacheStrategy + u').')
                #版本兼容，V100R002版本为Policy显示，2014/08/25 modified End
        #LUN回显过多，存在风险。只显示检查不通过的LUN前10条 End
        if flag:
            PY_LOGGER.info("Inspect[CacheWriteStrategy] pass!")
                            
        return flag, allCliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[CacheWriteStrategy] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, allCliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[CacheWriteStrategy] catch except of trace back:" + str(traceback.format_exc()))
        return False, allCliRet, getExceptionMsg(lang)
