# -*- coding: UTF-8 -*-
import traceback
from common import utils
from common import constant

def execute(cli):
    """
    1、6800E R5版本：当(Number of StripeInFlight)/(Max of StripeInFlight)大于0.9，则检查结果为不通过。
    2、2600 R1版本：当(used stripe)/(Limited stripes)大于0.9，则检查结果为不通过。
    """
    allCliRet = ""
    errMsg = ""
    allErrMsg = ""
    flag = True
    context = py_java_env
    logger = PY_LOGGER
    lang = context.get("lang")
    cmddict = {"S6800E":"raid printstriperun","S2600":"raid stripelimitedinfo"}
    try:
        #判断型号版本是否符合
        deviceType = str(context.get("devInfo").getDeviceType())
        sysVer,cmdRet = utils.getDevVer(cli)
        allCliRet += cmdRet
        logger.info("deviceType: " + str(deviceType) + ", Version: " + str(sysVer))
        #S6800E 1.03.03.530.T02 V100R005C02SPC010
        #S2600  1.04.01.208.T10 V100R001C02SPC012
        if not (deviceType.upper() == "S6800E" and sysVer >= "1.03.03.525.T02") and\
            not (deviceType.upper() == "S2600" and sysVer >= "1.04.01.208.T10"):
            return (constant.NO_SUPPORT,cmdRet,errMsg)
    
        #判断当前系统单双控 
        sysMode, cmdRet, errMsg = utils.getSysModeState(cli, context)
        allErrMsg += errMsg
        allCliRet += cmdRet
        if sysMode == constant.MODE_UNKOWN:
            return (False, allCliRet, allErrMsg)
        
        #如果系统双控正常则需要登录两个控制器
        isDoubleSys = True if constant.MODE_DOUBLE == sysMode else False
        
        #获取当前登录的控制器ID
        peerCtrlID = "B"
        flag, cmdRet, localCtrlID, errInfo = utils.getLocalCtrlID(cli,context)
        errMsg += errInfo
        allCliRet += cmdRet
        if not flag:
            return (flag, allCliRet, errMsg)
        
        if localCtrlID == "B":
            peerCtrlID = "A"

        #获取本端和对端的回文结果
        cmd = cmddict[deviceType]
        isSuccess, localCliRet, peerCliRet = utils.execMmlCmd(cli, cmd, context, logger, isDoubleSys)
        allCliRet += localCliRet
        allCliRet += peerCliRet
        if isSuccess == False:
            errMsg += peerCliRet
            return (isSuccess, allCliRet, errMsg)
        
        ctrlIDRetDict = {localCtrlID:localCliRet,peerCtrlID:peerCliRet}
        logger.info("Concurrent_RAID_Stripe_ctrlIDRetDict: " + str(ctrlIDRetDict))
        #检查RAID分条阈值判断入口
        flag ,errMsg = checkConcurrentRAIDStripes(ctrlIDRetDict,deviceType,lang, logger)
        
        return (flag ,allCliRet,errMsg)
    except:
        logger.error("check_item_Concurrent_RAID_Stripe failed, catch except of trace back:" + str(traceback.format_exc()))
        return False, allCliRet, utils.getExceptionMsg(lang)
        
def checkConcurrentRAIDStripes(ctrlIDRetDict,deviceType,lang, logger):
    '''
    @summary: 检查RAID分条阈值检查
    @param ctrlIDRetDict: 双端控制器ID和回显字典
    @param logger: 日志对象
    @return: 检查结果
    '''
    flag = True
    errMsg = ""
    S6800E_R5_USESTRIPE_MARK = "Number of StripeInFlight"
    S6800E_R5_MAXSTRIPE_MARK = "Max of StripeInFlight"
    S2600_R1_USESTRIPE_MARK = "used stripe"
    S2600_R1_MAXSTRIPE_MARK = "Limited stripes"
    for ctrlID in ctrlIDRetDict:
        cliRet = ctrlIDRetDict.get(ctrlID)
        Dict = utils.getHorizontalNostandardCliRet(cliRet)
        if Dict:
            if deviceType == "S6800E":
                useStripe = float(Dict[S6800E_R5_USESTRIPE_MARK])
                maxStripe = float(Dict[S6800E_R5_MAXSTRIPE_MARK])
            else:
                useStripe = float(Dict[S2600_R1_USESTRIPE_MARK])
                maxStripe = float(Dict[S2600_R1_MAXSTRIPE_MARK])
            
            #判断RAID分条比是否超过阈值
            if maxStripe == 0:
                logger.warn("The value of maxStripe is zero, reset to 1")
                maxStripe = 1
            if useStripe/maxStripe > 0.9:
                flag = False
                if "zh" == lang:
                    errMsg += u"\n控制器（ID:%s）RAID分条并发超过阈值。" % (ctrlID)
                else:
                    errMsg += "\nOn controller (ID:%s), the number of concurrent RAID stripes exceeds the threshold. " % (ctrlID) 

    return flag ,errMsg      
