# -*- coding: UTF-8 -*-
import traceback
import time
from common import constant
from common import utils
from common import cliMgt
java_env = py_java_env
logger = PY_LOGGER


def execute(cli):
    """
    # *****************************************************************************************#
    # 函数名称: execute(cli)
    # 功能说明: 并发资源检查，周期性执行命令，每10秒执行一次，持续观察1分钟，共取后面7次有效数据
    # 输入参数: cliRet 命令回文
    # 返 回 值: cilRetAll命令回显
    # *****************************************************************************************#
    """
    modeList =["single","double"]
    #重复执行命令列表
    repecmdlist = ['rtt show a','rtt clean','tgt shownbio']
   
    rttOpenA = "rtt open a"
    rttClose = "rtt close"

    try:
        flag = True
        checkFlag = True
        errMsg = ""
        lang = java_env.get("lang")
        sysSpcVersion = ""
        cliRet = ""
        cliRetAll = ""   
         
        #判断产品版本，S2600 V100R001C02SPC012及以上版本涉及此检查项,之前则不涉及
        sysSpcVersion, cliRet = utils.getDevVer(cli)
        cliRetAll += cliRet
        if sysSpcVersion < '1.04.01.208.T10':
            return (constant.NO_SUPPORT, cliRetAll, errMsg)
        
        #判断系统是否为双控
        (sysMode, itemCliRet, itemErrMsg) = utils.getSysModeState(cli, java_env) 
        if sysMode not in modeList:
            logger.error("Inspect[Concurrent_Resources] not pass(Get unkown system mode)")
            return False, itemCliRet, itemErrMsg
        #如果系统双控正常则需要登录两个控制器
        isDouble = True if 'double' == sysMode else False
        
        #获取控制器的信息，识别当前控制器是A还是B
        cliRet = cliMgt.execCmd(cli,"showctrlip")
        cliRetAll += cliRet
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = utils.preCheckCliRet('showctrlip', cliRet, lang)
        if not preRet:
            logger.error("Inspect[Concurrent_Resources] execute 'showctrlip' failed")
            return False, cliRetAll, errMsg
        
        currntCtrlCliRet = ""
        peerCtrlCliRet = ""
        #单次执行rtt open a命令，获取回显信息
        flag, onelocalCliRet, onepeerCliRet = utils.execMmlCmdLocalBefore(cli, rttOpenA, java_env, logger, isDouble)
        if not flag:
            checkFlag = False
            logger.error("Inspect[Concurrent_Resources] execute 'rtt open a' failed")
            errMsg += onepeerCliRet
        
        currntCtrlCliRet += onelocalCliRet
        peerCtrlCliRet += onepeerCliRet  
         
        #周期性执行如下三个命令：rtt show a、rtt clean、tgt shownbio，每10秒执行一次持续观察1分钟，获取回显信息（若是双控则都要执行）
        for times in range(7):
            flag, repelocalCliRet, repepeerCliRet = utils.execMmlCmdLocalBefore(cli, repecmdlist, java_env, logger, isDouble)
            if not flag:
                checkFlag = False
                #可能多次重复失败，过滤重复错误信息
                if repepeerCliRet not in errMsg:
                    errMsg += repepeerCliRet
                continue            
            currntCtrlCliRet += repelocalCliRet
            peerCtrlCliRet += repepeerCliRet
            #第七次时不睡眠
            if times != 6:
                time.sleep(10)
                
        #单次执行rtt close命令，获取回显信息
        flag, onelocalCliRet, onepeerCliRet = utils.execMmlCmdLocalBefore(cli, rttClose, java_env, logger, isDouble)
        if not flag:
            checkFlag = False
            logger.error("Inspect[Concurrent_Resources] execute 'rtt close' failed")
            errMsg += onepeerCliRet
            
        currntCtrlCliRet += onelocalCliRet
        peerCtrlCliRet += onepeerCliRet  
        #返回本端和对端回显信息
        cliRetAll += currntCtrlCliRet + peerCtrlCliRet
        
        return checkFlag, cliRetAll, errMsg

    except:
        logger.error("Inspect[Concurrent_Resources] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRetAll, errMsg
