# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        cmd = "showctrlinfo"
        cliRet = cliMgt.execCmd(cli, cmd)
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, cliRet, lang)
        if RET_FAIL == preRet:
            PY_LOGGER.error("Inspect[ControllerStatus] not pass(cliRet invalid)")
            return False, cliRet, errMsg
        
        #第二个参数传入[]表示获取所有key值对应的value
        formatFunction = cHandleTypeDict(cliRet, ["Controller", "Running Status"])
        listDict = formatFunction.handle()
        
        for dictInfo in listDict:
            if "Normal" != dictInfo.get("Running Status"):
                flag = False
                PY_LOGGER.error("Inspect[ControllerStatus] not pass(running status abnormal)")
                if "zh" == lang:
                    errMsg += u"\n控制器（Controller：" + str(dictInfo.get("Controller")) + u"）运行状态不正常（" + str(dictInfo.get("Running Status")) + u")。"
                else:
                    errMsg += u"\nThe Running Status of controller(Controller: " + str(dictInfo.get("Controller")) + u") is abnormal(" + str(dictInfo.get("Running Status")) + u")."
        
        #单控不通过
        if 1 == len(listDict):
            flag = False
            PY_LOGGER.error("Inspect[ControllerStatus] not pass(single status)")
            if "zh" == lang:
                errMsg += u"\n系统运行在单控状态。"
            else:
                errMsg += u"\nThe system is in single controller status."
        #查询结果异常
        elif 0 == len(listDict):
            flag = False
            PY_LOGGER.error("Inspect[ControllerStatus] not pass(query failed)")
            if "zh" == lang:
                errMsg = u"\n控制器信息查询结果异常。"
            else:
                errMsg = u"\nThe controller information query result is abnormal." 
        
        if flag:
            PY_LOGGER.info("Inspect[ControllerStatus] pass")
                     
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[ControllerStatus] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[ControllerStatus] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
