# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = u""
        
        cmd = "showtemperature -t 1"
    
        itemCliRet = cliMgt.execCmd(cli, cmd)
        cliRet += itemCliRet
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, itemErrMsg = preCheckCliRet(cmd, itemCliRet, lang)
        if RET_FAIL == preRet:
            flag = False
            PY_LOGGER.error("Inspect[ControllerTemperature] not pass(cliRet invalid)")
            errMsg += itemErrMsg
        
        #第二个参数传入[]表示获取所有key值对应的value
        formatFunction = cHandleTypeList(itemCliRet, ["Point1(CPU)(Celsius)","CPU(Celsius)"])
        listDict = formatFunction.handle()
        for dictInfo in listDict:
            point1Degree = dictInfo.get("Point1(CPU)(Celsius)")
            if not point1Degree:
                point1Degree = dictInfo.get("CPU(Celsius)")
            if not isValidVal(point1Degree) or not point1Degree.isdigit():
                flag = False
                PY_LOGGER.error("Inspect[ControllerTemperature] not pass")   
                if "zh" == lang:
                    errMsg += u"\n获取控制器（CPU）温度值无效（" + str(point1Degree) + u"）。"
                else:
                    errMsg += u"\nThe obtained controller CPU temperature is invalid(" + str(point1Degree) + u")."
                continue

            if point1Degree and point1Degree.isdigit() and int(point1Degree) >= 68:
                flag = False
                PY_LOGGER.error("Inspect[ControllerTemperature] not pass")   
                if "zh" == lang:
                    errMsg += u"\n控制器（CPU）温度不低于68ºC（" + str(point1Degree) + u"）。"
                else:
                    errMsg += u"\nThe controller CPU temperature is not lower than 68 centigrade(" + str(point1Degree) + u")."
        
        if flag:
             PY_LOGGER.info("Inspect[ControllerTemperature] pass!")
             
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[ControllerTemperature] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[ControllerTemperature] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
