# -*- coding: UTF-8 -*-
import traceback
from common.utils import *
from common.checkMsg import init, checkMsgInfo
from common.diskFlickTool import checkDiskFlickResult
#日志带有jiff的标示
S2000S5000_LOG_TAG = " OceanStor kernel:"

#当前日志目录
S2000S5000_CUR_LOG_DIR = "/OSM/log/cur_debug/"

#历史日志目录
S2000S5000_HIS_LOG_DIR = "/OSM/log_conf_local/log/his_debug/"

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    try:
        errMsg = ""
        KEY_WORD = "not in loop"
        
        PY_LOGGER.info("Inspect[DiskFlickStatus] begin!")
  
        flag, cliRet, errMsg, existKeyWord = checkMsgInfo(cli, py_java_env, KEY_WORD, PY_LOGGER, interval=30)
        if flag:
            PY_LOGGER.info("Inspect[DiskFlickStatus] pass!")
            cliRet = NO_INFO_MSG
        #硬盘闪断方案变更， modified 20150109 Begin
        #存在关键字的行，继续分析
        elif existKeyWord:
            flickDiskErrMsgStr,newDetailInfoStr = checkDiskFlickResult(cliRet,lang,5)
            cliRet = newDetailInfoStr
            #构造的结果字符串不为空，证明存在闪断
            if flickDiskErrMsgStr:
                PY_LOGGER.error("Inspect[DiskFlickStatus] not pass(exist flit disk)")
                if "zh" == lang:
                    errMsg += (u"系统存在闪断的硬盘。\n"+flickDiskErrMsgStr)
                else:
                    errMsg += (u"\nThere are disks with the intermittent interruption issue.\n"+flickDiskErrMsgStr)
            #不存在闪断，巡检通过
            else:
                flag = True
                cliRet = NO_INFO_MSG
        #硬盘闪断方案变更， modified 20150109 End
        return flag, cliRet, errMsg
    
    except:
        PY_LOGGER.error("Inspect[DiskFlickStatus] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
        
