# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        
        cmd = "showdisk -l"
        cliRet = cliMgt.execCmd(cli, cmd)
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, cliRet, lang, True)
        if RET_FAIL == preRet:
            PY_LOGGER.error("Inspect[DiskLogicStatus] not pass(cliRet invalid)")
            return False, cliRet, errMsg
        
        formatFunction = cHandleTypeList(cliRet)
        diskList = formatFunction.handle()
        
        for dictInfo in diskList:
            diskLocation = dictInfo.get('Disk Location')
            diskLogicStatus = dictInfo.get('Logical status')
            if not diskLogicStatus:
                diskLogicStatus = dictInfo.get('Logic Status')
            
            if diskLogicStatus not in ['Normal', 'Used spare', 'Free spare', 'Copyback is in process']:
                flag = False
                PY_LOGGER.error("Inspect[DiskLogicStatus] not pass(logic status abnormal)")
                if "zh" == lang:
                    errMsg += u"\n硬盘（Disk Location：" + str(diskLocation) + u"）逻辑状态不正常（" + str(diskLogicStatus) + u"）。"
                else:
                    errMsg += u"\nThe Logical status of disk(Disk Location: " + str(diskLocation) + u") is abnormal(" + str(diskLogicStatus) + u")."
        
        if flag:
            PY_LOGGER.info("Inspect[DiskLogicStatus] pass!")
                            
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[DiskLogicStatus] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[DiskLogicStatus] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
