# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        
        #不同的版本，CLI命令可能不一样，挑选出当前版本支持的CLI命令并获得对应回显结果 
        cmd, cliRet = getSupportCliRet(cli, ["showdisk -t", "showdisk -p"])
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, cliRet, lang, True)
        if RET_FAIL == preRet:
            PY_LOGGER.error("Inspect[DiskPhysicalStatus] not pass(cliRet invalid)")
            return False, cliRet, errMsg    
        
        formatFunction = cHandleTypeList(cliRet)
        diskList = formatFunction.handle()
        
        for dictInfo in diskList:
            diskLocation = str(dictInfo.get('Disk Location'))
            diskPhyStatus = str(dictInfo.get('Physical status')) if dictInfo.get('Physical status') else str(dictInfo.get('Physical Status'))
            diskCircleStatus = str(dictInfo.get('Double/Single Circle'))
            
            if cmd == "showdisk -t":
                if diskPhyStatus not in ['Normal', 'Sleep'] or diskCircleStatus not in ['Double']:
                    flag = False
                    PY_LOGGER.error("Inspect[DiskPhysicalStatus] not pass(showdisk -t physical disk abnormal)")
                    if "zh" == lang:
                        errMsg += u"\n硬盘（Disk Location：" + str(diskLocation) + u"）状态不正常（Physical Status：" + diskPhyStatus + u"，Double/Single Circle：" + diskCircleStatus + u"）。"
                    else:
                        errMsg += u"\nThe disk(Disk Location: " + str(diskLocation) + u") status is abnormal(Physical Status: " + diskPhyStatus + u", Double/Single Circle: " + diskCircleStatus + u")."
            
            #老的版本，没有showdisk -t命令，无法查询到Double/Single Circle字段的值
            else:
                if diskPhyStatus not in ['Normal', 'Sleep']:
                    flag = False
                    PY_LOGGER.error("Inspect[DiskPhysicalStatus] not pass(showdisk -p physical disk abnormal)")
                    if "zh" == lang:
                        errMsg += u"\n硬盘（Disk Location：" + str(diskLocation) + u"）状态不正常（Physical Status：" + diskPhyStatus + u"）。"
                    else:
                        errMsg += u"\nThe disk(Disk Location: " + str(diskLocation) + u") status is abnormal(Physical Status: " + diskPhyStatus + u")." 
            
        if flag:
            PY_LOGGER.info("Inspect[DiskPhysicalStatus] pass!")
                            
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[DiskPhysicalStatus] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
      
    except:
        PY_LOGGER.error("Inspect[DiskPhysicalStatus] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
