# -*- coding: UTF-8 -*-
import os
import re
import traceback
from common.cTV1R1 import *
from common.utils import *
from common.cliMgt import *
from common.modeMgt import *
from common import constant
def getDiskNameInfo(mmlRet):
    # *************************************************************#
    # 函数名称: getDiskNameInfo
    # 功能说明: 将硬盘的位置与硬盘的盘符信息映射一一对应关系
    # 返回  :  NameDict---硬盘位置与盘符的键值对{"(0,4)":"sda"}
    # *************************************************************#
    nameDict = {}
    diskName = ""
    diskLocation = ""
    cliRetLines = mmlRet.splitlines()
    for line in cliRetLines:
    
        reg_headline = re.compile("Disk") 
        match_headline = reg_headline.search(line)
        if match_headline:
            diskStr = line.split("]")[0]
            nameList = diskStr.split(":")
            if len(nameList) > 1:
                diskLocation = "(" + nameList[0][5:] + "," + nameList[1] + ")"
        reg_headline = re.compile("sd") 
        match_headline = reg_headline.search(line)
        if match_headline:
            diskName = line.split("(")[0].strip()
        if diskLocation != "" and diskName != "":
            nameDict.setdefault(diskLocation, diskName)
            diskLocation = ""
            diskName = ""

    return nameDict

def getDiskInfo(cliRet,lang):
    #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
    diskDict = {}
    diskLocation = ''
    type = ''
    errMsg = ''
    preRet, errMsg = preCheckCliRet("showdisk -p", cliRet, lang, True)
    if RET_FAIL == preRet:
        return diskDict, errMsg
    formatFunction = cHandleTypeList(cliRet)
    diskList = formatFunction.handle()
    PY_LOGGER.info("diskList:" + str(diskList))
    for diskInfo in diskList:
        diskLocation = str(diskInfo.get('Disk Location'))
        type = str(diskInfo.get('Physical type'))
        if diskLocation != "" and type in ["SATA", "SAS", "FC"]:
            diskLocation = diskLocation.replace(" ","")
            diskDict.setdefault(diskLocation, type)
            diskLocation = ""
            type = ""
    return diskDict, errMsg

def getUsageInfoByName(cliRet, nameList):
    # *************************************************************#
    # 函数名称: getUsageInfoByName
    # 功能说明: 获取盘符的利用率值(-iostat -x 2 31回显的解析)
    # 返回  :  usageDict---硬盘位置与盘符的键值对{"sda":"0.51,0.52"}
    # *************************************************************#
    tmplist = cliRet.split("avg-cpu:")
    usageDict = {}
    for str in tmplist[2:]:
        lineList = str.splitlines()
        for line in lineList:
            if len(line.split()) != 0:
                name = line.split()[0]
                usage = line.split()[-1]
                if re.match("[0-9]+.[0-9]+",usage) == None:
                    usage = 0.0
                if name in nameList and usage != "":
                    if usageDict.has_key(name):
                        usages = usageDict.get(name).append(float(usage))
                        usageDict.setdefault(name,usages)
                        
                    else:
                        usageDict.setdefault(name,[float(usage)])
    return usageDict

def execute(cli):
    """
    1 如果当前系统软件版本在V100R005C02SPC010(1.03.03.530.T06)及之后，则继续执行以下步骤；否则检查结果为不涉及；
     1）存在一端控制器上10次的利用率超过阈值（SATA盘60%、SAS/FC盘80%）的盘，则检查结果为不通过。
     2）存在一端控制器上10次的利用率超过阈值（SATA盘40%、SAS/FC盘60%）的盘，则检查结果为建议优化。
     3）其他情况，检查结果为通过。
    3 命令执行失败，检查结果为不通过。
   （备注：iostat -x 2 31命令执行结果中，%utils列代表各硬盘的利用率）
    # *****************************************************************************************#
    """
    
    failFlag = False
    warnFlag = False
    peerCheckFlag = True
    flag = True
    allCliRet = ""
    errMsg = ""
    lang = py_java_env.get("lang")
    try:
        
        localIpList = []
        peerIpList = []
        peerUsageDict = {}

        sysVer,cliRet = getDevVer(cli)
        allCliRet += cliRet
        if sysVer < "1.04.01.208.T10":
            return constant.NO_SUPPORT,allCliRet,errMsg
        #获取系统是否为单控还是双控
        sysMode, itemCliRet, itemErrMsg = getSysModeState(cli, py_java_env)
        allCliRet += itemCliRet
        if sysMode not in [MODE_SINGLE, MODE_DOUBLE]:
            PY_LOGGER.error("Inspect[DiskSpaceUsage] not pass(Get unkown system mode)")
            return False, allCliRet, itemErrMsg
        
        #如果系统双控正常则需要登录两个控制器
        isDoubleSys = True if MODE_DOUBLE == sysMode else False
        
        #获取控制器的信息，识别当前控制器是A还是B
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        isSuccess, cliRet, localCtrlID, errInfo = getLocalCtrlID(cli,py_java_env)
        allCliRet += cliRet
        errMsg += errInfo
        if localCtrlID == "":
            return False, allCliRet, errMsg
        peerCtrlID = "A"
        if localCtrlID == "A":
            peerCtrlID = "B"

        #不同的版本，CLI命令可能不一样，挑选出当前版本支持的CLI命令并获得对应回显结果 
        cmd, cliRet = getSupportCliRet(cli, ["showdisk -p"])

        diskDict, errInfo= getDiskInfo(cliRet,lang)
        PY_LOGGER.info("diskDict:" + str(diskDict))
        errMsg += errInfo
        allCliRet += cliRet
        if not diskDict:
            return False, allCliRet, errMsg

        #获取本端和对端的MML回文结果
        isSuccess, localCliRet, peerCliRet = execMmlCmd(cli, "dev diskinfo", py_java_env, PY_LOGGER, isDoubleSys)
        allCliRet += localCliRet
        allCliRet += peerCliRet
        if isSuccess == False:
            errMsg += peerCliRet
            return isSuccess, allCliRet, errMsg

        #获取本端和对端盘符与位置编号对应关系
        localNameDict = getDiskNameInfo(localCliRet)
        peerNameDict = getDiskNameInfo(peerCliRet)
        PY_LOGGER.info("localNameDict:" + str(localNameDict))
        PY_LOGGER.info("peerNameDict:" + str(peerNameDict))
        
        #进入本端控制器的DEBUG模式
        isSuccess, cliRet, errInfo = changeAnyMode2Debug(cli,py_java_env)
        errMsg += errInfo
        allCliRet += cliRet
        if isSuccess == False:
            return isSuccess, allCliRet, errMsg

        #获取盘符对应的硬盘利用率值
        debugRet = cliMgt.execCmdWithTimout(cli,"iostat -x 2 31", 300)
        allCliRet += debugRet
        if re.search('TOOLKIT_SEND_CMD_TIME_OUT',debugRet,re.IGNORECASE):
            if lang == "zh":
                errMsg += u"\n执行命令超时。"
            else:
                errMsg += "\nExecute command time out."
            return False, allCliRet, errMsg
        localUsageDict = getUsageInfoByName(debugRet,localNameDict.values())

        if isDoubleSys:
            #登录对端控制器
            #获取盘符对应的硬盘利用率值
            isSuccess, debugRet, errInfo = sendDebugCmd2PeerInDebugMode(cli,"iostat -x 2 31", py_java_env, 300)
            allCliRet += debugRet
            errMsg += errInfo
            if isSuccess == False:
                peerCheckFlag = False
            else:
                peerUsageDict = getUsageInfoByName(debugRet,peerNameDict.values())
        PY_LOGGER.info("peerUsageDict:" + str(peerUsageDict))
        locationList = diskDict.keys()
        locationList.sort()
        PY_LOGGER.info("locationList:" + str(locationList))
        failNum = 0.0
        warnNum = 0.0
        for locate in locationList:
            localUsageNum = 0
            peerUsageNum = 0
            localUsageList = []
            peerUsageList = []
            ctrlIDList = []
            type = diskDict.get(locate)
            if type == "SATA":
                failNum = 60.0
                warnNum = 40.0
            elif type in ["SAS","FC"]:
                failNum = 80.0
                warnNum = 60.0
            
            localUsageList = localUsageDict.get(localNameDict.get(locate))
            if localUsageList != None and len(localUsageList) > 10:
                localUsageList.sort()
                localUsageNum = localUsageList[-10]

            if isDoubleSys:
                peerUsageList = peerUsageDict.get(peerNameDict.get(locate))
                if peerUsageList != None and len(peerUsageList) > 10:
                    peerUsageList.sort()
                    peerUsageNum = peerUsageList[-10]
                PY_LOGGER.info("peerUsageNum:" + str(peerUsageNum))
                PY_LOGGER.info("peerUsageList:" + str(peerUsageList))
            PY_LOGGER.info("locate:" + locate)
            PY_LOGGER.info("type:" + type)
            PY_LOGGER.info("diskName:" + str(localNameDict.get(locate,"")))
            PY_LOGGER.info("localUsageList:" + str(localUsageList))
            PY_LOGGER.info("localUsageNum:" + str(localUsageNum))

            
            #本端的硬盘的利用率检查
            if localUsageNum > failNum:
                failFlag = True
                ctrlIDList.append(localCtrlID)
            elif localUsageNum > warnNum:
                warnFlag = True
                ctrlIDList.append(localCtrlID)
            if isDoubleSys:
                #对端的硬盘的利用率检查
                if peerUsageNum > failNum:
                    ctrlIDList.append(peerCtrlID)
                    failFlag = True
                elif peerUsageNum > warnNum:
                    ctrlIDList.append(peerCtrlID)
                    warnFlag = True
            
            locateList = locate.replace("(","").replace(")","").split(",")
            for ctrlId in ctrlIDList:
                if lang == "zh":
                    errMsg +=u"\n硬盘(框号:"+ locateList[0] + u",槽位号:" + locateList[1] + u",控制器:" + ctrlId + u")的IO利用率超过阈值。"
                else:
                    errMsg +="\nThe I/O usage of disks (enclosure ID:"+ locateList[0] + ",slot ID:" + locateList[1] + ",controller:" + ctrlId + ")exceeds the threshold."
        if peerCheckFlag == False or failFlag:
            flag = False
        elif warnFlag:
            flag = constant.WARNING
        if flag == True:
            PY_LOGGER.info("Inspect[DiskSpaceUsage] pass!")
        return flag, allCliRet, errMsg

    except:
        PY_LOGGER.error("Inspect[DiskSpaceUsage] catch except of trace back:" + str(traceback.format_exc()))
        return False, allCliRet, getExceptionMsg(lang)
    finally:
        changeAnyMode2Cli(cli)
