# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        exsitExpand = False
        
        cmd = "showsubrack"
        cliRet = cliMgt.execCmd(cli, cmd)
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, cliRet, lang)
        if RET_FAIL == preRet:
            flag = False
            PY_LOGGER.error("Inspect[EnclosureStatus] not pass(cliRet1 invalid)")
            return flag, cliRet, errMsg
        
        #第二个参数传入[]表示获取所有key值对应的value
        formatFunction = cHandleTypeList(cliRet)
        listDict = formatFunction.handle()
        for dictInfo in listDict:
            if "Expander" == dictInfo.get("Type") and "Online" == dictInfo.get("Status"):
                exsitExpand = True
            elif "Expander" == dictInfo.get("Type") and "Online" != dictInfo.get("Status"):
                flag = False
                PY_LOGGER.error("Inspect[EnclosureStatus] not pass(expander abnormal)")
                if "zh" == lang:
                    errMsg += u"\n级联框（Subrack ID：" + str(dictInfo.get("Subrack ID")) + u"）状态不正常（" + str(dictInfo.get("Status")) + u"）。"
                else:
                    errMsg += u"\nThe Status of expander(Subrack ID: " + str(dictInfo.get("Subrack ID")) + u") is abnormal(" + str(dictInfo.get("Status")) + u")."
        
        
        #级联框存在时执行showexpboardinfo命令查看级联框状态是否正常
        if exsitExpand:
            expBoardRecord = {}
            #不同的版本，CLI命令可能不一样，挑选出当前版本支持的CLI命令并获得对应回显结果 
            cmd, itemCliRet = getSupportCliRet(cli, ["showexpboardinfo", "showexpboard"])
            cliRet += itemCliRet
            
            #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
            preRet, itemErrMsg = preCheckCliRet(cmd, itemCliRet, lang)
            if RET_FAIL == preRet:
               flag = False
               PY_LOGGER.error("Inspect[EnclosureStatus] not pass, cliRet2 is invalid")
               errMsg += itemErrMsg
            else:
                formatFunction = cFastTypeDict(itemCliRet)
                listDict = formatFunction.handle()
                for dictInfo in listDict:
                    #一块级联板不让通过提示数量不足，2014/08/08 modified Begin
                    subrackId = str(dictInfo.get("Subrack ID"))
                    if expBoardRecord.get(subrackId):
                        expBoardRecord[subrackId] += 1
                    else:
                        expBoardRecord[subrackId] = 1
                    #一块级联板不让通过提示数量不足，2014/08/08 modified End
                        
                    if dictInfo.get("Status") not in ["Online", "On", "Normal"]:
                        flag = False
                        PY_LOGGER.error("Inspect[EnclosureStatus] not pass(board abnormal)")
                        if "zh" == lang:
                            errMsg += u"\n级联板（Subrack ID：" + subrackId + u"，Expander Board ID：" + str(dictInfo.get("Expander Board ID")) + u"）状态不正常（" + str(dictInfo.get("Status")) + u"）。"
                        else:
                            errMsg += u"\nThe Status of expander board(Subrack ID: " + subrackId + u", Expander Board ID: " + str(dictInfo.get("Expander Board ID")) + u") is abnormal(" + str(dictInfo.get("Status")) + u")."
        
            #一块级联板不让通过提示数量不足，2014/08/08 modified Begin
            for subrackId in expBoardRecord.keys():
                if expBoardRecord.get(subrackId) < 2:
                    flag = False
                    PY_LOGGER.error("Inspect[EnclosureStatus] not pass(insufficient)")
                    if "zh" == lang:
                        errMsg += u"\n级联框（Subrack ID：" + subrackId + u"）中级联板数量不足。"
                    else:
                        errMsg += u"\nThe number of expander board in Subrack(" + subrackId + u") is insufficient."
            #一块级联板不让通过提示数量不足，2014/08/08 modified End
                
        if flag:
             PY_LOGGER.info("Inspect[EnclosureStatus] pass!")
                         
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[EnclosureStatus] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[EnclosureStatus] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
