# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        
        cmd = "showsubrack"
        
        cliRet = cliMgt.execCmd(cli,cmd)
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, cliRet, lang)
        if RET_FAIL == preRet:
            flag = False
            PY_LOGGER.error("Inspect[EnclosureTemperature] not pass(cliRet invalid)")
            return flag, cliRet, errMsg

        #第二个参数传入[]表示获取所有key值对应的value
        formatFunction = cHandleTypeList(cliRet, ["Subrack ID", "Type", "Status", "Temperature"])
        listDict = formatFunction.handle()
        
        for dictInfo in listDict:
            temperature = str(dictInfo.get("Temperature"))
            if "Expander" == dictInfo.get("Type") and "Online" == dictInfo.get("Status"):
                if not isValidVal(temperature) or not temperature.isdigit():
                    flag = False
                    PY_LOGGER.error("Inspect[ControllerTemperature] not pass")   
                    if "zh" == lang:
                        errMsg += u"\n获取级联框（Subrack ID：" + str(dictInfo.get("Subrack ID")) + u"）温度值无效（" + str(temperature) + u"）。"
                    else:
                        errMsg += u"\nThe obtained enclosure(Subrack ID: " + str(dictInfo.get("Subrack ID")) + u") temperature is invalid(" + str(temperature) + u")."
                    continue
                
                if temperature and temperature.isdigit() and int(temperature) >= 56:
                    flag = False
                    PY_LOGGER.error("Inspect[EnclosureTemperature] not pass(too high degree)")   
                    if "zh" == lang:
                        errMsg += u"\n级联框（Subrack ID：" + str(dictInfo.get("Subrack ID")) + u"）温度不低于56ºC（" + str(temperature) + u")。"
                    else:
                        errMsg += u"\nThe enclosure(Subrack ID: " + str(dictInfo.get("Subrack ID")) + u") temperature is not lower than 56 centigrade(" + str(temperature) + u")."
         
        if flag:
             PY_LOGGER.info("Inspect[EnclosureTemperature] pass!")
                           
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[EnclosureTemperature] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[EnclosureTemperature] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
