# -*- coding: UTF-8 -*-
import time
import traceback
from common.cTV1R1 import *
from common.utils import *
WAIT_TIME = 60

def _preHandle(cli, isDoubleSys):
    """
    # *****************************************************************************************#
    # 函数名称: _preHandle(cli)
    # 功能说明: 查询误码前需要先发送命令清除误码，为了加速速度，preinspect.py脚本里作了先行处理
    # 输入参数: cli
    # 返 回 值: 失败：False, cliRet, errMsg
    #           成功：True，localCliret, peerCliRet
    # *****************************************************************************************#
    """
    lang = py_java_env.get("lang")

    #发送fc c e命令清除双端误码信息
    iRet = execMmlCmd(cli, "fc clearerrcode all", py_java_env, PY_LOGGER, isDoubleSys)
    if not iRet[RET_FLAG]:
        return False, iRet[RET_CLI], iRet[RET_ERR_MSG]
    
    time.sleep(WAIT_TIME)
    return iRet[RET_FLAG], iRet[RET_LOCAL_CLI], iRet[RET_PEER_CLI]

def _getErrPortList(cliRet):
    """
    # *****************************************************************************************#
    # 函数名称: _getErrPortList(cliRet)
    # 功能说明: 根据回显获取有误码信息的端口号列表
    # 输入参数: cliRet
    # 返 回 值: 误码端口号列表
    # *****************************************************************************************#
    """
    errPortList = []
    lines = cliRet.splitlines()
    port = ""
    for line in lines:
        if re.match('^\s*-+\s*$', line):
            port = ""
            continue
        if "LossOfSignal" in line or "port" in line:
            continue
        
        items = line.split("|")
        if items and items[0].startswith("0x"):
            port = items[0].strip()
            continue
        else:
        
            for value in items:
                #value未去空格,判断是否是数字是永假，2014/09/16 modified Begin
                if not value or not value.strip().isdigit():
                    continue
            
                if int(value.strip()) > 0:
                    errPortList.append(port) 
                    break
                #value未去空格,判断是否是数字是永假，2014/09/16 modified Begin
    return errPortList

def _checkCliRet(cliRet, ipAddr):
    """
    # *****************************************************************************************#
    # 函数名称: _checkCliRet(cliRet, ipAddr)
    # 功能说明: 根据回显获取判断端口是否有误码信息
    # 输入参数: cliRet, ipAddr
    # 返 回 值: flag, errMsg
    # *****************************************************************************************#
    """
    flag = True
    errMsg = ""
    lang = py_java_env.get("lang")
    
    if not cliRet:
        return flag, errMsg
    
    #获取误码端口信息
    errPortList = _getErrPortList(cliRet)
    if not errPortList:
        return True, errMsg
    
    for errPort in errPortList:
        if "0x110000" <= errPort <= "0x110003" or "0x110100" <= errPort <= "0x110103":
            flag = False
            PY_LOGGER.error("Inspect[ErrorCode] not pass(front port exist err code)")
            if "zh" == lang:
                errMsg += u"\n前端端口（port：" + str(errPort) + u"）存在误码。"
            else:
                errMsg += u"\nThe Front Port(port: " + str(errPort) + u") has bit errors."
        elif "0x112000" <= errPort <= "0x112001":
            flag = False
            PY_LOGGER.error("Inspect[ErrorCode] not pass(back port exist err code)")
            if "zh" == lang:
                errMsg += u"\n后端端口（port：" + str(errPort) + u"）存在误码。"
            else:
                errMsg += u"\nThe Back Port(port: " + str(errPort) + u") has bit errors."
        elif "0x112002" <= errPort <= "0x112003":
            flag = False
            PY_LOGGER.error("Inspect[ErrorCode] not pass(mirror port exist err code)")
            if "zh" == lang:
                errMsg += u"\n镜像端口（port：" + str(errPort) + u"）存在误码。"
            else:
                errMsg += u"\nThe Mirror Port(port: " + str(errPort) + u") has bit errors."
    
    if not flag:
        PY_LOGGER.error("Inspect[ErrorCode] not pass(" + str(ipAddr) + ")")
        if "zh" == lang:
            errMsg = u"\n控制器 " + str(ipAddr) + u"：" + errMsg + u"\n"
        else:
            errMsg = u"\nController " + str(ipAddr) + u":" + errMsg + u"\n"
    
    return flag, errMsg
                
def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        
        #获取系统是否为单控还是双控
        sysMode, itemCliRet, itemErrMsg = getSysModeState(cli, py_java_env)
        if sysMode not in [MODE_SINGLE, MODE_DOUBLE]:
            PY_LOGGER.error("Inspect[ErrorCode] not pass(Get unkown system mode)")
            return False, itemCliRet, itemErrMsg
        
        isDoubleSys = True if MODE_DOUBLE == sysMode else False
                
        #查询前清除误码操作
        #根据系统当前状态来清除误码，2014/08/08 modified Begin
        iRet = _preHandle(cli, isDoubleSys)
        if not iRet[RET_FLAG]:
            PY_LOGGER.error("Inspect[ErrorCode] not pass(prehanle failed)")
            return iRet[RET_FLAG], iRet[RET_CLI], iRet[RET_ERR_MSG]
        #根据系统当前状态来清除误码，2014/08/08 modified End
        
        #发送误码查询命令
        iRet = execMmlCmd(cli, "fc allinfo", py_java_env, PY_LOGGER, isDouble=isDoubleSys)
        if not iRet[RET_FLAG]:
            PY_LOGGER.error("Inspect[ErrorCode] not pass(send fc ect failed)")
            return iRet[RET_FLAG], iRet[RET_CLI], iRet[RET_ERR_MSG]
        
        localCliRet, peerCliRet = iRet[RET_LOCAL_CLI], iRet[RET_PEER_CLI]
        cliRet = localCliRet + peerCliRet
        
        #检查本端是否有误码
        localFlag, localErrMsg = _checkCliRet(localCliRet, getLocalIpAddr(py_java_env))
        if not localFlag:
            flag = False
            errMsg += localErrMsg
    
        #双控时才检查对端
        if isDoubleSys:
            #检查对端是否有误码
            peerFlag, peerErrMsg = _checkCliRet(peerCliRet, getPeerIpAddr(cli, py_java_env))
            if not peerFlag:
                flag = False
                errMsg += peerErrMsg
          
        if flag:
            PY_LOGGER.info("Inspect[ErrorCode] pass!")
              
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[ErrorCode] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
          
    except:
        PY_LOGGER.error("Inspect[ErrorCode] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
    
