# -*- coding: UTF-8 -*-
import traceback
from common.utils import *
from common.logMgt import *
from common.checkMsg import init, checkMsgInfo

#每天的最大复位次数
MAX_REBOOT_NUM = 5

#最大有效复位天数
MAX_VALID_DAYS = 4

#日志带有jiff的标示
S2000S5000_LOG_TAG = " OceanStor kernel:"

#当前日志目录
S2000S5000_CUR_LOG_DIR = "/OSM/log/cur_debug/"

#历史日志目录
S2000S5000_HIS_LOG_DIR = "/OSM/log_conf_local/log/his_debug/"


def _getDay(lineInfo):
    """
    # *****************************************************************************************#
    # 函数名称: _getDay(lineInfo)
    # 功能说明: 根据带有时间的某行来获取时间（精确到天）
    # 输入参数: lineInfo
    # 输出参数: time（精确到天）
    # *****************************************************************************************#
    """
    try:
        #兼容带年份及不带年份的显示，裁剪为具体的天数后返回，2014/09/18 modified Begin
        if isLogWithYears(lineInfo):
            return lineInfo.split()[0].strip()[1:]
        else:
            return lineInfo.split()[0].strip() + " " + lineInfo.split()[1].strip()
        #兼容带年份及不带年份的显示，裁剪为具体的天数后返回，2014/09/18 modified End
    except:
        return ""

def _format2Dict(cliRet):
    """
    # *****************************************************************************************#
    # 函数名称: _format2Dict(cliRet)
    # 功能说明: 格式化查询FC后端复位信息的日志为dict(ip:dict(curday:num))两重字典格式
    # 输入参数: cliRet
    # 输出参数: dict(dict)格式（无异常显示返回{}）
    # *****************************************************************************************#
    """
    if not cliRet:
        return {}
    
    cliRetList = cliRet.splitlines()
    
    #结构为dict(ip:dict(curday:num))
    allIpCountDict = {} 
    oneIpCountDict = {}
    
    tempDay = ""
    ip = ""
    for lineInfo in cliRetList:
        if lineInfo.strip().startswith("Controller "):
            if ip and oneIpCountDict:
                allIpCountDict[ip] = oneIpCountDict
                tempDay = ""
                oneIpCountDict = {}
            ip = lineInfo.strip().replace("Controller", "").replace(" ", "")[0:-1]
        else:
            curDay = _getDay(lineInfo)
            if not curDay:
                continue
            
            #初次获取
            if not tempDay:
                tempDay = curDay
                oneIpCountDict[tempDay] = 1
            #相同天数后端复位数加1
            elif tempDay and curDay == tempDay:
                oneIpCountDict[tempDay] += 1
            #统计另一天数的记数
            elif tempDay and curDay != tempDay:
                tempDay = curDay
                oneIpCountDict[tempDay] = 1
    
    if ip and oneIpCountDict:            
        allIpCountDict[ip] = oneIpCountDict
    return allIpCountDict

def _checkCliRet(cli, cliRet, portId):
    """
    # *****************************************************************************************#
    # 函数名称: _checkCliRet(cli, cliRet, portId)
    # 功能说明: 检查FC后端复位信息的日志，看是否正常
    # 输入参数: cli, cliRet, portId
    # 输出参数: flag, cliRet, errMsg
    # *****************************************************************************************#
    """
    flag = True
    errMsg = ""
    lang = py_java_env.get("lang")
    
    ipAddrList = getIpAddrlist(cli, py_java_env)
    
    dictInfo = _format2Dict(cliRet)
    PY_LOGGER.info("Inspect[FCBackLoopReboot] Port(" + str(portId) + ") get dict info is:" + str(dictInfo))
    
    if not dictInfo:
        return True, cliRet, errMsg
    
    for ipAddr in ipAddrList:
        if dictInfo.has_key(ipAddr):
            validCount = 0
            for days in dictInfo.get(ipAddr).keys():
                #大于5次才算一天有效复位天数，2014/08/08 modified Begin
                if dictInfo.get(ipAddr).get(days) > MAX_REBOOT_NUM:
                    validCount += 1
                #大于5次才算一天有效复位天数，2014/08/08 modified End
                    
            if validCount > MAX_VALID_DAYS:
                flag = False
                if "zh" == lang:
                    errMsg += u"\n控制器" + str(ipAddr) + u"（" + str(portId) + u"端口）FC环路不正常。"
                else:
                    errMsg += u"\nThe FC circle of controller " + str(ipAddr) + u"(" + str(portId) + u" Port) is abnormal."
    if errMsg:
        errMsg += "\n"
    return flag, cliRet, errMsg   

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""

        #20端口检测
        KEY_WORD = ">>>>> FC port fc_ini(_)?0"
        PY_LOGGER.info("Inspect[FCBackLoopReboot] port20 begin!")
        flag20, cliRet20, errMsg20, existKeyWord20 = checkMsgInfo(cli, py_java_env, KEY_WORD, PY_LOGGER, interval=30)
        if flag20:
            PY_LOGGER.info("Inspect[FCBackLoopReboot] pass!")
        #不存在关键字的行，说明存在异常直接退出
        elif not existKeyWord20:
            cliRet += cliRet20
            errMsg += errMsg20
            PY_LOGGER.error("Inspect[FCBackLoopReboot] not pass(parse abnormal)")
            return False, cliRet, errMsg
        
        #判断存在关键的行是否满足天数的记数    
        if not flag20 and existKeyWord20:
            PY_LOGGER.info("Inspect[FCBackLoopReboot] Port20 exist key word lines = \n" + str(cliRet20))
            itemFlag, itemCliRet, itemErrMsg = _checkCliRet(cli, cliRet20, 20) 
            if not itemFlag:
                flag = False
                cliRet += "Port 20 check result:" + itemCliRet
                errMsg += itemErrMsg
                PY_LOGGER.error("Inspect[FCBackLoopReboot] not pass(port20 exist keyword)")
                
        #21端口检测       
        KEY_WORD = ">>>>> FC port fc_ini(_)?1"
        PY_LOGGER.info("Inspect[FCBackLoopReboot] port21 begin!")
        flag21, cliRet21, errMsg21, existKeyWord21 = checkMsgInfo(cli, py_java_env, KEY_WORD, PY_LOGGER, interval=30)
        if flag21:
            PY_LOGGER.info("Inspect[FCBackLoopReboot] pass!")
        #不存在关键字的行，说明存在异常直接退出
        elif not existKeyWord21:
            flag = False
            cliRet += cliRet21
            errMsg += errMsg21
            PY_LOGGER.error("Inspect[FCBackLoopReboot] not pass(parse abnormal)")
            return False, cliRet, errMsg
        
        #判断存在关键的行是否满足天数的记数       
        if not flag21 and existKeyWord21:
            PY_LOGGER.info("Inspect[FCBackLoopReboot] Port21 exist key word lines = \n" + str(cliRet21))
            itemFlag, itemCliRet, itemErrMsg = _checkCliRet(cli, cliRet21, 21) 
            if not itemFlag:
                flag = False
                cliRet += "\nPort 21 check result:" + itemCliRet
                errMsg += itemErrMsg
                PY_LOGGER.error("Inspect[FCBackLoopReboot] not pass(port21 exist keyword)")
                
        if flag:
            PY_LOGGER.info("Inspect[FCBackLoopReboot] pass!")
            cliRet = NO_INFO_MSG
            
        return flag, cliRet, errMsg
    
    except:
        PY_LOGGER.error("Inspect[FCBackLoopReboot] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
