# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        productType = str(py_java_env.get("devInfo").getDeviceType())
        flag = True
        errMsg = ""
        cliRet = cliMgt.execCmd(cli, "showinterface")
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet('showinterface', cliRet, lang)
        if RET_FAIL == preRet:
            PY_LOGGER.error("Inspect[FCLinkSpeed] not pass(cliRet invalid)")
            return False, cliRet, errMsg
        elif RET_SUC == preRet:
            PY_LOGGER.info("Inspect[FCLinkSpeed] pass(no interface information)!")
            return True, cliRet, errMsg
        
        lines = cliRet.splitlines()
        
        #回文是存在Electronic Label，不关注这部分信息，用双空格分隔筛选出符合列表结构的有效信息
        validCliRet = ""
        for line in lines:
            if len(line.split("  ")) > 5:
                validCliRet += "\n" + line
        
        formatFunction = cHandleTypeList(validCliRet)
        interfaceList = formatFunction.handle()
        
        #计算已连接的FC端口
        connectedPort = []
        for interface in interfaceList:
            ctrlId = str(interface.get('Controller'))
            interfaceId = str(interface.get('Interface ID'))
            type = str(interface.get('Type'))
            status = str(interface.get('Status'))
            #不判断接口卡类型,仅关注连接状态,2014/09/22 modified Begin
            if str(status).lower() not in ['online', 'normal']:
                continue
            #不判断接口卡类型,仅关注连接状态,2014/09/22 modified End
            #添加已连接的端口到connectedPort列表
            #S2600只有一个接口卡FCPort ID就是0，1，2，3
            #S2000和S5000有两个接口卡，FCPort ID由Interface ID与PortID共同构成
            #增加S2600 COMBO卡特殊处理，只记录Port1，对应FCPort ID 0，Port2对应FCPort ID 1 Begin
            #FC扣卡
            if "FC" in type:
                if interface.get('Port0') == 'Connected':
                    connectedPort.append((ctrlId, '0'))
                    connectedPort.append((ctrlId, interfaceId + '0'))
                if interface.get('Port1') == 'Connected':
                    connectedPort.append((ctrlId, '1'))
                    connectedPort.append((ctrlId, interfaceId + '1'))
                if interface.get('Port2') == 'Connected':
                    connectedPort.append((ctrlId, '2'))
                    connectedPort.append((ctrlId, interfaceId + '2'))
                if interface.get('Port3') == 'Connected':
                    connectedPort.append((ctrlId, '3'))
                    connectedPort.append((ctrlId, interfaceId + '3'))
            #S2600 COMBO卡：
            elif productType in ['S2600'] and "COMBO" in type:
                if interface.get('Port1') == 'Connected':
                    connectedPort.append((ctrlId, '0'))
                    connectedPort.append((ctrlId, interfaceId + '0'))
                if interface.get('Port2') == 'Connected':
                    connectedPort.append((ctrlId, '1'))
                    connectedPort.append((ctrlId, interfaceId + '1'))  
            #增加S2600 COMBO卡特殊处理，只记录Port1，对应FCPort ID 0，Port2对应FCPort ID 1 End
                
        cliRetTmp = cliMgt.execCmd(cli, "showfps")
        cliRet += cliRetTmp
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet('showfps', cliRetTmp, lang)
        if RET_FAIL == preRet:
            PY_LOGGER.error("Inspect[FCLinkSpeed] not pass(cliRet invalid)")
            return False, cliRet, errMsg
        elif RET_SUC == preRet:
            PY_LOGGER.info("Inspect[FCLinkSpeed] pass(no FC Port information)!")
            return True, cliRet, errMsg
          
        formatFunction = cHandleTypeList(cliRetTmp)
        FCPortList = formatFunction.handle()
        
        for FCPortInfo in FCPortList:
            ctrlID = str(FCPortInfo.get('Controller'))
            portID = str(FCPortInfo.get('FCPort ID'))
            speed = str(FCPortInfo.get('Speed'))
            #修改比较值，2014/09/12 modified Begin
            if (ctrlID, portID) in connectedPort and speed == '2G':
            #修改比较值，2014/09/12 modified End
                flag = WARNING
                PY_LOGGER.error("Inspect[FCLinkSpeed] not pass(Speed abnormal)")
                break
        #增加错误描述信息，2014/09/12 modified Begin
        if flag == WARNING:
            if "zh" == lang:
                errMsg += u"\n设备支持4G，请确认是否有4G的需求，如果有，可以修改为自适应模式。如果不需要，仍保持当前设置。"
            else:
                errMsg += u"\nThe FC port speed have supported 4G, if you have the requirement, please set to automatic mode, otherwise, you can ignore this issue."
        #增加错误描述信息，2014/09/12 modified End
        
        if flag == PASS:
            PY_LOGGER.info("Inspect[FCLinkSpeed] pass!")
            
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[FCLinkSpeed] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[FCLinkSpeed] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
