# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        flag = True
        errMsg = ""
        cliRetTmp = cliMgt.execCmd(cli, "showfps")
        cliRet += cliRetTmp
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet('showfps', cliRetTmp, lang)
        if RET_FAIL == preRet:
            PY_LOGGER.error("Inspect[FCLinkSpeed] not pass(cliRet invalid)")
            return False, cliRet, errMsg
        elif RET_SUC == preRet:
            PY_LOGGER.info("Inspect[FCLinkSpeed] pass(no FC Port information)!")
            return True, cliRet, errMsg
          
        formatFunction = cHandleTypeList(cliRetTmp)
        FCPortList = formatFunction.handle()
        
        for FCPortInfo in FCPortList:
            ctrlID = str(FCPortInfo.get('Controller'))
            portID = str(FCPortInfo.get('FCPort ID'))
            speed = str(FCPortInfo.get('Speed'))
            cfgSpeed = str(FCPortInfo.get('Cfg Speed'))
            #修改比较值，2014/09/17 modified Begin
            if speed == "2G" and cfgSpeed == "2G":
            #修改比较值，2014/09/17 modified End
                flag = WARNING
                PY_LOGGER.error("Inspect[FCLinkSpeed] not pass(Speed abnormal)")
                break
        #增加错误描述信息，2014/09/17 modified Begin
        if flag == WARNING:
            if "zh" == lang:
                errMsg += u"\n设备支持4G，请确认是否有4G的需求，如果有，可以修改为自适应模式。如果不需要，仍保持当前设置。"
            else:
                errMsg += u"\nThe FC port speed have supported 4G, if you have the requirement, please set to automatic mode, otherwise, you can ignore this issue."
        #增加错误描述信息，2014/09/17 modified End
        
        if flag == PASS:
            PY_LOGGER.info("Inspect[FCLinkSpeed] pass!")
            
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[FCLinkSpeed] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[FCLinkSpeed] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
