# -*- coding: UTF-8 -*-
import os
import re
import traceback
from common.cTV1R1 import *
from common.utils import *
from common.cliMgt import *
from common.modeMgt import *
from common import constant

def execute(cli):
    """
    步骤1 以admin用户登录每个控制器。
    步骤2 执行showport获取状态为"Link up"的FC端口信息。
    步骤3 分别执行developer,mml，进入MML模式。
    步骤4 执行MML命令fc allinfo命令获取端口信息。
    步骤5 执行MML命令fc showxchg portid，获取端口的FC xchg资源信息。
    # FC XCHG资源检查#
    # 1 端口的Free/(Free+Aborted+IniBusy+TgtBusy+Retry)的计算结果小于0.1时检查结果为不通过，否则检查结果为通过。
      2 命令执行失败，则检查结果为不通过。
      【备注：fc showxchg portid命令执行结果中
       ,port表示端口号，Free表示当前可以使用的驱动IO资源数，IniBusy表示启动器正在使用的驱动IO资源，TgtBusy表示目标器正在使用的驱动IO资源。
       Free/(Free+Aborted+IniBusy+TgtBusy+Retry)小于0.1，表示当前端口IO并发异常】
    # *****************************************************************************************#
    """
    
    failFlag = False
    flag = True
    allCliRet = ""
    errMsg = ""
    lang = py_java_env.get("lang")
    try:
        
        #获取系统是否为单控还是双控
        sysVer,cliRet = getDevVer(cli)
        allCliRet += cliRet
        if sysVer < "1.03.03.525.T02":
            return constant.NO_SUPPORT,allCliRet,errMsg

        sysMode, itemCliRet, itemErrMsg = getSysModeState(cli, py_java_env)
        allCliRet += itemCliRet
        errMsg += itemErrMsg
        if sysMode not in [MODE_SINGLE, MODE_DOUBLE]:
            PY_LOGGER.error("Inspect[FCxchg] not pass(Get unkown system mode)")
            return False, allCliRet, errMsg
        
        #如果系统双控正常则需要登录两个控制器
        isDoubleSys = True if MODE_DOUBLE == sysMode else False
        
        #获取控制器的信息，识别当前控制器是A还是B
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        isSuccess, cliRet, localCtrlID, errInfo = getLocalCtrlID(cli,py_java_env)
        allCliRet += cliRet
        errMsg += errInfo
        if localCtrlID == "":
            return False, allCliRet, errMsg
        #获取系统FC端口信息
        cmd = "showport"
        cliRet = cliMgt.execCmd(cli, cmd)
        allCliRet += cliRet
        #不存在port信息的情况，需要特殊处理
        if len(cliRet.splitlines()) <= 4:
            PY_LOGGER.info("allCliRet[FCxchg] pass!(no showport information)")
            return True, allCliRet, errMsg
        #分别返回控制器上FC端口的信息
        fcDictListA, fcDictListB = getLinkUpFCPortInfo(cliRet,lang)
        localDictList = []
        peerDictList = []
        if localCtrlID == "A":
            localDictList = fcDictListA
            peerDictList = fcDictListB
        else:
            localDictList = fcDictListB
            peerDictList = fcDictListA
        localPortIDList = convertFCPort(localDictList)
        peerPortIDList = convertFCPort(peerDictList)
        isSuccess, cliRet, errInfo = changeAnyMode2Mml(cli,py_java_env)
        errMsg += errInfo
        allCliRet += cliRet
        if not isSuccess:
            return isSuccess, allCliRet, errMsg
        for (portID,portDict) in zip(localPortIDList,localDictList):
            cmd = "fc showxchg " + portID
            
            cliRet = cliMgt.execCmd(cli, cmd)
            allCliRet += cliRet
            preRet, errInfo = preCheckCliRet(cmd, cliRet, lang)
            errMsg += errInfo
            if constant.RET_FAIL == preRet:
                return False, allCliRet, errMsg
            elif constant.RET_SUC == preRet:
                continue
            isSuccess, errInfo = countFcXchgData(cliRet,portDict,lang)
            PY_LOGGER.info("isSuccess: " + str(isSuccess))
            if isSuccess:
               failFlag = True
            errMsg += errInfo
        peerFlag = True   
        if isDoubleSys:
            #登录对端控制器
            isSuccess,cliRet,errInfo = countPeerFcXchgData(cli,py_java_env,peerPortIDList,peerDictList)
            errMsg += errInfo
            allCliRet += cliRet
            if not isSuccess:
                peerFlag = False
        PY_LOGGER.info("peerFlag:" + str(peerFlag))
        PY_LOGGER.info("failFlag:" + str(failFlag))
        if not peerFlag or failFlag:
            flag = False
        if flag:
            PY_LOGGER.info("Inspect[FCXchg] pass!")
        PY_LOGGER.info("flag:" + str(flag))
        return flag, allCliRet, errMsg

    except:
        PY_LOGGER.error("Inspect[FCXchg] catch except of trace back:" + str(traceback.format_exc()))
        return False, allCliRet, errMsg

def countFcXchgData(cliRet,portDict,lang):
    #获取showxchg回显关键字段,实例如下：
    #Port 110100 Xchg : Free=(4096) Aborted=(0) IniBusy=(0) TgtBusy=(0) Retry=(0)
    failFlag = False
    errMsg = ""
    IOData = 1
    retList = cliRet.splitlines()
    for line in retList:

        if "Port" in line:
            portXchgList = line.split() 
            Free = float(portXchgList[4].split("=")[1].replace("(", "").replace(")", ""))
            Aborted = float(portXchgList[5].split("=")[1].replace("(", "").replace(")", ""))
            IniBusy = float(portXchgList[6].split("=")[1].replace("(", "").replace(")", ""))
            TgtBusy = float(portXchgList[7].split("=")[1].replace("(", "").replace(")", ""))
            Retry = float(portXchgList[8].split("=")[1].replace("(", "").replace(")", ""))
            sum_cli_field = Free + Aborted + IniBusy + TgtBusy + Retry
            if sum_cli_field == 0:
                PY_LOGGER.warn("The sum of every key field is zero and reset to 1")
                sum_cli_field = 1
            IOData = Free / sum_cli_field
            PY_LOGGER.info("IOData: " + str(IOData))
            PY_LOGGER.info("Free: " + str(Free))
            PY_LOGGER.info("IniBusy: " + str(IniBusy))
            PY_LOGGER.info("TgtBusy: " + str(TgtBusy))
            PY_LOGGER.info("Retry: " + str(Retry))
            PY_LOGGER.info("Aborted: " + str(Aborted))
            break
    PY_LOGGER.info("IOData: " + str(IOData))
    if IOData < 0.1:
        failFlag = True
        if "zh" == lang:
            errMsg = u"\n端口(ControllerID：" + str(portDict.get("Controller ID","")) + u",BoardType：" + str(portDict.get("Board Type","")) + u",BoardID：" + str(portDict.get("Board ID","")) + u",PortID：" + str(portDict.get("Port ID","")) + u")IO资源超过阈值。"
        else:
            errMsg = "\nOn port (ControllerID:" + str(portDict.get("Controller ID","")) +",BoardType:" + str(portDict.get("Board Type","")) + ",BoardID:" + str(portDict.get("Board ID","")) + ",PortID:" + str(portDict.get("Port ID","")) + "),the number of resource I/Os exceeds the threshold. "
    PY_LOGGER.info("failFlag: " + str(failFlag))
    return failFlag, errMsg

def convertFCPort(fcDictList):
 
    """
    # *****************************************************************************************#
    # 函数名称: convertFCPort(fcDictList)
    # 功能说明: 根据port的信息，转换为MML可以识别的端口ID
    # 输入参数: fcDictList CLI中的port端口信息
    # 返 回 值: portIDList MML可以识别的端口ID列表
    # *****************************************************************************************#
   
    1、CtrlBoard的4个FC口：
    （1）0x112000、0x112001分别对应Port ID的0、1口；
    （2）0x112002、0x112003分别对应Port ID的4、5口；

    2、SubBoard的6个FC口：
    （1）0x110000、0x110001、0x110002、0x110003对应的Board ID为0，最后的两个数字00、01、02、03分别对应Port ID的0、1、2、3；
    （2）0x110100、0x110101对应的Board ID为1，最后的两个数字00、01分别对应Port ID的10、11；
    """

    portIDList = []
    for dictInfo in fcDictList:
        ctrlID = str(dictInfo.get("Controller ID"))
        boardType = str(dictInfo.get("Board Type"))
        boardID = str(dictInfo.get("Board ID"))
        portID = str(dictInfo.get("Port ID"))
       
        if boardType == "CtrlBoard":
            if portID == "0":
                portIDList.append("0x112000")
            if portID == "1":
                portIDList.append("0x112001")
            if portID == "4":
                portIDList.append("0x112002")
            if portID == "5":
                portIDList.append("0x112003")
        elif boardType == "SubBoard":
            if boardID == "1":
                if portID == "10":
                     portIDList.append("0x110100")
                if portID == "11":
                     portIDList.append("0x110101")
            if boardID == "0":
                if portID == "0":
                     portIDList.append("0x110000")
                if portID == "1":
                     portIDList.append("0x110001")
                if portID == "2":
                     portIDList.append("0x110002")
                if portID == "3":
                     portIDList.append("0x110003")
        else:
            portIDList.append("")
    return portIDList
def getLinkUpFCPortInfo(cliRet,lang):
    """
    # *****************************************************************************************#
    # 函数名称: getLinkUpFCPortInfo(cliRet)
    # 功能说明: 根据回显结果获取当前控制器上状态Link up的FC端口信息
    # 输入参数: cliRet 命令回文
    # 输入参数: lang 语言
    # 返 回 值: fcDictList返回FC端口的信息
    # *****************************************************************************************#
    """
    formatFunction = cHandleTypeList(cliRet)
    listDict = formatFunction.handle()
    PY_LOGGER.info("Inspect[FCXchg] listDict = " + str(listDict))
    fcDictListA = []
    fcDictListB = []
    for dictInfo in listDict:
        ctrlID = str(dictInfo.get("Controller ID"))
        status = str(dictInfo.get("Status"))
        type = str(dictInfo.get("Physical Type"))
        boardType = str(dictInfo.get("Board Type"))
        if status.lower() == "link up" and type.lower() == "fc" and ctrlID == "A" and boardType in ["SubBoard","CtrlBoard"]:
            fcDictListA.append(dictInfo)
        if status.lower() == "link up" and type.lower() == "fc" and ctrlID == "B" and boardType in ["SubBoard","CtrlBoard"]:
            fcDictListB.append(dictInfo)
    PY_LOGGER.info("Inspect[FCXchg] fcDictListA = " + str(fcDictListA))
    PY_LOGGER.info("Inspect[FCXchg] fcDictListB = " + str(fcDictListB))
    return fcDictListA, fcDictListB

def countPeerFcXchgData(cli,py_java_env,peerPortIDList,peerPortDictList):
    #登录对端控制器
    lang = py_java_env.get("lang")
    allCliRet = ""
    errMsg = ""
    isSuccess = True
    isSuccess, cliRet, errInfo = heartToPeerCtrl(cli,py_java_env,PY_LOGGER,5)
    allCliRet += cliRet
    errMsg += errInfo
    if not isSuccess:
        return (isSuccess, allCliRet, errMsg)
    isSuccess, cliRet, errInfo = changeAnyMode2Mml(cli,py_java_env)
    errMsg += errInfo
    allCliRet += cliRet
    if not isSuccess:
        return isSuccess, allCliRet, errMsg

    for (portID,portDict) in zip(peerPortIDList,peerPortDictList):
        cmd = "fc showxchg " + portID
        cliRet = cliMgt.execCmd(cli, cmd)
        allCliRet += cliRet
        preRet, errInfo = preCheckCliRet(cmd, cliRet, lang)
        errMsg += errInfo
        if constant.RET_FAIL == preRet:
            return False, allCliRet, errMsg
        elif constant.RET_SUC == preRet:
            continue
        failFlag, errInfo = countFcXchgData(cliRet,portDict,lang)
        errMsg += errInfo
        if failFlag:
            isSuccess = False
    try:
        switchToLocal(cli,PY_LOGGER)
    except:
        if lang == "zh":
            errMsg += u"切换到本端CLI模式失败。"
        else:
            errMsg += "Fail to switch to local CLI mode."
        return False,allCliRet,errMsg
    return isSuccess,allCliRet,errMsg
