# -*- coding: UTF-8 -*-
import os
import re
import traceback
from common.cTV1R1 import *
from common.utils import *
from common.cliMgt import *
from common.modeMgt import *
from common import constant

def execute(cli):
    """
    步骤1 以admin用户登录每个控制器。
    步骤2 分别执行debug,mml命令，进入MML模式。
    步骤3 执行MML命令fc get allxchg，获取端口的FC xchg资源信息。
    检查标准：
    1 端口的FreeExchgSum/(the exchgsum)的计算结果小于0.1时检查结果为不通过，否则检查结果为通过。
    # *****************************************************************************************#
    """
    
    
    failFlag = False
    peerFailFlag = False
    flag = True
    allCliRet = ""
    errMsg = ""
    lang = py_java_env.get("lang")
    try:

        #判断版本型号：S6800E 1.03.03.530.T06 V100R005C02SPC010
        sysVer,cliRet = getDevVer(cli)
        allCliRet += cliRet
        if sysVer < "1.04.01.208.T10":
            return constant.NO_SUPPORT,allCliRet,errMsg
        #获取系统是否为单控还是双控
        sysMode, itemCliRet, itemErrMsg = getSysModeState(cli, py_java_env)
        allCliRet += itemCliRet
        errMsg += itemErrMsg
        if sysMode not in [MODE_SINGLE, MODE_DOUBLE]:
            PY_LOGGER.error("Inspect[DiskSpaceUsage] not pass(Get unkown system mode)")
            return False, allCliRet, errMsg
        
        #如果系统双控正常则需要登录两个控制器
        isDoubleSys = True if MODE_DOUBLE == sysMode else False
        
        #获取控制器的信息，识别当前控制器是A还是B
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        isSuccess, cliRet, localCtrlID, errInfo = getLocalCtrlID(cli,py_java_env)
        allCliRet += cliRet
        errMsg += errInfo
        if localCtrlID == "":
            return False, allCliRet, errMsg
        peerCtrlID = "A"
        if localCtrlID == "A":
            peerCtrlID = "B"

        #获取本端和对端的fc get allxchg回文结果
        isSuccess, localCliRet, peerCliRet = execMmlCmd(cli, "fc get allxchg", py_java_env, PY_LOGGER, isDoubleSys)
        allCliRet += localCliRet
        allCliRet += peerCliRet
        if not isSuccess:
            errMsg += peerCliRet
            return isSuccess, allCliRet, errMsg

        #判断本端控制器端口的FreeExchgSum/(the exchgsum)的计算结果是否小于0.1
        failFlag, errInfo = countFcXchgData(localCliRet,localCtrlID,lang)
        errMsg += errInfo


        #判断对端控制器端口的FreeExchgSum/(the exchgsum)的计算结果是否小于0.1
        peerFailFlag, errInfo = countFcXchgData(peerCliRet,peerCtrlID,lang)
        errMsg += errInfo

        if failFlag or peerFailFlag:
            flag = False
        if flag == True:
            PY_LOGGER.info("Inspect[FCxchg_S2600R1] pass!")
        return flag, allCliRet, errMsg
    except:
        PY_LOGGER.error("Inspect[FCXchg] catch except of trace back:" + str(traceback.format_exc()))
        return False, allCliRet, errMsg
    finally:
        changeAnyMode2Cli(cli)

def countFcXchgData(cliRet,ctrlID,lang):
    """
    @summary: 解析fc get allxchg回文，获取FreeExchgSum 和 the exchgsum值,并判断是否超过阈值
    @param cliRet: fc get allxchg回文
           ctrlID:控制器ID
           lang：当前语言
    @return: failFlag 超过阈值的标记
             errMsg 错误消息
    """
    errNum = 0
    errMsg = ""
    IOData = 1
    failFlag = False
    retList = cliRet.splitlines()
    for line in retList:
        #获取showxchg回显关键字段,实例如下：
        #| Port  Id |exchg free num |
        # portId & FreeExchgSum is:        0 ,     1280  the exchgsum is: 1280
        # portId & FreeExchgSum is:        1 ,     1280  the exchgsum is: 1280
        if "exchgsum" in line:
            portXchgList = line.split(",") 
            portId = portXchgList[0].split()[-1]
            if len(portXchgList[1].split()) >= 5:
                freeExchgSum = portXchgList[1].split()[0]
                exchgSum = portXchgList[1].split()[-1]
                if exchgSum != "0":
                    IOData = float(freeExchgSum) / float(exchgSum)
                PY_LOGGER.info("freeExchgSum" + freeExchgSum)
                PY_LOGGER.info("exchgSum" + exchgSum)
                PY_LOGGER.info("IOData" + str(IOData))
            if IOData < 0.1:
                errNum += 1
                if "zh" == lang:
                    errMsg += u"\n端口(ControllerID：" + str(ctrlID) + u",PortID：" + str(portId) + u")IO资源超过阈值。"
                else:
                    errMsg += "\nOn port (ControllerID:" + str(ctrlID) + ",PortID:" + str(portId) + "),the number of resource I/Os exceeds the threshold. "
    if errNum > 0:
        failFlag = True
    return failFlag, errMsg